-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2026, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  T.ROUTINE_CATALOG,
  T.ROUTINE_SCHEMA,
  T.ROUTINE_NAME,
  T.SPECIFIC_NAME AS SPECIFIC_NAME,
  T.TABLE_CATALOG AS REFERENCED_OBJECT_CATALOG,
  T.TABLE_SCHEMA AS REFERENCED_OBJECT_SCHEMA,
  T.TABLE_NAME AS REFERENCED_OBJECT_NAME,
  NULL AS REFERENCED_OBJECT_SPECIFIC_NAME,
  'BASE TABLE' AS REFERENCED_OBJECT_TYPE
FROM 
  INFORMATION_SCHEMA.ROUTINE_TABLE_USAGE T
ORDER BY
  T.ROUTINE_CATALOG,
  T.ROUTINE_SCHEMA,
  T.ROUTINE_NAME
