/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.TypeMap;
import us.fatehi.utility.CollectionsUtility;
import us.fatehi.utility.Utility;

abstract class AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(AbstractRetriever.class.getName());
    final MutableCatalog catalog;
    private final SchemaCrawlerOptions options;
    private final RetrieverConnection retrieverConnection;

    AbstractRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) {
        this.retrieverConnection = Objects.requireNonNull(retrieverConnection, "No retriever connection provided");
        this.catalog = catalog;
        this.options = Objects.requireNonNull(options, "No SchemaCrawler options provided");
    }

    final boolean belongsToSchema(DatabaseObject dbObject, String catalogName, String schemaName) {
        if (dbObject == null) {
            return false;
        }
        boolean supportsCatalogs = this.retrieverConnection.isSupportsCatalogs();
        boolean belongsToCatalog = true;
        boolean belongsToSchema = true;
        if (supportsCatalogs) {
            String dbObjectCatalogName = dbObject.getSchema().getCatalogName();
            if (catalogName != null && !catalogName.equals(dbObjectCatalogName)) {
                belongsToCatalog = false;
            }
        }
        String dbObjectSchemaName = dbObject.getSchema().getName();
        if (schemaName != null && !schemaName.equals(dbObjectSchemaName)) {
            belongsToSchema = false;
        }
        return belongsToCatalog && belongsToSchema;
    }

    final NamedObjectList<SchemaReference> getAllSchemas() {
        return this.catalog.getAllSchemas();
    }

    final Map<String, String> getLimitMap() {
        HashMap<String, String> limitMap = new HashMap<String, String>();
        limitMap.put("schema-inclusion-rule", MetaDataUtility.inclusionRuleString(this.options.limitOptions().get(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion)));
        limitMap.put("table-inclusion-rule", MetaDataUtility.inclusionRuleString(this.options.limitOptions().get(DatabaseObjectRuleForInclusion.ruleForTableInclusion)));
        return limitMap;
    }

    final Map<String, String> getLimitMap(Schema schema) {
        Map<String, String> limitMap = this.getLimitMap();
        if (schema != null) {
            limitMap.put("catalog-name", Utility.trimToEmpty(this.catalog.getName()));
            limitMap.put("schema-name", Utility.trimToEmpty(schema.getName()));
        }
        return limitMap;
    }

    final RetrieverConnection getRetrieverConnection() {
        return this.retrieverConnection;
    }

    final MutableColumnDataType lookupColumnDataType(Schema schema, String databaseSpecificTypeName, int dataType) {
        Optional<MutableColumnDataType> lookupSystemColumnDataType;
        Optional<MutableColumnDataType> lookupColumnDataType;
        DataTypeLookupCandidate dataTypeLookupCandidate = this.parseDataTypeName(databaseSpecificTypeName);
        Schema lookupSchema = dataTypeLookupCandidate.schema();
        String lookupTypeName = dataTypeLookupCandidate.dataTypeName();
        MutableColumnDataType columnDataType = null;
        if (lookupSchema != null && (lookupColumnDataType = this.catalog.lookupColumnDataType(lookupSchema, lookupTypeName)).isPresent()) {
            columnDataType = lookupColumnDataType.get();
        }
        if (columnDataType == null && (lookupSystemColumnDataType = this.catalog.lookupSystemColumnDataType(lookupTypeName)).isPresent()) {
            columnDataType = lookupSystemColumnDataType.get();
        }
        if (columnDataType == null && (lookupColumnDataType = this.catalog.lookupColumnDataType(schema, lookupTypeName)).isPresent()) {
            columnDataType = lookupColumnDataType.get();
        }
        if (columnDataType == null) {
            columnDataType = this.lookupOrCreateColumnDataType(schema, lookupTypeName, DataTypeType.user_defined, dataType);
            this.catalog.addColumnDataType(columnDataType);
        }
        return columnDataType;
    }

    final MutableColumnDataType lookupOrCreateColumnDataType(Schema schema, String databaseSpecificTypeName, DataTypeType type, int javaSqlTypeInt) {
        return this.lookupOrCreateColumnDataType(schema, databaseSpecificTypeName, type, javaSqlTypeInt, null);
    }

    final MutableColumnDataType lookupOrCreateColumnDataType(Schema schema, String databaseSpecificTypeName, DataTypeType type, int javaSqlTypeInt, String mappedClassName) {
        MutableColumnDataType columnDataType = this.lookupColumnDataTypeForCreate(schema, databaseSpecificTypeName, type);
        boolean isNewColumnDataType = this.catalog.lookupColumnDataType(columnDataType.getSchema(), columnDataType.getName()).isEmpty();
        if (isNewColumnDataType) {
            JavaSqlType javaSqlType = this.retrieverConnection.getJavaSqlTypes().valueOf(javaSqlTypeInt);
            columnDataType.setJavaSqlType(javaSqlType);
            if (Utility.isBlank(mappedClassName)) {
                TypeMap typeMap = this.retrieverConnection.getTypeMap();
                Object mappedClass = typeMap.containsKey(databaseSpecificTypeName) ? typeMap.get(databaseSpecificTypeName) : typeMap.get(javaSqlType.getName());
                columnDataType.setTypeMappedClass((Class<?>)mappedClass);
            } else {
                columnDataType.setTypeMappedClass(mappedClassName);
            }
            columnDataType.withQuoting(this.getRetrieverConnection().getIdentifiers());
        }
        return columnDataType;
    }

    final Optional<MutableRoutine> lookupRoutine(String catalogName, String schemaName, String routineName, String specificName) {
        return this.catalog.lookupRoutine(new NamedObjectKey(catalogName, schemaName, routineName, specificName));
    }

    final Optional<MutableTable> lookupTable(String catalogName, String schemaName, String tableName) {
        return this.catalog.lookupTable(new NamedObjectKey(catalogName, schemaName, tableName));
    }

    final String normalizeCatalogName(String name) {
        if (this.retrieverConnection.isSupportsCatalogs()) {
            return name;
        }
        return null;
    }

    final String normalizeSchemaName(String name) {
        if (this.retrieverConnection.isSupportsSchemas()) {
            return name;
        }
        return null;
    }

    private MutableColumnDataType lookupColumnDataTypeForCreate(Schema schema, String databaseSpecificTypeName, DataTypeType type) {
        DataTypeLookupCandidate dataTypeLookupCandidate = this.parseDataTypeName(databaseSpecificTypeName);
        Schema lookupSchema = dataTypeLookupCandidate.hasSchema() ? dataTypeLookupCandidate.schema() : schema;
        String lookupTypeName = dataTypeLookupCandidate.dataTypeName();
        if (Utility.isBlank(lookupTypeName)) {
            return new MutableColumnDataType(schema, lookupTypeName, type);
        }
        MutableColumnDataType columnDataType = this.catalog.lookupColumnDataType(lookupSchema, lookupTypeName).orElse(new MutableColumnDataType(schema, lookupTypeName, type));
        return columnDataType;
    }

    private DataTypeLookupCandidate parseDataTypeName(String databaseSpecificTypeName) {
        Schema unspecifiedSchema = null;
        if (Utility.isBlank(databaseSpecificTypeName)) {
            return new DataTypeLookupCandidate(unspecifiedSchema, "");
        }
        if (!databaseSpecificTypeName.contains(".")) {
            return new DataTypeLookupCandidate(unspecifiedSchema, databaseSpecificTypeName);
        }
        Identifiers identifiers = this.getRetrieverConnection().getIdentifiers();
        String[] splitName = CollectionsUtility.splitList(databaseSpecificTypeName, "\\.");
        if (splitName.length == 0) {
            return new DataTypeLookupCandidate(unspecifiedSchema, databaseSpecificTypeName);
        }
        for (int i = 0; i < splitName.length; ++i) {
            splitName[i] = identifiers.unquoteName(splitName[i]);
        }
        Schema lookupSchema = switch (splitName.length) {
            default -> unspecifiedSchema;
            case 2 -> this.catalog.getSchemas().stream().filter(dbSchema -> dbSchema.getFullName().endsWith(splitName[0])).findFirst().orElse(unspecifiedSchema);
            case 3 -> {
                String schemaName = new SchemaReference(splitName[0], splitName[1]).getFullName();
                yield this.catalog.lookupSchema(schemaName).orElse((SchemaReference)unspecifiedSchema);
            }
        };
        String lookupTypeName = splitName[splitName.length - 1];
        return new DataTypeLookupCandidate(lookupSchema, lookupTypeName);
    }

    record DataTypeLookupCandidate(Schema schema, String dataTypeName) {
        boolean hasSchema() {
            return this.schema != null;
        }
    }
}

