/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.manager;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.AnalysisInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.ImportInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroup;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedDataContentType;
import com.ibm.db2.cmx.runtime.internal.repository.api.exception.AppDoesNotExistException;
import com.ibm.db2.cmx.runtime.internal.repository.api.exception.AppExistsException;
import com.ibm.db2.cmx.runtime.internal.repository.manager.AnalysisManagerImpl;
import com.ibm.db2.cmx.runtime.internal.repository.manager.AppImpl;
import com.ibm.db2.cmx.runtime.internal.repository.manager.BaseRepositoryManager;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RuntimeGroupImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.import2.ZipDataImporter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.AppReader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.AppWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataSourceWriter;
import com.ibm.db2.cmx.runtime.internal.repository.util.ZippedByteArray;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;

public class AppManagerImpl {
    private static final String OPMRepVersion = "2.2.1";
    private Connection connection = null;
    private String mdSchema = null;

    public AppManagerImpl(Connection connection, String string) {
        this.connection = connection;
        this.mdSchema = string;
    }

    public void createApp(String string, String string2) throws MetadataException {
        this.validateAppDoesNotExist(string, string2);
        this.createAppImpl(string, string2);
    }

    public void removeApp(String string, String string2) throws MetadataException {
        this.validateAppExists(string, string2);
        this.removeAppImpl(string, string2);
    }

    public List<RuntimeGroup> getApps() throws MetadataException {
        AppReader appReader = AppReader.getInstance(this.mdSchema);
        ArrayList<RuntimeGroup> arrayList = new ArrayList<RuntimeGroup>();
        List<AppImpl> list = appReader.getApps(this.connection);
        for (AppImpl appImpl : list) {
            arrayList.add(new RuntimeGroupImpl(appImpl.getKey(), appImpl.getName(), appImpl.getVersion(), false, null));
        }
        return arrayList;
    }

    public void setData(String string, String string2, InputStream inputStream, String string3) throws MetadataException {
        this.validateAppExists(string, string2);
        this.removeAppImpl(string, string2);
        int n2 = this.createAppImpl(string, string2);
        MetadataSourceWriter metadataSourceWriter = MetadataSourceWriter.getInstance(this.mdSchema);
        ZippedByteArray zippedByteArray = ZippedByteArray.getZippedByteArray(inputStream);
        String string4 = SavedDataContentType.PDQXML.getSqlValue();
        int n3 = metadataSourceWriter.createEntry(this.connection, string4, string3);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(zippedByteArray.getData());
        metadataSourceWriter.setContent(this.connection, n3, byteArrayInputStream);
        if (zippedByteArray.getOriginalDataLength() <= 0) {
            String string5 = Messages.getText("ERR_STMTS_REQUIRED_FOR_REPOSITORY", OPMRepVersion);
            throw new MetadataException(string5, null);
        }
        this.shredData(string, string2, n2, string3, n3, zippedByteArray.getData());
    }

    public ImportInfo importData(String string, String string2, InputStream inputStream, RepositoryVersion repositoryVersion) throws MetadataException {
        this.validateAppDoesNotExist(string, string2);
        int n2 = this.createAppImpl(string, string2);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipDataImporter zipDataImporter = new ZipDataImporter(this.connection, this.mdSchema, repositoryVersion);
        ImportInfo importInfo = null;
        try {
            importInfo = zipDataImporter.loadApplication(zipInputStream, n2);
            if (importInfo.getNumStatementsAdded() == 0) {
                byte[] byArray = zipDataImporter.getZippedPdqxmlContent();
                Integer n3 = zipDataImporter.getPdqxmlContentMetadataSourceKey();
                if (byArray != null) {
                    this.shredData(string, string2, n2, "PDQXML", n3, byArray);
                } else {
                    String string3 = Messages.getText("ERR_STMTS_REQUIRED_FOR_REPOSITORY", OPMRepVersion);
                    throw new MetadataException(string3, null);
                }
            }
            MetadataSourceWriter.getInstance(this.mdSchema).removeOrphanedEntries(this.connection);
        }
        catch (IOException iOException) {
            String string4 = Messages.getText("ERR_IMPORT_RUNTIME_GROUP_VERSION", string, string2);
            throw new MetadataException(string4, iOException);
        }
        return importInfo;
    }

    private void shredData(String string, String string2, int n2, String string3, int n3, byte[] byArray) throws MetadataException {
        AnalysisManagerImpl analysisManagerImpl = new AnalysisManagerImpl(this.connection, this.mdSchema);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
        AnalysisInfo analysisInfo = null;
        try {
            zipInputStream.getNextEntry();
            analysisInfo = analysisManagerImpl.analyzeApp(n2, string3, zipInputStream, n3);
        }
        catch (IOException iOException) {
            String string4 = Messages.getText("ERR_CANNOT_READ_PDQXML_CONTENT_FOR_RUNTIMEID_VERSION", string, string2);
            throw new MetadataException(string4, iOException);
        }
        catch (MetadataException metadataException) {
            String string5 = Messages.getText("ERR_CANNOT_LOAD_PDQXML_CONTENT_FOR_RUNTIMEID_VERSION", string, string2);
            throw new MetadataException(string5, metadataException);
        }
        if (analysisInfo.getNumStatementsAdded() <= 0) {
            String string6 = Messages.getText("ERR_STMTS_REQUIRED_FOR_REPOSITORY", OPMRepVersion);
            throw new MetadataException(string6, null);
        }
    }

    private int createAppImpl(String string, String string2) throws MetadataException {
        AppWriter appWriter = AppWriter.getInstance(this.mdSchema);
        int n2 = appWriter.createEntry(this.connection, string, string2);
        return n2;
    }

    private void removeAppImpl(String string, String string2) throws MetadataException {
        MetadataSourceWriter.getInstance(this.mdSchema).removeEntriesForApp(this.connection, string, string2, false);
        AppWriter.getInstance(this.mdSchema).removeApp(this.connection, string, string2);
        BaseRepositoryManager.removeOrphanedEntries(this.connection, this.mdSchema);
    }

    private void validateAppDoesNotExist(String string, String string2) throws MetadataException {
        AppReader appReader = AppReader.getInstance(this.mdSchema);
        int n2 = appReader.getAppKeyFor(this.connection, string, string2);
        if (n2 != -1) {
            String string3 = Messages.getText("ERR_RUNTIME_GROUP_VERSION_EXISTS", string, string2);
            throw new AppExistsException(string3, null);
        }
    }

    private void validateAppExists(String string, String string2) throws MetadataException {
        AppReader appReader = AppReader.getInstance(this.mdSchema);
        int n2 = appReader.getAppKeyFor(this.connection, string, string2);
        if (n2 == -1) {
            String string3 = Messages.getText("ERR_RUNTIME_GROUP_VERSION_DOES_NOT_EXIST", string2, string);
            throw new AppDoesNotExistException(string3, null);
        }
    }
}

