/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.lang.reflect.Executable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

public class ClientProfile
extends Properties {
    private static final long serialVersionUID = -4472014940429606620L;
    private static final String profile_name = "ora-net-profile";
    private static final String shared_profile_name = "ora-shared-profile";
    private boolean isWeakCryptoEnabled = false;
    private boolean isServerUsingWeakCrypto = false;
    private long anoVersion = 0L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    public ClientProfile() {
    }

    public ClientProfile(@Blind(value=PropertiesBlinder.class) Properties up) {
        if (up.containsKey("oracle.net.profile")) {
            this.put("oracle.net.profile", up.getProperty("oracle.net.profile"));
        }
        this.put("oracle.net.authentication_services", up.getProperty("oracle.net.authentication_services", "()"));
        this.isServerUsingWeakCrypto = this.isWeakCryptoEnabled = Boolean.valueOf(up.getProperty("oracle.net.allow_weak_crypto", "true")).booleanValue();
        this.put("oracle.net.encryption_client", up.getProperty("oracle.net.encryption_client", "ACCEPTED"));
        this.put("oracle.net.encryption_types_client", up.getProperty("oracle.net.encryption_types_client", "()"));
        this.put("oracle.net.crypto_checksum_client", up.getProperty("oracle.net.crypto_checksum_client", "ACCEPTED"));
        this.put("oracle.net.crypto_checksum_types_client", up.getProperty("oracle.net.crypto_checksum_types_client", "()"));
        this.setProperty("oracle.net.setFIPSMode", up.getProperty("oracle.net.setFIPSMode", "false"));
        String jaasConfigModuleName = up.getProperty("oracle.net.KerberosJaasLoginModule");
        if (jaasConfigModuleName != null) {
            this.setProperty("oracle.net.KerberosJaasLoginModule", jaasConfigModuleName);
        }
        this.put("oracle.net.crypto_seed", up.getProperty("oracle.net.crypto_seed", ""));
        String tmp = up.getProperty("oracle.net.KerberosRealm");
        if (tmp != null) {
            this.put("oracle.net.KerberosRealm", tmp);
        }
        this.put("oracle.net.kerberos5_mutual_authentication", up.getProperty("oracle.net.kerberos5_mutual_authentication", "false"));
        if (up.getProperty("oracle.net.kerberos5_cc_name") != null) {
            this.put("oracle.net.kerberos5_cc_name", up.getProperty("oracle.net.kerberos5_cc_name"));
        }
    }

    public boolean useWeakCrypto() {
        return this.isWeakCryptoEnabled && this.isServerUsingWeakCrypto;
    }

    public boolean isWeakCryptoEnabled() {
        return this.isWeakCryptoEnabled;
    }

    public void setANOVersion(long anoVersion) {
        if (this.anoVersion != 0L) {
            return;
        }
        this.anoVersion = anoVersion;
        int majorVersion = (int)(anoVersion >> 24) & 0xFF;
        int releaseUpdateRevision = (int)(anoVersion >> 12) & 0xFF;
        this.isServerUsingWeakCrypto = majorVersion < 23 && releaseUpdateRevision < 1;
    }

    public boolean isServerUsingWeakCrypto() {
        return this.isServerUsingWeakCrypto;
    }

    public String[] getAuthenticationServices() {
        return this.getServices((String)this.get("oracle.net.authentication_services"));
    }

    public String[] getEncryptionServices() {
        return this.getServices((String)this.get("oracle.net.encryption_types_client"));
    }

    public String[] getDataIntegrityServices() {
        return this.getServices((String)this.get("oracle.net.crypto_checksum_types_client"));
    }

    public String getEncryptionLevel() {
        return (String)this.get("oracle.net.encryption_client");
    }

    public int getEncryptionLevelNum() {
        return this.translateAnoValue(this.getEncryptionLevel());
    }

    public String getDataIntegrityLevel() {
        return (String)this.get("oracle.net.crypto_checksum_client");
    }

    public int getDataIntegrityLevelNum() {
        return this.translateAnoValue(this.getDataIntegrityLevel());
    }

    public boolean isFIPSMode() {
        return Boolean.valueOf(this.getProperty("oracle.net.setFIPSMode", "false"));
    }

    public void print() {
        System.out.println(" ----------------------------------------");
        System.out.println(" Displaying the content of ClientProfile ");
        System.out.println(" List:");
        this.list(System.out);
        Enumeration<?> en = this.propertyNames();
        System.out.println("Enumeration has elements ? " + en.hasMoreElements());
        int i2 = 0;
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            System.out.println("Key " + i2 + " = " + key);
            System.out.println("Value = " + this.getProperty(key));
            ++i2;
        }
        System.out.println(" ----------------------------------------");
    }

    private String[] getServices(String services) {
        String mainString = this.removeParenths(services);
        StringTokenizer st = new StringTokenizer(mainString, ",");
        int tokens = st.countTokens();
        String[] items = new String[tokens];
        for (int i2 = 0; i2 < tokens; ++i2) {
            items[i2] = st.nextToken().trim();
        }
        return items;
    }

    private String removeParenths(String str) {
        int beginParenth = str.indexOf(40);
        int beginOffset = beginParenth == -1 ? 0 : beginParenth + 1;
        int endParenth = str.lastIndexOf(41);
        int endOffset = endParenth == -1 ? str.length() : endParenth;
        String result = str.substring(beginOffset, endOffset);
        return result.trim();
    }

    private int translateAnoValue(String level) {
        int levelNum = 0;
        if (level != null) {
            levelNum = level.equalsIgnoreCase("ACCEPTED") ? 0 : (level.equalsIgnoreCase("REQUESTED") ? 2 : (level.equalsIgnoreCase("REQUIRED") ? 3 : (level.equalsIgnoreCase("REJECTED") ? 1 : -1)));
        }
        return levelNum;
    }

    static {
        try {
            $$$methodRef$$$17 = ClientProfile.class.getDeclaredConstructor(Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ClientProfile.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ClientProfile.class.getDeclaredMethod("translateAnoValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ClientProfile.class.getDeclaredMethod("removeParenths", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ClientProfile.class.getDeclaredMethod("getServices", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ClientProfile.class.getDeclaredMethod("print", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ClientProfile.class.getDeclaredMethod("isFIPSMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ClientProfile.class.getDeclaredMethod("getDataIntegrityLevelNum", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ClientProfile.class.getDeclaredMethod("getDataIntegrityLevel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ClientProfile.class.getDeclaredMethod("getEncryptionLevelNum", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ClientProfile.class.getDeclaredMethod("getEncryptionLevel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ClientProfile.class.getDeclaredMethod("getDataIntegrityServices", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ClientProfile.class.getDeclaredMethod("getEncryptionServices", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ClientProfile.class.getDeclaredMethod("getAuthenticationServices", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ClientProfile.class.getDeclaredMethod("isServerUsingWeakCrypto", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ClientProfile.class.getDeclaredMethod("setANOVersion", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ClientProfile.class.getDeclaredMethod("isWeakCryptoEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ClientProfile.class.getDeclaredMethod("useWeakCrypto", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

