/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.scope;

import com.oracle.graal.python.pegparser.FutureFeature;
import com.oracle.graal.python.pegparser.ParserCallbacks;
import com.oracle.graal.python.pegparser.scope.Scope;
import com.oracle.graal.python.pegparser.sst.AliasTy;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ExceptHandlerTy;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.MatchCaseTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.PatternTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.SSTreeVisitor;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.sst.TypeIgnoreTy;
import com.oracle.graal.python.pegparser.sst.TypeParamTy;
import com.oracle.graal.python.pegparser.sst.WithItemTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ScopeEnvironment {
    private static final String GLOBAL_PARAM = "name '%s' is parameter and global";
    private static final String NONLOCAL_PARAM = "name '%s' is parameter and nonlocal";
    private static final String GLOBAL_AFTER_ASSIGN = "name '%s' is assigned to before global declaration";
    private static final String NONLOCAL_AFTER_ASSIGN = "name '%s' is assigned to before nonlocal declaration";
    private static final String GLOBAL_AFTER_USE = "name '%s' is used prior to global declaration";
    private static final String NONLOCAL_AFTER_USE = "name '%s' is used prior to nonlocal declaration";
    private static final String GLOBAL_ANNOT = "annotated name '%s' can't be global";
    private static final String NONLOCAL_ANNOT = "annotated name '%s' can't be nonlocal";
    private static final String IMPORT_STAR_WARNING = "import * only allowed at module level";
    private static final String NAMED_EXPR_COMP_IN_CLASS = "assignment expression within a comprehension cannot be used in a class body";
    private static final String NAMED_EXPR_COMP_IN_TYPEPARAM = "assignment expression within a comprehension cannot be used within the definition of a generic";
    private static final String NAMED_EXPR_COMP_IN_TYPEALIAS = "assignment expression within a comprehension cannot be used in a type alias";
    private static final String NAMED_EXPR_COMP_IN_TYPEVAR_BOUND = "assignment expression within a comprehension cannot be used in a TypeVar bound";
    private static final String NAMED_EXPR_COMP_CONFLICT = "assignment expression cannot rebind comprehension iteration variable '%s'";
    private static final String NAMED_EXPR_COMP_INNER_LOOP_CONFLICT = "comprehension inner loop cannot rebind assignment expression target '%s'";
    private static final String NAMED_EXPR_COMP_ITER_EXPR = "assignment expression cannot be used in a comprehension iterable expression";
    private static final String DUPLICATE_ARGUMENT = "duplicate argument '%s' in function definition";
    private static final String DUPLICATE_TYPE_PARAM = "duplicate type parameter '%s'";
    final Scope topScope;
    final HashMap<Object, Scope> blocks = new HashMap();
    final ParserCallbacks parserCallbacks;
    final EnumSet<FutureFeature> futureFeatures;
    final HashMap<Scope, Scope> parents = new HashMap();

    public static ScopeEnvironment analyze(ModTy moduleNode, ParserCallbacks parserCallbacks, EnumSet<FutureFeature> futureFeatures) {
        return new ScopeEnvironment(moduleNode, parserCallbacks, futureFeatures);
    }

    private ScopeEnvironment(ModTy moduleNode, ParserCallbacks parserCallbacks, EnumSet<FutureFeature> futureFeatures) {
        this.parserCallbacks = parserCallbacks;
        this.futureFeatures = futureFeatures;
        FirstPassVisitor visitor = new FirstPassVisitor(moduleNode, this);
        this.topScope = visitor.currentScope;
        moduleNode.accept(visitor);
        this.analyzeBlock(this.topScope, null, null, null, null, null);
    }

    public String toString() {
        return "ScopeEnvironment\n" + this.topScope.toString(1);
    }

    private void addScope(Object key, Scope scope) {
        assert (key instanceof SSTNode || key instanceof TypeParamTy[]);
        this.blocks.put(key, scope);
    }

    public Scope lookupScope(Object key) {
        assert (key instanceof SSTNode || key instanceof TypeParamTy[]);
        return this.blocks.get(key);
    }

    public Scope lookupParent(Scope scope) {
        return this.parents.get(scope);
    }

    public Scope getTopScope() {
        return this.topScope;
    }

    private void analyzeBlock(Scope scope, HashSet<String> bound, HashSet<String> free, HashSet<String> global, HashSet<String> typeParams, Scope classEntry) {
        HashSet<String> local = new HashSet<String>();
        HashMap<String, Scope.DefUse> scopes = new HashMap<String, Scope.DefUse>();
        HashSet<String> newGlobal = new HashSet<String>();
        HashSet<String> newFree = new HashSet<String>();
        HashSet<String> newBound = new HashSet<String>();
        if (scope.type == Scope.ScopeType.Class) {
            if (global != null) {
                newGlobal.addAll(global);
            }
            if (bound != null) {
                newBound.addAll(bound);
            }
        }
        for (Map.Entry<String, EnumSet<Scope.DefUse>> e : scope.symbols.entrySet()) {
            this.analyzeName(scope, scopes, e.getKey(), e.getValue(), bound, local, free, global, typeParams, classEntry);
        }
        if (scope.type != Scope.ScopeType.Class) {
            if (scope.type.isFunctionLike()) {
                newBound.addAll(local);
            }
            if (bound != null) {
                newBound.addAll(bound);
            }
            if (global != null) {
                newGlobal.addAll(global);
            }
        } else {
            newBound.add("__class__");
            newBound.add("__classdict__");
        }
        HashSet<String> allFree = new HashSet<String>();
        for (Scope s : scope.children) {
            Scope newClassEntry = null;
            if (s.canSeeClassScope()) {
                if (scope.type == Scope.ScopeType.Class) {
                    newClassEntry = scope;
                } else if (classEntry != null) {
                    newClassEntry = classEntry;
                }
            }
            HashSet<String> tempBound = new HashSet<String>(newBound);
            HashSet<String> tempFree = new HashSet<String>(newFree);
            HashSet<String> tempGlobal = new HashSet<String>(newGlobal);
            HashSet<String> tempTypeParams = new HashSet<String>();
            if (typeParams != null) {
                tempTypeParams.addAll(typeParams);
            }
            this.analyzeBlock(s, tempBound, tempFree, tempGlobal, tempTypeParams, newClassEntry);
            allFree.addAll(tempFree);
            if (!s.flags.contains((Object)Scope.ScopeFlags.HasFreeVars) && !s.flags.contains((Object)Scope.ScopeFlags.HasChildWithFreeVars)) continue;
            scope.flags.add(Scope.ScopeFlags.HasChildWithFreeVars);
        }
        newFree.addAll(allFree);
        if (scope.type.isFunctionLike()) {
            ScopeEnvironment.analyzeCells(scopes, newFree);
        } else if (scope.type == Scope.ScopeType.Class) {
            ScopeEnvironment.dropClassFree(scope, newFree);
        }
        ScopeEnvironment.updateSymbols(scope.symbols, scopes, bound, newFree, scope.type == Scope.ScopeType.Class || scope.canSeeClassScope());
        if (free != null) {
            free.addAll(newFree);
        }
    }

    private void analyzeName(Scope scope, HashMap<String, Scope.DefUse> scopes, String name, EnumSet<Scope.DefUse> flags, HashSet<String> bound, HashSet<String> local, HashSet<String> free, HashSet<String> global, HashSet<String> typeParams, Scope classEntry) {
        if (flags.contains((Object)Scope.DefUse.DefGlobal)) {
            if (flags.contains((Object)Scope.DefUse.DefNonLocal)) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, scope.getDirective(name), "name '%s' is nonlocal and global", name);
            }
            scopes.put(name, Scope.DefUse.GlobalExplicit);
            if (global != null) {
                global.add(name);
            }
            if (bound != null) {
                bound.remove(name);
            }
            return;
        }
        if (flags.contains((Object)Scope.DefUse.DefNonLocal)) {
            if (bound == null) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, scope.getDirective(name), "nonlocal declaration not allowed at module level");
            }
            if (!bound.contains(name)) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, scope.getDirective(name), "no binding for nonlocal '%s' found", name);
            }
            if (typeParams != null && typeParams.contains(name)) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, scope.getDirective(name), "nonlocal binding not allowed for type parameter '%s'", name);
            }
            scopes.put(name, Scope.DefUse.Free);
            scope.flags.add(Scope.ScopeFlags.HasFreeVars);
            if (free != null) {
                free.add(name);
            }
            return;
        }
        if (!Collections.disjoint(flags, Scope.DefUse.DefBound)) {
            scopes.put(name, Scope.DefUse.Local);
            local.add(name);
            if (global != null) {
                global.remove(name);
            }
            if (flags.contains((Object)Scope.DefUse.DefTypeParam)) {
                assert (typeParams != null);
                typeParams.add(name);
            } else if (typeParams != null) {
                typeParams.remove(name);
            }
            return;
        }
        if (classEntry != null) {
            EnumSet<Scope.DefUse> classFlags = classEntry.getUseOfName(name);
            if (classFlags.contains((Object)Scope.DefUse.DefGlobal)) {
                scopes.put(name, Scope.DefUse.GlobalExplicit);
                return;
            }
            if (!Collections.disjoint(classFlags, Scope.DefUse.DefBound) && !classFlags.contains((Object)Scope.DefUse.DefNonLocal)) {
                scopes.put(name, Scope.DefUse.GlobalImplicit);
                return;
            }
        }
        if (bound != null && bound.contains(name)) {
            scopes.put(name, Scope.DefUse.Free);
            scope.flags.add(Scope.ScopeFlags.HasFreeVars);
            free.add(name);
        } else if (global != null && global.contains(name)) {
            scopes.put(name, Scope.DefUse.GlobalImplicit);
        } else {
            if (scope.flags.contains((Object)Scope.ScopeFlags.IsNested)) {
                scope.flags.add(Scope.ScopeFlags.HasFreeVars);
            }
            scopes.put(name, Scope.DefUse.GlobalImplicit);
        }
    }

    private static void analyzeCells(HashMap<String, Scope.DefUse> scopes, HashSet<String> free) {
        for (Map.Entry<String, Scope.DefUse> e : scopes.entrySet()) {
            String name;
            if (e.getValue() != Scope.DefUse.Local || !free.contains(name = e.getKey())) continue;
            scopes.put(name, Scope.DefUse.Cell);
            free.remove(name);
        }
    }

    private static void dropClassFree(Scope scope, HashSet<String> free) {
        if (free.remove("__class__")) {
            scope.flags.add(Scope.ScopeFlags.NeedsClassClosure);
        }
        if (free.remove("__classdict__")) {
            scope.flags.add(Scope.ScopeFlags.NeedsClassDict);
        }
    }

    private static void updateSymbols(HashMap<String, EnumSet<Scope.DefUse>> symbols, HashMap<String, Scope.DefUse> scopes, HashSet<String> bound, HashSet<String> free, boolean isClass) {
        for (Map.Entry<String, EnumSet<Scope.DefUse>> e : symbols.entrySet()) {
            String name = e.getKey();
            Scope.DefUse vScope = scopes.get(name);
            assert (!vScope.toString().startsWith("Def"));
            e.getValue().add(vScope);
        }
        for (String name : free) {
            EnumSet<Scope.DefUse> v = symbols.get(name);
            if (v != null) {
                if (!isClass) continue;
                v.add(Scope.DefUse.DefFreeClass);
                continue;
            }
            if (bound != null && !bound.contains(name)) continue;
            symbols.put(name, EnumSet.of(Scope.DefUse.Free));
        }
    }

    public static String maybeMangle(String className, Scope scope, String name) {
        if (scope.mangledNames != null && !scope.mangledNames.contains(name)) {
            return name;
        }
        return ScopeEnvironment.mangle(className, name);
    }

    public static String mangle(String className, String name) {
        if (className == null || !name.startsWith("__")) {
            return name;
        }
        if (name.endsWith("__") || name.contains(".")) {
            return name;
        }
        int offset = 0;
        while (className.charAt(offset) == '_') {
            if (++offset < className.length()) continue;
            return name;
        }
        return "_" + className.substring(offset) + name;
    }

    private static final class FirstPassVisitor
    implements SSTreeVisitor<Void> {
        private final Deque<Scope> stack = new ArrayDeque<Scope>();
        private final HashMap<String, EnumSet<Scope.DefUse>> globals;
        private final ScopeEnvironment env;
        private Scope currentScope;
        private String currentClassName;

        private FirstPassVisitor(ModTy moduleNode, ScopeEnvironment env) {
            this.env = env;
            this.enterBlock(null, Scope.ScopeType.Module, moduleNode);
            this.globals = this.currentScope.symbols;
        }

        private void enterBlock(String name, Scope.ScopeType type, SSTNode ast) {
            this.enterBlock(name, type, ast.getSourceRange(), ast);
        }

        private void enterBlock(String name, Scope.ScopeType type, SourceRange sourceRange, Object key) {
            Scope scope = new Scope(name, type, sourceRange);
            this.env.addScope(key, scope);
            this.stack.push(scope);
            Scope prev = this.currentScope;
            if (prev != null) {
                scope.comprehensionIterExpression = prev.comprehensionIterExpression;
                if (prev.type.isFunctionLike() || prev.isNested()) {
                    scope.flags.add(Scope.ScopeFlags.IsNested);
                }
            }
            this.currentScope = scope;
            if (type == Scope.ScopeType.Annotation) {
                return;
            }
            this.env.parents.put(scope, prev);
            if (prev != null) {
                prev.children.add(scope);
            }
        }

        private void exitBlock() {
            this.stack.pop();
            this.currentScope = this.stack.peek();
        }

        private String maybeMangle(String name) {
            return ScopeEnvironment.maybeMangle(this.currentClassName, this.currentScope, name);
        }

        private void addDef(String name, Scope.DefUse flag, SSTNode node) {
            this.addDef(name, EnumSet.of(flag), node);
        }

        private void addDef(String name, EnumSet<Scope.DefUse> flags, SSTNode node) {
            if (flags.contains((Object)Scope.DefUse.DefTypeParam) && this.currentScope.mangledNames != null) {
                this.currentScope.mangledNames.add(name);
            }
            this.addDefHelper(name, flags, this.currentScope, node);
        }

        private void addDef(String name, Scope.DefUse flag, Scope scope, SSTNode node) {
            this.addDefHelper(name, EnumSet.of(flag), scope, node);
        }

        private void addDefHelper(String name, EnumSet<Scope.DefUse> newFlags, Scope scope, SSTNode node) {
            String mangled = this.maybeMangle(name);
            EnumSet<Scope.DefUse> flags = scope.getUseOfName(mangled);
            if (newFlags.contains((Object)Scope.DefUse.DefParam) && flags.contains((Object)Scope.DefUse.DefParam)) {
                throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.DUPLICATE_ARGUMENT, name);
            }
            if (newFlags.contains((Object)Scope.DefUse.DefTypeParam) && flags.contains((Object)Scope.DefUse.DefTypeParam)) {
                throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.DUPLICATE_TYPE_PARAM, name);
            }
            flags.addAll(newFlags);
            if (scope.flags.contains((Object)Scope.ScopeFlags.IsVisitingIterTarget)) {
                if (flags.contains((Object)Scope.DefUse.DefGlobal) || flags.contains((Object)Scope.DefUse.DefNonLocal)) {
                    throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.NAMED_EXPR_COMP_INNER_LOOP_CONFLICT, mangled);
                }
                flags.add(Scope.DefUse.DefCompIter);
            }
            scope.symbols.put(mangled, flags);
            if (newFlags.contains((Object)Scope.DefUse.DefParam)) {
                if (scope.varnames.contains(mangled)) {
                    throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.DUPLICATE_ARGUMENT, mangled);
                }
                scope.varnames.add(mangled);
            } else if (newFlags.contains((Object)Scope.DefUse.DefGlobal)) {
                EnumSet<Scope.DefUse> globalFlags = this.globals.get(mangled);
                if (globalFlags != null) {
                    globalFlags.addAll(newFlags);
                } else {
                    globalFlags = newFlags;
                }
                this.globals.put(mangled, globalFlags);
            }
        }

        private void enterTypeParamBlock(String name, boolean hasDefaults, boolean hasKwDefaults, SSTNode ast, TypeParamTy[] key) {
            Scope.ScopeType currentType = this.currentScope.type;
            this.enterBlock(name, Scope.ScopeType.TypeParam, ast.getSourceRange(), key);
            if (currentType == Scope.ScopeType.Class) {
                this.currentScope.flags.add(Scope.ScopeFlags.CanSeeClassScope);
                this.addDef("__classdict__", Scope.DefUse.Use, ast);
            }
            if (ast instanceof StmtTy.ClassDef) {
                this.addDef(".type_params", Scope.DefUse.DefLocal, ast);
                this.addDef(".type_params", Scope.DefUse.Use, ast);
                this.addDef(".generic_base", Scope.DefUse.DefLocal, ast);
                this.addDef(".generic_base", Scope.DefUse.Use, ast);
            }
            if (hasDefaults) {
                this.addDef(".defaults", Scope.DefUse.DefParam, ast);
            }
            if (hasKwDefaults) {
                this.addDef(".kwdefaults", Scope.DefUse.DefParam, ast);
            }
        }

        private static boolean hasKwOnlyDefaults(ArgTy[] kwOnlyArgs, ExprTy[] kwDefaults) {
            for (int i = 0; i < kwOnlyArgs.length; ++i) {
                if (kwDefaults[i] == null) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleComprehension(ExprTy e, String scopeName, ComprehensionTy[] generators, ExprTy element, ExprTy value, Scope.ComprehensionType comprehensionType) {
            boolean isAsync;
            if (this.currentScope.canSeeClassScope()) {
                throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, e.getSourceRange(), "Cannot use comprehension in annotation scope within class scope");
            }
            boolean isGenerator = e instanceof ExprTy.GeneratorExp;
            ComprehensionTy outermost = generators[0];
            ++this.currentScope.comprehensionIterExpression;
            outermost.iter.accept(this);
            --this.currentScope.comprehensionIterExpression;
            this.enterBlock(scopeName, Scope.ScopeType.Function, e);
            try {
                this.currentScope.comprehensionType = comprehensionType;
                if (outermost.isAsync) {
                    this.currentScope.flags.add(Scope.ScopeFlags.IsCoroutine);
                }
                this.currentScope.flags.add(Scope.ScopeFlags.IsComprehension);
                this.addDef(".0", Scope.DefUse.DefParam, (SSTNode)value);
                this.currentScope.flags.add(Scope.ScopeFlags.IsVisitingIterTarget);
                outermost.target.accept(this);
                this.currentScope.flags.remove((Object)Scope.ScopeFlags.IsVisitingIterTarget);
                this.visitSequence(outermost.ifs);
                for (int i = 1; i < generators.length; ++i) {
                    generators[i].accept(this);
                }
                if (value != null) {
                    value.accept(this);
                }
                element.accept(this);
                if (isGenerator) {
                    this.currentScope.flags.add(Scope.ScopeFlags.IsGenerator);
                }
                isAsync = this.currentScope.isCoroutine() && !isGenerator;
            }
            finally {
                this.exitBlock();
            }
            if (isAsync) {
                this.currentScope.flags.add(Scope.ScopeFlags.IsCoroutine);
            }
        }

        private RuntimeException raiseIfComprehensionBlock(ExprTy node) {
            throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), switch (this.currentScope.comprehensionType) {
                case Scope.ComprehensionType.ListComprehension -> "'yield' inside list comprehension";
                case Scope.ComprehensionType.SetComprehension -> "'yield' inside set comprehension";
                case Scope.ComprehensionType.DictComprehension -> "'yield' inside dict comprehension";
                default -> "'yield' inside generator expression";
            });
        }

        private void raiseIfAnnotationBlock(String name, ExprTy node) {
            switch (this.currentScope.type) {
                case Annotation: {
                    throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "%s can not be used within an annotation", name);
                }
                case TypeVarBound: {
                    throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "%s cannot be used within a TypeVar bound", name);
                }
                case TypeAlias: {
                    throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "%s cannot be used within a type alias", name);
                }
                case TypeParam: {
                    throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "%s cannot be used within the definition of a generic", name);
                }
            }
        }

        private void visitAnnotation(ExprTy expr) {
            boolean futureAnnotations = this.env.futureFeatures.contains((Object)FutureFeature.ANNOTATIONS);
            if (futureAnnotations) {
                this.enterBlock("_annotation", Scope.ScopeType.Annotation, expr);
            }
            try {
                expr.accept(this);
            }
            finally {
                if (futureAnnotations) {
                    this.exitBlock();
                }
            }
        }

        private void visitAnnotations(ArgTy[] args) {
            if (args != null) {
                for (ArgTy arg : args) {
                    if (arg.annotation == null) continue;
                    arg.annotation.accept(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void visitAnnotations(StmtTy node, ArgumentsTy args, ExprTy returns) {
            boolean futureAnnotations = this.env.futureFeatures.contains((Object)FutureFeature.ANNOTATIONS);
            if (args != null) {
                if (futureAnnotations) {
                    this.enterBlock("_annotation", Scope.ScopeType.Annotation, node);
                }
                try {
                    this.visitAnnotations(args.posOnlyArgs);
                    this.visitAnnotations(args.args);
                    if (args.varArg != null && args.varArg.annotation != null) {
                        args.varArg.annotation.accept(this);
                    }
                    if (args.kwArg != null && args.kwArg.annotation != null) {
                        args.kwArg.annotation.accept(this);
                    }
                    this.visitAnnotations(args.kwOnlyArgs);
                }
                finally {
                    if (futureAnnotations) {
                        this.exitBlock();
                    }
                }
            }
            if (returns != null) {
                this.visitAnnotation(returns);
            }
        }

        @Override
        public Void visit(AliasTy node) {
            String importedName = node.asName == null ? node.name : node.asName;
            int dotIndex = importedName.indexOf(46);
            if (dotIndex >= 0) {
                importedName = importedName.substring(0, dotIndex);
            }
            if ("*".equals(importedName)) {
                if (!this.currentScope.isModule()) {
                    throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.IMPORT_STAR_WARNING);
                }
            } else {
                this.addDef(importedName, Scope.DefUse.DefImport, (SSTNode)node);
            }
            return null;
        }

        @Override
        public Void visit(ArgTy node) {
            this.addDef(node.arg, Scope.DefUse.DefParam, (SSTNode)node);
            return null;
        }

        @Override
        public Void visit(ArgumentsTy node) {
            this.visitSequence(node.posOnlyArgs);
            this.visitSequence(node.args);
            this.visitSequence(node.kwOnlyArgs);
            if (node.varArg != null) {
                node.varArg.accept(this);
                this.currentScope.flags.add(Scope.ScopeFlags.HasVarArgs);
            }
            if (node.kwArg != null) {
                node.kwArg.accept(this);
                this.currentScope.flags.add(Scope.ScopeFlags.HasVarKeywords);
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.Attribute node) {
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.Await node) {
            this.raiseIfAnnotationBlock("await expression", node);
            node.value.accept(this);
            this.currentScope.flags.add(Scope.ScopeFlags.IsCoroutine);
            return null;
        }

        @Override
        public Void visit(ExprTy.BinOp node) {
            node.left.accept(this);
            node.right.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.BoolOp node) {
            this.visitSequence(node.values);
            return null;
        }

        @Override
        public Void visit(ExprTy.Call node) {
            node.func.accept(this);
            this.visitSequence(node.args);
            this.visitSequence(node.keywords);
            return null;
        }

        @Override
        public Void visit(ExprTy.Compare node) {
            node.left.accept(this);
            this.visitSequence(node.comparators);
            return null;
        }

        @Override
        public Void visit(ExprTy.Constant node) {
            return null;
        }

        @Override
        public Void visit(ExprTy.Dict node) {
            this.visitSequence(node.keys);
            this.visitSequence(node.values);
            return null;
        }

        @Override
        public Void visit(ExprTy.DictComp node) {
            this.handleComprehension(node, "dictcomp", node.generators, node.key, node.value, Scope.ComprehensionType.DictComprehension);
            return null;
        }

        @Override
        public Void visit(ExprTy.FormattedValue node) {
            node.value.accept(this);
            if (node.formatSpec != null) {
                node.formatSpec.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.GeneratorExp node) {
            this.handleComprehension(node, "genexp", node.generators, node.element, null, Scope.ComprehensionType.GeneratorExpression);
            return null;
        }

        @Override
        public Void visit(ExprTy.IfExp node) {
            node.test.accept(this);
            node.body.accept(this);
            node.orElse.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.JoinedStr node) {
            this.visitSequence(node.values);
            return null;
        }

        @Override
        public Void visit(ExprTy.Lambda node) {
            if (node.args != null) {
                this.visitSequence(node.args.defaults);
                this.visitSequence(node.args.kwDefaults);
            }
            this.enterBlock("lambda", Scope.ScopeType.Function, node);
            try {
                if (node.args != null) {
                    node.args.accept(this);
                }
                node.body.accept(this);
            }
            finally {
                this.exitBlock();
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.List node) {
            this.visitSequence(node.elements);
            return null;
        }

        @Override
        public Void visit(ExprTy.ListComp node) {
            this.handleComprehension(node, "listcomp", node.generators, node.element, null, Scope.ComprehensionType.ListComprehension);
            return null;
        }

        @Override
        public Void visit(ExprTy.Name node) {
            this.addDef(node.id, node.context == ExprContextTy.Load ? Scope.DefUse.Use : Scope.DefUse.DefLocal, (SSTNode)node);
            if (node.context == ExprContextTy.Load && this.currentScope.type.isFunctionLike() && node.id.equals("super")) {
                this.addDef("__class__", Scope.DefUse.Use, (SSTNode)node);
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.NamedExpr node) {
            this.raiseIfAnnotationBlock("named expression", node);
            if (this.currentScope.comprehensionIterExpression > 0) {
                throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.NAMED_EXPR_COMP_ITER_EXPR);
            }
            if (this.currentScope.flags.contains((Object)Scope.ScopeFlags.IsComprehension)) {
                String targetName = ((ExprTy.Name)node.target).id;
                for (Scope s : this.stack) {
                    if (s.flags.contains((Object)Scope.ScopeFlags.IsComprehension)) {
                        if (!s.getUseOfName(this.maybeMangle(targetName)).contains((Object)Scope.DefUse.DefCompIter)) continue;
                        throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.NAMED_EXPR_COMP_CONFLICT);
                    }
                    if (s.type == Scope.ScopeType.Function) {
                        EnumSet<Scope.DefUse> uses = s.getUseOfName(this.maybeMangle(targetName));
                        if (uses.contains((Object)Scope.DefUse.DefGlobal)) {
                            this.addDef(targetName, Scope.DefUse.DefGlobal, (SSTNode)node);
                        } else {
                            this.addDef(targetName, Scope.DefUse.DefNonLocal, (SSTNode)node);
                        }
                        this.currentScope.recordDirective(this.maybeMangle(targetName), node.getSourceRange());
                        this.addDef(targetName, Scope.DefUse.DefLocal, s, node);
                        break;
                    }
                    if (s.type == Scope.ScopeType.Module) {
                        this.addDef(targetName, Scope.DefUse.DefGlobal, (SSTNode)node);
                        this.currentScope.recordDirective(this.maybeMangle(targetName), node.getSourceRange());
                        this.addDef(targetName, Scope.DefUse.DefGlobal, s, node);
                        break;
                    }
                    if (s.type == Scope.ScopeType.Class) {
                        throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.NAMED_EXPR_COMP_IN_CLASS);
                    }
                    if (s.type == Scope.ScopeType.TypeParam) {
                        throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.NAMED_EXPR_COMP_IN_TYPEPARAM);
                    }
                    if (s.type == Scope.ScopeType.TypeAlias) {
                        throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.NAMED_EXPR_COMP_IN_TYPEALIAS);
                    }
                    if (s.type != Scope.ScopeType.TypeVarBound) continue;
                    throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), ScopeEnvironment.NAMED_EXPR_COMP_IN_TYPEVAR_BOUND);
                }
            }
            node.value.accept(this);
            node.target.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.Set node) {
            this.visitSequence(node.elements);
            return null;
        }

        @Override
        public Void visit(ExprTy.SetComp node) {
            this.handleComprehension(node, "setcomp", node.generators, node.element, null, Scope.ComprehensionType.SetComprehension);
            return null;
        }

        @Override
        public Void visit(ExprTy.Slice node) {
            if (node.lower != null) {
                node.lower.accept(this);
            }
            if (node.upper != null) {
                node.upper.accept(this);
            }
            if (node.step != null) {
                node.step.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.Starred node) {
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.Subscript node) {
            node.value.accept(this);
            node.slice.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.Tuple node) {
            this.visitSequence(node.elements);
            return null;
        }

        @Override
        public Void visit(ExprTy.UnaryOp node) {
            node.operand.accept(this);
            return null;
        }

        @Override
        public Void visit(ExprTy.Yield node) {
            this.raiseIfAnnotationBlock("yield expression", node);
            if (node.value != null) {
                node.value.accept(this);
            }
            this.currentScope.flags.add(Scope.ScopeFlags.IsGenerator);
            if (this.currentScope.flags.contains((Object)Scope.ScopeFlags.IsComprehension)) {
                throw this.raiseIfComprehensionBlock(node);
            }
            return null;
        }

        @Override
        public Void visit(ExprTy.YieldFrom node) {
            this.raiseIfAnnotationBlock("yield expression", node);
            if (node.value != null) {
                node.value.accept(this);
            }
            this.currentScope.flags.add(Scope.ScopeFlags.IsGenerator);
            if (this.currentScope.flags.contains((Object)Scope.ScopeFlags.IsComprehension)) {
                throw this.raiseIfComprehensionBlock(node);
            }
            return null;
        }

        @Override
        public Void visit(KeywordTy node) {
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(ModTy.Expression node) {
            node.body.accept(this);
            return null;
        }

        @Override
        public Void visit(ModTy.FunctionType node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Void visit(ModTy.Interactive node) {
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(ModTy.Module node) {
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(TypeIgnoreTy.TypeIgnore node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Void visit(StmtTy.AnnAssign node) {
            if (node.target instanceof ExprTy.Name) {
                ExprTy.Name name = (ExprTy.Name)node.target;
                EnumSet<Scope.DefUse> cur = this.currentScope.getUseOfName(this.maybeMangle(name.id));
                if (cur != null && (cur.contains((Object)Scope.DefUse.DefGlobal) || cur.contains((Object)Scope.DefUse.DefNonLocal)) && this.currentScope.symbols != this.globals && node.isSimple) {
                    String msg = cur.contains((Object)Scope.DefUse.DefGlobal) ? ScopeEnvironment.GLOBAL_ANNOT : ScopeEnvironment.NONLOCAL_ANNOT;
                    throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), msg, name.id);
                }
                if (node.isSimple) {
                    this.addDef(name.id, Scope.DefUse.DefAnnot, (SSTNode)node);
                    this.addDef(name.id, Scope.DefUse.DefLocal, (SSTNode)node);
                } else if (node.value != null) {
                    this.addDef(name.id, Scope.DefUse.DefLocal, (SSTNode)node);
                }
            } else {
                node.target.accept(this);
            }
            this.visitAnnotation(node.annotation);
            if (node.value != null) {
                node.value.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Assert node) {
            node.test.accept(this);
            if (node.msg != null) {
                node.msg.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Assign node) {
            this.visitSequence(node.targets);
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(StmtTy.AsyncFor node) {
            node.target.accept(this);
            node.iter.accept(this);
            this.visitSequence(node.body);
            if (node.orElse != null) {
                this.visitSequence(node.orElse);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.AsyncFunctionDef node) {
            this.visitFunctionDef(node.name, node.args, node.body, node.decoratorList, node.returns, node.typeParams, true, node);
            return null;
        }

        @Override
        public Void visit(StmtTy.AsyncWith node) {
            this.visitSequence(node.items);
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(StmtTy.AugAssign node) {
            node.target.accept(this);
            node.value.accept(this);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visit(StmtTy.ClassDef node) {
            boolean isGeneric;
            this.addDef(node.name, Scope.DefUse.DefLocal, (SSTNode)node);
            this.visitSequence(node.decoratorList);
            String tmp = this.currentClassName;
            boolean bl = isGeneric = node.typeParams != null && node.typeParams.length > 0;
            if (isGeneric) {
                this.enterTypeParamBlock(node.name, false, false, node, node.typeParams);
            }
            try {
                if (isGeneric) {
                    this.currentClassName = node.name;
                    this.currentScope.mangledNames = new HashSet();
                    this.visitSequence(node.typeParams);
                }
                this.visitSequence(node.bases);
                this.visitSequence(node.keywords);
                this.enterBlock(node.name, Scope.ScopeType.Class, node);
                try {
                    this.currentClassName = node.name;
                    if (isGeneric) {
                        this.addDef("__type_params__", Scope.DefUse.DefLocal, (SSTNode)node);
                        this.addDef(".type_params", Scope.DefUse.Use, (SSTNode)node);
                    }
                    this.visitSequence(node.body);
                }
                finally {
                    this.exitBlock();
                }
            }
            finally {
                if (isGeneric) {
                    this.exitBlock();
                }
                this.currentClassName = tmp;
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Delete node) {
            this.visitSequence(node.targets);
            return null;
        }

        @Override
        public Void visit(StmtTy.Expr node) {
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(StmtTy.For node) {
            node.target.accept(this);
            node.iter.accept(this);
            this.visitSequence(node.body);
            if (node.orElse != null) {
                this.visitSequence(node.orElse);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.FunctionDef node) {
            this.visitFunctionDef(node.name, node.args, node.body, node.decoratorList, node.returns, node.typeParams, false, node);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void visitFunctionDef(String name, ArgumentsTy args, StmtTy[] body, ExprTy[] decoratorList, ExprTy returns, TypeParamTy[] typeParams, boolean isAsync, StmtTy node) {
            this.addDef(name, Scope.DefUse.DefLocal, (SSTNode)node);
            this.visitSequence(args.defaults);
            this.visitSequence(args.kwDefaults);
            this.visitSequence(decoratorList);
            if (typeParams != null) {
                this.enterTypeParamBlock(name, args.defaults.length > 0, FirstPassVisitor.hasKwOnlyDefaults(args.kwOnlyArgs, args.kwDefaults), node, typeParams);
            }
            try {
                if (typeParams != null) {
                    this.visitSequence(typeParams);
                }
                this.visitAnnotations(node, args, returns);
                this.enterBlock(name, Scope.ScopeType.Function, node);
                try {
                    if (isAsync) {
                        this.currentScope.flags.add(Scope.ScopeFlags.IsCoroutine);
                    }
                    args.accept(this);
                    this.visitSequence(body);
                }
                finally {
                    this.exitBlock();
                }
            }
            finally {
                if (typeParams != null) {
                    this.exitBlock();
                }
            }
        }

        @Override
        public Void visit(StmtTy.Global node) {
            for (String n : node.names) {
                String mangled = this.maybeMangle(n);
                EnumSet<Scope.DefUse> cur = this.currentScope.getUseOfName(mangled);
                if (cur != null) {
                    String msg = null;
                    if (cur.contains((Object)Scope.DefUse.DefParam)) {
                        msg = ScopeEnvironment.GLOBAL_PARAM;
                    } else if (cur.contains((Object)Scope.DefUse.Use)) {
                        msg = ScopeEnvironment.GLOBAL_AFTER_USE;
                    } else if (cur.contains((Object)Scope.DefUse.DefAnnot)) {
                        msg = ScopeEnvironment.GLOBAL_ANNOT;
                    } else if (cur.contains((Object)Scope.DefUse.DefLocal)) {
                        msg = ScopeEnvironment.GLOBAL_AFTER_ASSIGN;
                    }
                    if (msg != null) {
                        throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), msg, n);
                    }
                }
                this.addDef(n, Scope.DefUse.DefGlobal, (SSTNode)node);
                this.currentScope.recordDirective(mangled, node.getSourceRange());
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.If node) {
            node.test.accept(this);
            this.visitSequence(node.body);
            this.visitSequence(node.orElse);
            return null;
        }

        @Override
        public Void visit(StmtTy.Import node) {
            this.visitSequence(node.names);
            return null;
        }

        @Override
        public Void visit(StmtTy.ImportFrom node) {
            this.visitSequence(node.names);
            return null;
        }

        @Override
        public Void visit(StmtTy.Match node) {
            node.subject.accept(this);
            this.visitSequence(node.cases);
            return null;
        }

        @Override
        public Void visit(MatchCaseTy node) {
            node.pattern.accept(this);
            if (node.guard != null) {
                node.guard.accept(this);
            }
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchAs node) {
            if (node.pattern != null) {
                node.pattern.accept(this);
            }
            if (node.name != null) {
                this.addDef(node.name, Scope.DefUse.DefLocal, (SSTNode)node);
            }
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchClass node) {
            node.cls.accept(this);
            this.visitSequence(node.patterns);
            this.visitSequence(node.kwdPatterns);
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchMapping node) {
            this.visitSequence(node.keys);
            this.visitSequence(node.patterns);
            if (node.rest != null) {
                this.addDef(node.rest, Scope.DefUse.DefLocal, (SSTNode)node);
            }
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchOr node) {
            this.visitSequence(node.patterns);
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchSequence node) {
            this.visitSequence(node.patterns);
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchSingleton node) {
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchStar node) {
            if (node.name != null) {
                this.addDef(node.name, Scope.DefUse.DefLocal, (SSTNode)node);
            }
            return null;
        }

        @Override
        public Void visit(PatternTy.MatchValue node) {
            node.value.accept(this);
            return null;
        }

        @Override
        public Void visit(StmtTy.Nonlocal node) {
            for (String n : node.names) {
                String mangled = this.maybeMangle(n);
                EnumSet<Scope.DefUse> cur = this.currentScope.getUseOfName(n);
                if (cur != null) {
                    String msg = null;
                    if (cur.contains((Object)Scope.DefUse.DefParam)) {
                        msg = ScopeEnvironment.NONLOCAL_PARAM;
                    } else if (cur.contains((Object)Scope.DefUse.Use)) {
                        msg = ScopeEnvironment.NONLOCAL_AFTER_USE;
                    } else if (cur.contains((Object)Scope.DefUse.DefAnnot)) {
                        msg = ScopeEnvironment.NONLOCAL_ANNOT;
                    } else if (cur.contains((Object)Scope.DefUse.DefLocal)) {
                        msg = ScopeEnvironment.NONLOCAL_AFTER_ASSIGN;
                    }
                    if (msg != null) {
                        throw this.env.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), msg, n);
                    }
                }
                this.addDef(n, Scope.DefUse.DefNonLocal, (SSTNode)node);
                this.currentScope.recordDirective(mangled, node.getSourceRange());
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Raise node) {
            if (node.exc != null) {
                node.exc.accept(this);
                if (node.cause != null) {
                    node.cause.accept(this);
                }
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Return node) {
            if (node.value != null) {
                node.value.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Try node) {
            this.visitSequence(node.body);
            this.visitSequence(node.orElse);
            this.visitSequence(node.handlers);
            this.visitSequence(node.finalBody);
            return null;
        }

        @Override
        public Void visit(StmtTy.TryStar node) {
            this.visitSequence(node.body);
            this.visitSequence(node.orElse);
            this.visitSequence(node.handlers);
            this.visitSequence(node.finalBody);
            return null;
        }

        @Override
        public Void visit(ExceptHandlerTy.ExceptHandler node) {
            if (node.type != null) {
                node.type.accept(this);
            }
            if (node.name != null) {
                this.addDef(node.name, Scope.DefUse.DefLocal, (SSTNode)node);
            }
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(StmtTy.While node) {
            node.test.accept(this);
            this.visitSequence(node.body);
            this.visitSequence(node.orElse);
            return null;
        }

        @Override
        public Void visit(StmtTy.With node) {
            this.visitSequence(node.items);
            this.visitSequence(node.body);
            return null;
        }

        @Override
        public Void visit(WithItemTy node) {
            node.contextExpr.accept(this);
            if (node.optionalVars != null) {
                node.optionalVars.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(ComprehensionTy node) {
            this.currentScope.flags.add(Scope.ScopeFlags.IsVisitingIterTarget);
            node.target.accept(this);
            this.currentScope.flags.remove((Object)Scope.ScopeFlags.IsVisitingIterTarget);
            ++this.currentScope.comprehensionIterExpression;
            node.iter.accept(this);
            --this.currentScope.comprehensionIterExpression;
            this.visitSequence(node.ifs);
            if (node.isAsync) {
                this.currentScope.flags.add(Scope.ScopeFlags.IsCoroutine);
            }
            return null;
        }

        @Override
        public Void visit(StmtTy.Break aThis) {
            return null;
        }

        @Override
        public Void visit(StmtTy.Continue aThis) {
            return null;
        }

        @Override
        public Void visit(StmtTy.Pass aThis) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visit(StmtTy.TypeAlias node) {
            boolean isGeneric;
            node.name.accept(this);
            String name = ((ExprTy.Name)node.name).id;
            boolean isInClass = this.currentScope.type == Scope.ScopeType.Class;
            boolean bl = isGeneric = node.typeParams != null && node.typeParams.length > 0;
            if (isGeneric) {
                this.enterTypeParamBlock(name, false, false, node, node.typeParams);
            }
            try {
                if (isGeneric) {
                    this.visitSequence(node.typeParams);
                }
                this.enterBlock(name, Scope.ScopeType.TypeAlias, node);
                try {
                    if (isInClass) {
                        this.currentScope.flags.add(Scope.ScopeFlags.CanSeeClassScope);
                        this.addDef("__classdict__", Scope.DefUse.Use, (SSTNode)node.value);
                    }
                    node.value.accept(this);
                }
                finally {
                    this.exitBlock();
                }
            }
            finally {
                if (isGeneric) {
                    this.exitBlock();
                }
            }
            return null;
        }

        @Override
        public Void visit(TypeParamTy.TypeVar node) {
            this.addDef(node.name, EnumSet.of(Scope.DefUse.DefTypeParam, Scope.DefUse.DefLocal), (SSTNode)node);
            if (node.bound != null) {
                boolean isInClass = this.currentScope.canSeeClassScope();
                this.enterBlock(node.name, Scope.ScopeType.TypeVarBound, node);
                try {
                    if (isInClass) {
                        this.currentScope.flags.add(Scope.ScopeFlags.CanSeeClassScope);
                        this.addDef("__classdict__", Scope.DefUse.Use, (SSTNode)node.bound);
                    }
                    node.bound.accept(this);
                }
                finally {
                    this.exitBlock();
                }
            }
            return null;
        }

        @Override
        public Void visit(TypeParamTy.ParamSpec node) {
            this.addDef(node.name, EnumSet.of(Scope.DefUse.DefTypeParam, Scope.DefUse.DefLocal), (SSTNode)node);
            return null;
        }

        @Override
        public Void visit(TypeParamTy.TypeVarTuple node) {
            this.addDef(node.name, EnumSet.of(Scope.DefUse.DefTypeParam, Scope.DefUse.DefLocal), (SSTNode)node);
            return null;
        }
    }
}

