/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.charset;

import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class PythonUnicodeEscapeCharsetEncoder
extends CharsetEncoder {
    private byte[] tmpBuf = new byte[10];
    private char highSurrogate;

    protected PythonUnicodeEscapeCharsetEncoder(Charset cs) {
        super(cs, 2.0f, 10.0f, new byte[]{63});
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target) {
        while (source.hasRemaining()) {
            int len;
            int ch;
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int initialPosition = source.position();
            int codePoint = ch = source.get();
            if (this.highSurrogate != '\u0000') {
                if (Character.isLowSurrogate((char)ch)) {
                    codePoint = Character.toCodePoint(this.highSurrogate, (char)ch);
                } else {
                    len = BytesUtils.unicodeEscape(this.highSurrogate, 0, this.tmpBuf);
                    if (target.remaining() < len) {
                        source.position(initialPosition);
                        return CoderResult.OVERFLOW;
                    }
                    target.put(this.tmpBuf, 0, len);
                    this.highSurrogate = '\u0000';
                }
            }
            if (Character.isHighSurrogate((char)ch)) {
                this.highSurrogate = ch;
                continue;
            }
            len = BytesUtils.unicodeEscape(codePoint, 0, this.tmpBuf);
            if (target.remaining() < len) {
                source.position(initialPosition);
                return CoderResult.OVERFLOW;
            }
            target.put(this.tmpBuf, 0, len);
            this.highSurrogate = '\u0000';
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected CoderResult implFlush(ByteBuffer target) {
        if (this.highSurrogate != '\u0000') {
            int len = BytesUtils.unicodeEscape(this.highSurrogate, 0, this.tmpBuf);
            if (target.remaining() < len) {
                return CoderResult.OVERFLOW;
            }
            target.put(this.tmpBuf, 0, len);
            this.highSurrogate = '\u0000';
        }
        return super.implFlush(target);
    }

    @Override
    protected void implReset() {
        super.implReset();
        this.highSurrogate = '\u0000';
    }
}

