/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.NodeFactoryUtils;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNextSlotsGen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class TpSlotIterNext {
    public static final TpSlot NEXT_NOT_IMPLEMENTED = TpSlotIterNextSlotsGen.SLOTS.tp_iternext();

    private TpSlotIterNext() {
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotTpIterNextNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "iternext");

        public abstract Object execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4);

        @Specialization(guards={"cachedSlot == slot"}, limit="3")
        static Object callCachedBuiltin(VirtualFrame frame, TpSlotIterNextBuiltin<?> slot, Object self, @Cached(value="slot") TpSlotIterNextBuiltin<?> cachedSlot, @Cached(value="cachedSlot.createSlotNode()") PythonUnaryBuiltinNode slotNode) {
            return slotNode.execute(frame, self);
        }

        @Specialization
        static Object callPython(VirtualFrame frame, TpSlot.TpSlotPythonSingle slot, Object self, @Cached(inline=false) TpSlotUnaryFunc.CallSlotUnaryPythonNode callSlotNode) {
            return callSlotNode.execute(frame, slot, self);
        }

        @Specialization
        static Object callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotCExtNative slot, Object self, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached CExtCommonNodes.ReadAndClearNativeException readAndClearNativeException) {
            PythonContext.PythonThreadState state = getThreadStateNode.execute(inliningTarget);
            Object nativeResult = externalInvokeNode.call(frame, inliningTarget, state, C_API_TIMING, SpecialMethodNames.T___NEXT__, slot.callable, toNativeNode.execute(self));
            Object pythonResult = toPythonNode.execute(nativeResult);
            if (pythonResult == PNone.NO_VALUE) {
                Object currentException = readAndClearNativeException.execute(inliningTarget, state);
                if (currentException != PNone.NO_VALUE) {
                    throw PException.fromObject(currentException, inliningTarget, false);
                }
                throw TpIterNextBuiltin.iteratorExhausted();
            }
            return pythonResult;
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static Object callGenericBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotIterNextBuiltin<?> slot, Object self, @Cached CallDispatchers.SimpleIndirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(1);
            PArguments.setArgument(arguments, 0, self);
            RootCallTarget callTarget = PythonLanguage.get(inliningTarget).getBuiltinSlotCallTarget(slot.callTargetIndex);
            return invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    static abstract class NextNotImplementedNode
    extends PythonUnaryBuiltinNode {
        NextNotImplementedNode() {
        }

        @Specialization
        static Object error(Object iterable, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, iterable);
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class TpIterNextBuiltin
    extends PythonUnaryBuiltinNode {
        public static IteratorExhausted iteratorExhausted() {
            throw IteratorExhausted.INSTANCE;
        }
    }

    public static final class TpIterNextBuiltinWrapperNode
    extends PythonUnaryBuiltinNode {
        @Node.Child
        PythonUnaryBuiltinNode delegate;

        public TpIterNextBuiltinWrapperNode(PythonUnaryBuiltinNode delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object execute(VirtualFrame frame, Object arg) {
            try {
                return this.delegate.execute(frame, arg);
            }
            catch (IteratorExhausted e) {
                throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.StopIteration);
            }
        }
    }

    public static abstract class TpSlotIterNextBuiltin<T extends PythonUnaryBuiltinNode>
    extends TpSlot.TpSlotBuiltin<T> {
        final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();

        protected TpSlotIterNextBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory);
        }

        final PythonUnaryBuiltinNode createSlotNode() {
            return (PythonUnaryBuiltinNode)((Object)this.createNode());
        }

        @Override
        public final void initialize(PythonLanguage language) {
            RootCallTarget callTarget = TpSlotIterNextBuiltin.createSlotCallTarget(language, BuiltinSlotWrapperSignature.UNARY, this.getNodeFactory(), "__next__");
            language.setBuiltinSlotCallTarget(this.callTargetIndex, callTarget);
        }

        @Override
        public PBuiltinFunction createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            NodeFactoryUtils.WrapperNodeFactory<TpIterNextBuiltinWrapperNode, PythonUnaryBuiltinNode> factory = new NodeFactoryUtils.WrapperNodeFactory<TpIterNextBuiltinWrapperNode, PythonUnaryBuiltinNode>(this.getNodeFactory(), TpIterNextBuiltinWrapperNode.class, TpIterNextBuiltinWrapperNode::new);
            return this.createBuiltin(core, type, tsName, BuiltinSlotWrapperSignature.UNARY, wrapper, factory);
        }
    }
}

