/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldObject;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.StructUnionTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.StructUnionTypeBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectSetAttrO;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCStructType, PythonBuiltinClassType.UnionType})
public final class StructUnionTypeBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = StructUnionTypeBuiltinsSlotsGen.SLOTS;
    private static final int MAX_STRUCT_SIZE = 16;
    protected static final TruffleString T__ABSTRACT_ = PythonUtils.tsLiteral("_abstract_");
    protected static final TruffleString T__FIELDS_ = PythonUtils.tsLiteral("_fields_");
    protected static final TruffleString T__SWAPPEDBYTES_ = PythonUtils.tsLiteral("_swappedbytes_");
    protected static final TruffleString T__USE_BROKEN_OLD_CTYPES_STRUCTURE_SEMANTICS_ = PythonUtils.tsLiteral("_use_broken_old_ctypes_structure_semantics_");
    protected static final TruffleString T__PACK_ = PythonUtils.tsLiteral("_pack_");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StructUnionTypeBuiltinsFactory.getFactories();
    }

    @ImportStatic(value={StructUnionTypeBuiltins.class})
    @GenerateInline(value=false)
    protected static abstract class PyCStructUnionTypeUpdateStgDict
    extends Node {
        protected PyCStructUnionTypeUpdateStgDict() {
        }

        abstract void execute(VirtualFrame var1, Object var2, Object var3, boolean var4);

        @Specialization
        static void PyCStructUnionType_update_stgdict(VirtualFrame frame, Object type, Object fields, boolean isStruct, @Bind Node inliningTarget, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached CFieldBuiltins.PyCFieldFromDesc cFieldFromDesc, @Cached SequenceNodes.CheckIsSequenceNode isSequenceNode, @Cached PyObjectGetItem getItemNode, @Cached PyObjectSizeNode sizeNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached StgDictBuiltins.MakeAnonFieldsNode makeAnonFieldsNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached PyObjectSetAttrO setAttr, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isBuiltinClassProfile, @Cached PyObjectLookupAttr lookupSwappedbytes, @Cached PyObjectLookupAttr lookupPack, @Cached PyObjectLookupAttr lookupBrokenCtypes, @Cached StringUtils.SimpleTruffleStringFormatNode formatNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PRaiseNode raiseNode) {
            StgDictObject dict;
            int ffi_ofs;
            int total_align;
            int union_size;
            int align;
            int size;
            int offset;
            int len;
            Object tmp = lookupSwappedbytes.execute((Frame)frame, inliningTarget, type, T__SWAPPEDBYTES_);
            boolean big_endian = tmp == PNone.NO_VALUE;
            tmp = lookupBrokenCtypes.execute((Frame)frame, inliningTarget, type, T__USE_BROKEN_OLD_CTYPES_STRUCTURE_SEMANTICS_);
            boolean use_broken_old_ctypes_semantics = tmp != PNone.NO_VALUE;
            tmp = lookupPack.execute((Frame)frame, inliningTarget, type, T__PACK_);
            boolean isPacked = tmp != PNone.NO_VALUE;
            int pack = 0;
            if (tmp != PNone.NO_VALUE) {
                try {
                    pack = asSizeNode.executeLossy((Frame)frame, inliningTarget, tmp);
                }
                catch (PException e) {
                    e.expectTypeOrOverflowError(inliningTarget, isBuiltinClassProfile);
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.PACK_MUST_BE_A_NON_NEGATIVE_INTEGER);
                }
            }
            try {
                isSequenceNode.execute(inliningTarget, fields);
                len = sizeNode.execute((Frame)frame, inliningTarget, fields);
            }
            catch (PException e) {
                e.expectTypeError(inliningTarget, isBuiltinClassProfile);
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.FIELDS_MUST_BE_A_SEQUENCE_OF_PAIRS);
            }
            StgDictObject stgdict = pyTypeStgDictNode.execute(inliningTarget, type);
            if ((stgdict.flags & 0x1000) != 0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.FIELDS_IS_FINAL);
            }
            stgdict.format = null;
            stgdict.ffi_type_pointer = new FFIType();
            stgdict.ffi_type_pointer.elements = null;
            StgDictObject basedict = pyTypeStgDictNode.execute(inliningTarget, getBaseClassNode.execute(inliningTarget, type));
            if (basedict != null) {
                stgdict.flags |= basedict.flags & 0xC00;
            }
            if (!isStruct) {
                stgdict.flags |= 0x400;
            }
            int field_size = 0;
            if (basedict != null && !use_broken_old_ctypes_semantics) {
                size = offset = basedict.size;
                align = basedict.align;
                union_size = 0;
                total_align = align != 0 ? align : 1;
                stgdict.ffi_type_pointer.type = FFIType.FFI_TYPES.FFI_TYPE_STRUCT;
                int ffielemLen = basedict.length + len;
                stgdict.ffi_type_pointer.elements = new FFIType[ffielemLen];
                if (basedict.ffi_type_pointer.elements != null && basedict.ffi_type_pointer.elements.length == ffielemLen) {
                    for (int idx = 0; idx < ffielemLen; ++idx) {
                        stgdict.ffi_type_pointer.elements[idx] = new FFIType(basedict.ffi_type_pointer.elements[idx], null);
                    }
                }
                ffi_ofs = basedict.length;
            } else {
                offset = 0;
                size = 0;
                align = 0;
                union_size = 0;
                total_align = 1;
                stgdict.ffi_type_pointer.type = FFIType.FFI_TYPES.FFI_TYPE_STRUCT;
                stgdict.ffi_type_pointer.elements = new FFIType[len];
                ffi_ofs = 0;
            }
            assert (stgdict.format == null);
            stgdict.format = isStruct && !isPacked ? PyCPointerTypeBuiltins.T_UPPER_T_LEFTBRACE : PyCPointerTypeBuiltins.T_UPPER_B;
            Object[] fieldsNames = new Object[len];
            int[] fieldsOffsets = new int[len];
            FFIType.FFI_TYPES[] fieldsTypes = new FFIType.FFI_TYPES[len];
            int bitofs = 0;
            boolean arrays_seen = false;
            for (int i = 0; i < len; ++i) {
                CFieldObject prop;
                int bitsize;
                Object pair = getItemNode.execute((Frame)frame, inliningTarget, fields, i);
                if (!PGuards.isPTuple(pair)) {
                    PyCStructUnionTypeUpdateStgDict.fieldsError(inliningTarget, raiseNode);
                }
                SequenceStorage storage = ((PTuple)pair).getSequenceStorage();
                Object[] tuple = getArray.execute(inliningTarget, storage);
                int tupleLen = storage.length();
                if (tupleLen < 2 || !PGuards.isString(tuple[0]) || tupleLen > 2 && !PGuards.isInteger(tuple[2])) {
                    PyCStructUnionTypeUpdateStgDict.fieldsError(inliningTarget, raiseNode);
                }
                Object name = tuple[0];
                Object desc = tuple[1];
                int n = bitsize = tupleLen >= 3 ? (Integer)tuple[2] : 0;
                if (pyTypeCheck.isPyCArrayTypeObject(inliningTarget, desc)) {
                    arrays_seen = true;
                }
                if ((dict = pyTypeStgDictNode.execute(inliningTarget, desc)) == null) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.SECOND_ITEM_IN_FIELDS_TUPLE_INDEX_D_MUST_BE_A_C_TYPE, i);
                }
                stgdict.ffi_type_pointer.elements[ffi_ofs + i] = dict.ffi_type_pointer;
                if ((dict.flags & 0x300) != 0) {
                    stgdict.flags |= 0x200;
                }
                stgdict.flags |= dict.flags & 0xC00;
                dict.flags |= 0x1000;
                if (tupleLen == 3) {
                    stgdict.flags |= 0x800;
                    switch (dict.ffi_type_pointer.type) {
                        case FFI_TYPE_UINT8: 
                        case FFI_TYPE_UINT16: 
                        case FFI_TYPE_UINT32: 
                        case FFI_TYPE_SINT64: 
                        case FFI_TYPE_UINT64: {
                            break;
                        }
                        case FFI_TYPE_SINT8: 
                        case FFI_TYPE_SINT16: 
                        case FFI_TYPE_SINT32: {
                            if (dict.getfunc != FFIType.FieldDesc.c.getfunc && dict.getfunc != FFIType.FieldDesc.u.getfunc) break;
                        }
                        default: {
                            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.BIT_FIELDS_NOT_ALLOWED_FOR_TYPE_N, desc);
                        }
                    }
                    if (bitsize <= 0 || bitsize > dict.size * 8) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NUMBER_OF_BITS_INVALID_FOR_BIT_FIELD);
                    }
                } else {
                    bitsize = 0;
                }
                if (isStruct && !isPacked) {
                    TruffleString fieldfmt = dict.format != null ? dict.format : PyCPointerTypeBuiltins.T_UPPER_B;
                    TruffleString buf = formatNode.format("%s:%s:", fieldfmt, castToTruffleStringNode.execute(inliningTarget, name));
                    stgdict.format = dict.shape != null ? CtypesModuleBuiltins._ctypes_alloc_format_string_with_shape(dict.ndim, dict.shape, stgdict.format, buf, appendStringNode, toStringNode, formatNode) : StringUtils.cat(stgdict.format, buf);
                }
                if (isStruct) {
                    props = new int[]{field_size, bitofs, size, offset, align};
                    prop = cFieldFromDesc.execute(inliningTarget, desc, i, bitsize, pack, big_endian, props);
                    field_size = props[0];
                    bitofs = props[1];
                    size = props[2];
                    offset = props[3];
                    align = props[4];
                    fieldsNames[i] = name;
                    fieldsOffsets[i] = prop.index;
                    fieldsTypes[i] = dict.ffi_type_pointer.type;
                } else {
                    size = 0;
                    offset = 0;
                    align = 0;
                    props = new int[]{field_size, bitofs, size, offset, align};
                    prop = cFieldFromDesc.execute(inliningTarget, desc, i, bitsize, pack, big_endian, props);
                    field_size = props[0];
                    bitofs = props[1];
                    size = props[2];
                    offset = props[3];
                    align = props[4];
                    union_size = Math.max(size, union_size);
                }
                total_align = Math.max(align, total_align);
                setAttr.execute((Frame)frame, inliningTarget, type, name, prop);
            }
            stgdict.fieldsNames = fieldsNames;
            stgdict.fieldsOffsets = fieldsOffsets;
            stgdict.fieldsTypes = fieldsTypes;
            if (isStruct && !isPacked) {
                stgdict.format = StringUtils.cat(stgdict.format, StringLiterals.T_RBRACE);
            }
            if (!isStruct) {
                size = union_size;
            }
            size = (size + total_align - 1) / total_align * total_align;
            stgdict.ffi_type_pointer.alignment = total_align;
            stgdict.ffi_type_pointer.size = size;
            stgdict.size = size;
            stgdict.align = total_align;
            stgdict.length = len;
            if (arrays_seen && size <= 16) {
                FFIType[] element_types = new FFIType[ffi_ofs + len];
                if (ffi_ofs != 0 && basedict != null) {
                    for (int idx = 0; idx < ffi_ofs; ++idx) {
                        element_types[idx] = new FFIType(basedict.ffi_type_pointer.elements[idx], null);
                    }
                }
                int element_index = ffi_ofs;
                for (int i = 0; i < len; ++i) {
                    Object desc;
                    Object pair = getItemNode.execute((Frame)frame, inliningTarget, fields, i);
                    if (!PGuards.isPTuple(pair)) {
                        PyCStructUnionTypeUpdateStgDict.fieldsError(inliningTarget, raiseNode);
                    }
                    SequenceStorage storage = ((PTuple)pair).getSequenceStorage();
                    Object[] tuple = getArray.execute(inliningTarget, storage);
                    int tupleLen = storage.length();
                    if (tupleLen < 2 || !PGuards.isString(tuple[0]) || tupleLen > 2 && !PGuards.isInteger(tuple[2])) {
                        PyCStructUnionTypeUpdateStgDict.fieldsError(inliningTarget, raiseNode);
                    }
                    if ((dict = pyTypeStgDictNode.execute(inliningTarget, desc = tuple[1])) == null) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.SECOND_ITEM_IN_FIELDS_TUPLE_INDEX_D_MUST_BE_A_C_TYPE, i);
                    }
                    assert (element_index < ffi_ofs + len);
                    if (!pyTypeCheck.isPyCArrayTypeObject(inliningTarget, desc)) {
                        element_types[element_index++] = dict.ffi_type_pointer;
                        continue;
                    }
                    int length = dict.length;
                    StgDictObject edict = pyTypeStgDictNode.execute(inliningTarget, dict.proto);
                    if (edict == null) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.SECOND_ITEM_IN_FIELDS_TUPLE_INDEX_D_MUST_BE_A_C_TYPE, i);
                    }
                    FFIType ffiType = new FFIType(length * edict.ffi_type_pointer.size, edict.ffi_type_pointer.alignment, FFIType.FFI_TYPES.FFI_TYPE_STRUCT, new FFIType[length]);
                    element_types[element_index++] = ffiType;
                    for (int j = 0; j < length; ++j) {
                        ffiType.elements[j] = edict.ffi_type_pointer;
                    }
                }
                assert (stgdict.ffi_type_pointer.elements != null);
                stgdict.ffi_type_pointer.elements = element_types;
            }
            if ((stgdict.flags & 0x1000) != 0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.STRUCTURE_OR_UNION_CANNOT_CONTAIN_ITSELF);
            }
            stgdict.flags |= 0x1000;
            makeAnonFieldsNode.execute(frame, type);
        }

        static void fieldsError(Node inliningTarget, PRaiseNode raiseNode) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.FIELDS_MUST_BE_A_SEQUENCE_OF_NAME_C_TYPE_PAIRS);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @ImportStatic(value={StructUnionTypeBuiltins.class})
    @GenerateNodeFactory
    public static abstract class StructUnionTypeNewNode
    extends PythonBuiltinNode {
        protected boolean isStruct() {
            return true;
        }

        @Specialization
        protected Object StructUnionTypeNew(VirtualFrame frame, Object type, Object[] args, PKeyword[] kwds, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode, @Cached HashingStorageNodes.HashingStorageGetItem getItemResDict, @Cached HashingStorageNodes.HashingStorageGetItem getItemStgDict, @Cached TypeBuiltins.TypeNode typeNew, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached GetDictIfExistsNode getDict, @Cached SetDictNode setDict, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached PyObjectSetAttr setFieldsAttributeNode) {
            Object result = typeNew.execute(frame, type, args[0], args[1], args[2], kwds);
            PDict resDict = getDict.execute(result);
            if (resDict == null) {
                resDict = PFactory.createDictFixedStorage(language, (PythonObject)result);
            }
            if (getItemResDict.hasKey(inliningTarget, resDict.getDictStorage(), T__ABSTRACT_)) {
                return result;
            }
            StgDictObject dict = PFactory.createStgDictObject(language);
            if (!this.isStruct()) {
                dict.flags |= 0x400;
            }
            dict.setDictStorage(addAllToOtherNode.execute((Frame)frame, inliningTarget, resDict.getDictStorage(), dict.getDictStorage()));
            setDict.execute(inliningTarget, result, dict);
            dict.format = PyCPointerTypeBuiltins.T_UPPER_B;
            dict.paramfunc = 16;
            Object fieldsValue = getItemStgDict.execute(inliningTarget, dict.getDictStorage(), T__FIELDS_);
            if (fieldsValue != null) {
                setFieldsAttributeNode.execute((Frame)frame, inliningTarget, result, T__FIELDS_, fieldsValue);
            } else {
                StgDictObject basedict = pyTypeStgDictNode.execute(inliningTarget, getBaseClassNode.execute(inliningTarget, result));
                if (basedict == null) {
                    return result;
                }
                StgDictObject.clone(dict, basedict);
                dict.flags &= 0xFFFFEFFF;
                basedict.flags |= 0x1000;
            }
            return result;
        }
    }
}

