/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.util.Objects;
import java.util.regex.Pattern;
import us.fatehi.utility.Utility;

public final class Color {
    public static final Color white = new Color(255, 255, 255);
    private static Pattern htmlColorPattern = Pattern.compile("^#[0-9A-Fa-f]{6}$");
    private final int b;
    private final int g;
    private final int r;

    public static Color fromHexTriplet(String htmlColor) {
        Utility.requireNotBlank(htmlColor, "No color provided");
        if (!htmlColorPattern.matcher(htmlColor).matches()) {
            throw new IllegalArgumentException("Bad color provided <%s>".formatted(htmlColor));
        }
        int r = Integer.parseInt(htmlColor.substring(1, 3), 16);
        int g = Integer.parseInt(htmlColor.substring(3, 5), 16);
        int b = Integer.parseInt(htmlColor.substring(5, 7), 16);
        return new Color(r, g, b);
    }

    public static Color fromHSV(float hue, float saturation, float value) {
        float normalizedHue = Math.abs(hue - (float)Math.floor(hue));
        int h = (int)(normalizedHue * 6.0f);
        float f = normalizedHue * 6.0f - (float)h;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        switch (h) {
            case 0: {
                return Color.fromRGB(value, t, p);
            }
            case 1: {
                return Color.fromRGB(q, value, p);
            }
            case 2: {
                return Color.fromRGB(p, value, t);
            }
            case 3: {
                return Color.fromRGB(p, q, value);
            }
            case 4: {
                return Color.fromRGB(t, p, value);
            }
            case 5: {
                return Color.fromRGB(value, p, q);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Color fromRGB(int r, int g, int b) {
        return new Color(r, g, b);
    }

    private static Color fromRGB(float r, float g, float b) {
        return new Color((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5));
    }

    private Color(int r, int g, int b) {
        this.r = r < 0 ? 0 : Math.min(r, 255);
        this.g = g < 0 ? 0 : Math.min(g, 255);
        this.b = b < 0 ? 0 : Math.min(b, 255);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Color other = (Color)obj;
        if (this.b != other.b || this.g != other.g) {
            return false;
        }
        return this.r == other.r;
    }

    public int hashCode() {
        return Objects.hash(this.b, this.g, this.r);
    }

    public String toString() {
        int rgb = (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
        String htmlColor = "#" + "%06x".formatted(rgb).toUpperCase();
        return htmlColor;
    }
}

