/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core;

import java.util.Objects;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.util.BufferRecycler;
import tools.jackson.core.util.RecyclerPool;

public abstract class TSFBuilder<F extends TokenStreamFactory, B extends TSFBuilder<F, B>> {
    protected int _factoryFeatures;
    protected int _streamReadFeatures;
    protected int _streamWriteFeatures;
    protected int _formatReadFeatures;
    protected int _formatWriteFeatures;
    protected RecyclerPool<BufferRecycler> _recyclerPool;
    protected StreamReadConstraints _streamReadConstraints;
    protected StreamWriteConstraints _streamWriteConstraints;
    protected ErrorReportConfiguration _errorReportConfiguration;

    protected TSFBuilder(StreamReadConstraints src, StreamWriteConstraints swc, ErrorReportConfiguration erc, int formatReadF, int formatWriteF) {
        this(null, src, swc, erc, TokenStreamFactory.DEFAULT_FACTORY_FEATURE_FLAGS, TokenStreamFactory.DEFAULT_STREAM_READ_FEATURE_FLAGS, TokenStreamFactory.DEFAULT_STREAM_WRITE_FEATURE_FLAGS, formatReadF, formatWriteF);
    }

    protected TSFBuilder(TokenStreamFactory base) {
        this(base._recyclerPool, base._streamReadConstraints, base._streamWriteConstraints, base._errorReportConfiguration, base._factoryFeatures, base._streamReadFeatures, base._streamWriteFeatures, base._formatReadFeatures, base._formatWriteFeatures);
    }

    protected TSFBuilder(RecyclerPool<BufferRecycler> brp, StreamReadConstraints src, StreamWriteConstraints swc, ErrorReportConfiguration erc, int factoryFeatures, int streamReadFeatures, int streamWriteFeatures, int formatReadFeatures, int formatWriteFeatures) {
        this._recyclerPool = brp;
        this._streamReadConstraints = Objects.requireNonNull(src);
        this._streamWriteConstraints = Objects.requireNonNull(swc);
        this._errorReportConfiguration = Objects.requireNonNull(erc);
        this._factoryFeatures = factoryFeatures;
        this._streamReadFeatures = streamReadFeatures;
        this._streamWriteFeatures = streamWriteFeatures;
        this._formatReadFeatures = formatReadFeatures;
        this._formatWriteFeatures = formatWriteFeatures;
    }

    public int factoryFeaturesMask() {
        return this._factoryFeatures;
    }

    public int streamReadFeaturesMask() {
        return this._streamReadFeatures;
    }

    public int streamWriteFeaturesMask() {
        return this._streamWriteFeatures;
    }

    public int formatReadFeaturesMask() {
        return this._formatReadFeatures;
    }

    public int formatWriteFeaturesMask() {
        return this._formatWriteFeatures;
    }

    public RecyclerPool<BufferRecycler> recyclerPool() {
        return this._recyclerPool;
    }

    public B enable(TokenStreamFactory.Feature f) {
        this._factoryFeatures |= f.getMask();
        return this._this();
    }

    public B disable(TokenStreamFactory.Feature f) {
        this._factoryFeatures &= ~f.getMask();
        return this._this();
    }

    public B configure(TokenStreamFactory.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public B enable(StreamReadFeature f) {
        this._streamReadFeatures |= f.getMask();
        return this._this();
    }

    public B enable(StreamReadFeature first, StreamReadFeature ... other) {
        this._streamReadFeatures |= first.getMask();
        for (StreamReadFeature f : other) {
            this._streamReadFeatures |= f.getMask();
        }
        return this._this();
    }

    public B disable(StreamReadFeature f) {
        this._streamReadFeatures &= ~f.getMask();
        return this._this();
    }

    public B disable(StreamReadFeature first, StreamReadFeature ... other) {
        this._streamReadFeatures &= ~first.getMask();
        for (StreamReadFeature f : other) {
            this._streamReadFeatures &= ~f.getMask();
        }
        return this._this();
    }

    public B configure(StreamReadFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public B enable(StreamWriteFeature f) {
        this._streamWriteFeatures |= f.getMask();
        return this._this();
    }

    public B enable(StreamWriteFeature first, StreamWriteFeature ... other) {
        this._streamWriteFeatures |= first.getMask();
        for (StreamWriteFeature f : other) {
            this._streamWriteFeatures |= f.getMask();
        }
        return this._this();
    }

    public B disable(StreamWriteFeature f) {
        this._streamWriteFeatures &= ~f.getMask();
        return this._this();
    }

    public B disable(StreamWriteFeature first, StreamWriteFeature ... other) {
        this._streamWriteFeatures &= ~first.getMask();
        for (StreamWriteFeature f : other) {
            this._streamWriteFeatures &= ~f.getMask();
        }
        return this._this();
    }

    public B configure(StreamWriteFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public B configureForJackson2() {
        return ((TSFBuilder)this.disable(StreamReadFeature.USE_FAST_DOUBLE_PARSER)).disable(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER);
    }

    public B streamReadConstraints(StreamReadConstraints streamReadConstraints) {
        this._streamReadConstraints = streamReadConstraints;
        return this._this();
    }

    public B streamWriteConstraints(StreamWriteConstraints streamWriteConstraints) {
        this._streamWriteConstraints = streamWriteConstraints;
        return this._this();
    }

    public B errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
        this._errorReportConfiguration = errorReportConfiguration;
        return this._this();
    }

    public B recyclerPool(RecyclerPool<BufferRecycler> p) {
        this._recyclerPool = Objects.requireNonNull(p);
        return this._this();
    }

    public abstract F build();

    protected final B _this() {
        return (B)this;
    }
}

