/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.options;

import java.util.Objects;
import schemacrawler.schemacrawler.IdentifierQuotingStrategy;
import schemacrawler.tools.executable.CommandOptions;
import schemacrawler.tools.text.options.BaseTextOptionsBuilder;
import schemacrawler.tools.text.options.DatabaseObjectColorMap;

public abstract class BaseTextOptions
implements CommandOptions {
    private final boolean isAlphabeticalSortForTables;
    private final boolean isAlphabeticalSortForTableColumns;
    private final boolean isAlphabeticalSortForRoutines;
    private final boolean isAlphabeticalSortForRoutineParameters;
    private final boolean isNoSchemaCrawlerInfo;
    private final boolean isShowDatabaseInfo;
    private final boolean isShowJdbcDriverInfo;
    private final boolean isShowUnqualifiedNames;
    private final boolean isNoSchemaColors;
    private final IdentifierQuotingStrategy identifierQuotingStrategy;
    private final DatabaseObjectColorMap colorMap;

    protected BaseTextOptions(BaseTextOptionsBuilder<?, ? extends BaseTextOptions> builder) {
        Objects.requireNonNull(builder, "No builder provided");
        this.isAlphabeticalSortForTables = builder.isAlphabeticalSortForTables;
        this.isAlphabeticalSortForTableColumns = builder.isAlphabeticalSortForTableColumns;
        this.isAlphabeticalSortForRoutines = builder.isAlphabeticalSortForRoutines;
        this.isAlphabeticalSortForRoutineParameters = builder.isAlphabeticalSortForRoutineParameters;
        this.isNoSchemaCrawlerInfo = builder.isNoSchemaCrawlerInfo;
        this.isShowDatabaseInfo = builder.isShowDatabaseInfo;
        this.isShowJdbcDriverInfo = builder.isShowJdbcDriverInfo;
        this.isShowUnqualifiedNames = builder.isShowUnqualifiedNames;
        this.isNoSchemaColors = builder.isNoSchemaColors;
        this.identifierQuotingStrategy = builder.identifierQuotingStrategy;
        this.colorMap = builder.colorMap;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public DatabaseObjectColorMap getColorMap() {
        return this.colorMap;
    }

    public IdentifierQuotingStrategy getIdentifierQuotingStrategy() {
        return this.identifierQuotingStrategy;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public boolean isAlphabeticalSortForRoutineParameters() {
        return this.isAlphabeticalSortForRoutineParameters;
    }

    public boolean isAlphabeticalSortForRoutines() {
        return this.isAlphabeticalSortForRoutines;
    }

    public boolean isAlphabeticalSortForTableColumns() {
        return this.isAlphabeticalSortForTableColumns;
    }

    public boolean isAlphabeticalSortForTables() {
        return this.isAlphabeticalSortForTables;
    }

    public boolean isNoInfo() {
        return this.isNoSchemaCrawlerInfo && !this.isShowDatabaseInfo && !this.isShowJdbcDriverInfo;
    }

    public boolean isNoSchemaColors() {
        return this.isNoSchemaColors;
    }

    public boolean isNoSchemaCrawlerInfo() {
        return this.isNoSchemaCrawlerInfo;
    }

    public boolean isShowDatabaseInfo() {
        return this.isShowDatabaseInfo;
    }

    public boolean isShowJdbcDriverInfo() {
        return this.isShowJdbcDriverInfo;
    }

    public boolean isShowUnqualifiedNames() {
        return this.isShowUnqualifiedNames;
    }
}

