/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSPatch;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class TDSReader {
    static final int KOPT_NONE_FINAL_TYPE = 1;
    static final int KOPT_JAVA_OBJECT = 2;
    long fixedDataSize;
    Vector patches;
    byte[] tds;
    int beginIndex;
    int index;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    TDSReader(byte[] tds, long beginIndex) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, TDSReader.class, $$$methodRef$$$18, null, tds, beginIndex);
            }
            this.fixedDataSize = 0L;
            this.patches = null;
            this.tds = tds;
            this.beginIndex = (int)beginIndex;
            this.index = (int)beginIndex;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, TDSReader.class, $$$methodRef$$$18, null);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TDSReader.class, $$$methodRef$$$18, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TDSReader.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void skipBytes(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void number;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TDSReader.class, $$$methodRef$$$0, this, n2);
            }
            this.index += number;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TDSReader.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TDSReader.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TDSReader.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void checkNextByte(byte by) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TDSReader.class, $$$methodRef$$$1, this, by);
            }
            try {
                void value;
                if (value != this.tds[this.index]) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, TDSReader.class, $$$methodRef$$$1, this, sQLException);
                    }
                    throw sQLException;
                }
                ++this.index;
            }
            catch (Throwable throwable) {
                ++this.index;
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, TDSReader.class, $$$methodRef$$$1, this, throwable2);
                }
                throw throwable2;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TDSReader.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TDSReader.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TDSReader.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    byte readByte() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            byte by;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TDSReader.class, $$$methodRef$$$2, this, new Object[0]);
                }
                try {
                    byte by2 = this.tds[this.index];
                    ++this.index;
                    by = by2;
                    if (!bl) break block7;
                }
                catch (Throwable throwable) {
                    ++this.index;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, TDSReader.class, $$$methodRef$$$2, this, throwable2);
                    }
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TDSReader.class, $$$methodRef$$$2, this, by);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TDSReader.class, $$$methodRef$$$2, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TDSReader.class, $$$methodRef$$$2, this, throwable3);
            }
            throw throwable;
        }
    }

    int readUnsignedByte() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TDSReader.class, $$$methodRef$$$3, this, new Object[0]);
                }
                try {
                    int n3 = this.tds[this.index] & 0xFF;
                    ++this.index;
                    n2 = n3;
                    if (!bl) break block7;
                }
                catch (Throwable throwable) {
                    ++this.index;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, TDSReader.class, $$$methodRef$$$3, this, throwable2);
                    }
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TDSReader.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TDSReader.class, $$$methodRef$$$3, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TDSReader.class, $$$methodRef$$$3, this, throwable3);
            }
            throw throwable;
        }
    }

    int readUB2() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TDSReader.class, $$$methodRef$$$4, this, new Object[0]);
                }
                try {
                    int n3 = ((this.tds[this.index] & 0xFF) << 8) + (this.tds[this.index + 1] & 0xFF);
                    this.index += 2;
                    n2 = n3;
                    if (!bl) break block7;
                }
                catch (Throwable throwable) {
                    this.index += 2;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, TDSReader.class, $$$methodRef$$$4, this, throwable2);
                    }
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TDSReader.class, $$$methodRef$$$4, this, n2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TDSReader.class, $$$methodRef$$$4, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TDSReader.class, $$$methodRef$$$4, this, throwable3);
            }
            throw throwable;
        }
    }

    long readLong() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TDSReader.class, $$$methodRef$$$5, this, new Object[0]);
                }
                try {
                    long l3 = (((this.tds[this.index] & 0xFF) * 256 + (this.tds[this.index + 1] & 0xFF)) * 256 + (this.tds[this.index + 2] & 0xFF)) * 256 + (this.tds[this.index + 3] & 0xFF);
                    this.index += 4;
                    l2 = l3;
                    if (!bl) break block7;
                }
                catch (Throwable throwable) {
                    this.index += 4;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, TDSReader.class, $$$methodRef$$$5, this, throwable2);
                    }
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TDSReader.class, $$$methodRef$$$5, this, l2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TDSReader.class, $$$methodRef$$$5, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TDSReader.class, $$$methodRef$$$5, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addNormalPatch(long l2, byte by, OracleType oracleType) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void uptStyle;
            void pos;
            void type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TDSReader.class, $$$methodRef$$$6, this, l2, by, oracleType);
            }
            this.addPatch(new TDSPatch(0, (OracleType)type, (long)pos, (int)uptStyle));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TDSReader.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TDSReader.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TDSReader.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addSimplePatch(long l2, OracleType oracleType) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void pos;
            void type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TDSReader.class, $$$methodRef$$$7, this, l2, oracleType);
            }
            this.addPatch(new TDSPatch(1, (OracleType)type, (long)pos, 0));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TDSReader.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TDSReader.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TDSReader.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addPatch(TDSPatch tDSPatch) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void patch;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TDSReader.class, $$$methodRef$$$8, this, tDSPatch);
            }
            if (this.patches == null) {
                this.patches = new Vector(5);
            }
            this.patches.addElement(patch);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TDSReader.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TDSReader.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TDSReader.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    long moveToPatchPos(TDSPatch tDSPatch) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void patch;
            long patchPos;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, TDSReader.class, $$$methodRef$$$9, this, tDSPatch);
            }
            if ((long)this.beginIndex + (patchPos = patch.getPosition()) > (long)this.tds.length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, TDSReader.class, $$$methodRef$$$9, this, sQLException);
                }
                throw sQLException;
            }
            this.skip_to(patchPos);
            long l2 = patchPos;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TDSReader.class, $$$methodRef$$$9, this, l2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TDSReader.class, $$$methodRef$$$9, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TDSReader.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    TDSPatch getNextPatch() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, TDSReader.class, $$$methodRef$$$10, this, new Object[0]);
            }
            TDSPatch patch = null;
            if (this.patches != null && this.patches.size() > 0) {
                patch = (TDSPatch)this.patches.firstElement();
                this.patches.removeElementAt(0);
            }
            TDSPatch tDSPatch = patch;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TDSReader.class, $$$methodRef$$$10, this, tDSPatch);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TDSReader.class, $$$methodRef$$$10, this, null);
            }
            return tDSPatch;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TDSReader.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void skip_to(long l2) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TDSReader.class, $$$methodRef$$$11, this, l2);
            }
            this.index = this.beginIndex + (int)offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TDSReader.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TDSReader.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TDSReader.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    long offset() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, TDSReader.class, $$$methodRef$$$12, this, new Object[0]);
            }
            long l2 = this.index - this.beginIndex;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TDSReader.class, $$$methodRef$$$12, this, l2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TDSReader.class, $$$methodRef$$$12, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TDSReader.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    long absoluteOffset() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TDSReader.class, $$$methodRef$$$13, this, new Object[0]);
            }
            long l2 = this.index;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TDSReader.class, $$$methodRef$$$13, this, l2);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TDSReader.class, $$$methodRef$$$13, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TDSReader.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    byte[] tds() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TDSReader.class, $$$methodRef$$$14, this, new Object[0]);
            }
            byte[] byArray = this.tds;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TDSReader.class, $$$methodRef$$$14, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TDSReader.class, $$$methodRef$$$14, this, null);
            }
            return this.tds;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TDSReader.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isJavaObject(int n2, byte by) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void flag;
            void version;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TDSReader.class, $$$methodRef$$$15, this, n2, by);
            }
            boolean bl3 = bl2 = version >= 3 && (flag & 2) != 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TDSReader.class, $$$methodRef$$$15, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TDSReader.class, $$$methodRef$$$15, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TDSReader.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isFinalType(int n2, byte by) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void flag;
            void version;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, TDSReader.class, $$$methodRef$$$16, this, n2, by);
            }
            boolean bl3 = bl2 = version >= 3 && (flag & 1) == 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TDSReader.class, $$$methodRef$$$16, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TDSReader.class, $$$methodRef$$$16, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TDSReader.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, TDSReader.class, $$$methodRef$$$17, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TDSReader.class, $$$methodRef$$$17, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TDSReader.class, $$$methodRef$$$17, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TDSReader.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$18 = TDSReader.class.getDeclaredConstructor(byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = TDSReader.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TDSReader.class.getDeclaredMethod("isFinalType", Integer.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TDSReader.class.getDeclaredMethod("isJavaObject", Integer.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TDSReader.class.getDeclaredMethod("tds", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TDSReader.class.getDeclaredMethod("absoluteOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TDSReader.class.getDeclaredMethod("offset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TDSReader.class.getDeclaredMethod("skip_to", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TDSReader.class.getDeclaredMethod("getNextPatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TDSReader.class.getDeclaredMethod("moveToPatchPos", TDSPatch.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TDSReader.class.getDeclaredMethod("addPatch", TDSPatch.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TDSReader.class.getDeclaredMethod("addSimplePatch", Long.TYPE, OracleType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TDSReader.class.getDeclaredMethod("addNormalPatch", Long.TYPE, Byte.TYPE, OracleType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TDSReader.class.getDeclaredMethod("readLong", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TDSReader.class.getDeclaredMethod("readUB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TDSReader.class.getDeclaredMethod("readUnsignedByte", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TDSReader.class.getDeclaredMethod("readByte", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TDSReader.class.getDeclaredMethod("checkNextByte", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TDSReader.class.getDeclaredMethod("skipBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

