/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class IfxDebugDataOutputStream
extends IfxDataOutputStream {
    private ByteArrayOutputStream trace = new ByteArrayOutputStream();

    public IfxDebugDataOutputStream(OutputStream s) {
        super(s);
    }

    public IfxDebugDataOutputStream(OutputStream s, boolean encoption) {
        super(s, encoption);
    }

    @Override
    public void writePadded(byte[] b, int offset, int length) throws IOException {
        super.writePadded(b, offset, length);
        this.trace.write(b, offset, length);
        this.checkPadding();
        if ((length & 1) >= 1) {
            this.trace.write(0);
        }
    }

    @Override
    public void write(int i) throws IOException {
        super.write(i);
        this.trace.write((byte)i);
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        super.write(b, offset, length);
        this.trace.write(b, offset, length);
        this.trace.flush();
        this.checkPadding();
    }

    @Override
    public void writeWithMangledTrace(byte[] b) throws IOException {
        super.write(b, 0, b.length);
    }

    public void writeWithMangledTrace(byte[] b, int offset, int length) throws IOException {
        this.write(b, offset, length);
        byte[] dummy = new byte[length];
        Arrays.fill(dummy, (byte)42);
        this.trace.write(dummy);
        this.checkPadding();
        this.written += length;
    }

    protected void checkPadding() {
    }

    protected void clearTrace() {
        try {
            this.trace.flush();
            this.trace.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void dumpTrace(OutputStream out) {
        try {
            this.trace.writeTo(out);
            this.trace.flush();
            this.trace.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getTraceLength() {
        return this.trace.size();
    }

    protected void resetTrace() {
        try {
            this.trace.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

