/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxUDTInput;
import com.informix.jdbc.IfxUDTOutput;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.TraceFlag;
import java.io.ByteArrayOutputStream;
import java.sql.SQLException;

abstract class IfxBaseType
extends IfxObject {
    protected static final int UDT_FLAG_SIZE = 1;
    protected static final int UDT_LENGTH_SIZE = 4;
    protected IfxUDTInput inputStream = null;
    protected IfxUDTOutput outputStream = new IfxUDTOutput();

    IfxBaseType() {
    }

    @Override
    public void setConnection(IfxConnection conn) {
        super.setConnection(conn);
        this.outputStream.setConnection(conn);
    }

    @Override
    public void fromIfx(byte[] b) throws SQLException {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int blength) throws SQLException {
        int index = offset;
        if (b[index] == 1) {
            this.nullify();
        } else {
            try {
                byte[] l_byte = new byte[4];
                System.arraycopy(b, ++index, l_byte, 0, 4);
                index += 4;
                int length = IfxToJavaType.IfxToJavaInt(l_byte);
                if (TraceFlag.isTraceEnabled()) {
                    this.writeTrace(2, "IfxBaseType: fromIfx.length = " + length);
                    this.writeTrace(2, "IfxBaseType: fromIfx.index = " + index);
                }
                this.inputStream = new IfxUDTInput(this.conn, b, index, length);
                this.unnullify();
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException((Throwable)e, -79716, new Object[0]);
            }
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        int index = 0;
        if (this.isNull()) {
            byte[] bNull = new byte[]{1};
            bStream.write(bNull, index++, bNull.length);
            this.outputStream.reset();
        }
        byte[] b = JavaToIfxType.JavaToIfxInt(this.outputStream.length());
        bStream.write(b, index, b.length);
        bStream.write(this.outputStream.toByteArray(), 0, this.outputStream.length());
        return bStream.toByteArray();
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        byte[] bNull = new byte[]{this.isNull() ? (byte)1 : 0};
        bStream.write(bNull, 0, 1);
        byte[] b = JavaToIfxType.JavaToIfxInt(this.outputStream.length());
        bStream.write(b, 0, b.length);
        bStream.write(this.outputStream.toByteArray(), 0, this.outputStream.length());
        return bStream.toByteArray();
    }
}

