/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalParserRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TemporalParser {
    private static final String patternDate = "^([+\\-]\\d\\d\\d\\d\\d\\d|\\d\\d\\d\\d)[\\-]?(\\d\\d)[\\-]?(\\d\\d)";
    private static final String patternTime = "^([01][0-9]|2[0-3])(:?([0-5][0-9])(?::?([0-5][0-9]|60)(?:[.,]([0-9]{1,9}))?)?)?";
    private static final String patternTimeZoneAnnotation = "(\\[!?((?:[-+](?:0[0-9]|1[0-9]|2[0-3])(?::?[0-5][0-9])?)|(?:[A-Za-z._][A-Za-z._0-9+-]*(?:/[A-Za-z._][A-Za-z._0-9+-]*)*))\\])";
    private static final String patternTimeZoneNumericUTCOffset = "^([-+])([01][0-9]|2[0-3])(:?([0-5][0-9])(?::?([0-5][0-9]|60)(?:[.,]([0-9]{1,9}))?)?)?";
    private static final String patternDateSpecYearMonth = "^([0-9]{4}|[+-][0-9]{6})-?(0[1-9]|1[0-2])";
    private static final String patternDateSpecMonthDay = "^(?:--)?(0[1-9]|1[012])-?(0[1-9]|[12][0-9]|3[01])";
    private static final String patternTimeZoneIANANameComponent = "^([A-Za-z_]+(/[A-Za-z\\-_]+)*)";
    private static final String patternAnnotationValue = "[A-Za-z0-9]+(?:-[A-Za-z0-9]+)*";
    private static final String patternAnnotation = "(\\[(!?)([a-z_][0-9a-z_-]*)=([A-Za-z0-9]+(?:-[A-Za-z0-9]+)*)\\])";
    private final JSContext context = JavaScriptLanguage.get(null).getJSContext();
    private static final TruffleString UC_T = Strings.constant("T");
    private static final TruffleString T = Strings.constant("t");
    private static final TruffleString ETC_GMT = Strings.constant("Etc/GMT");
    private static final TruffleString SIX_ZEROS = Strings.constant("000000");
    private final TruffleString input;
    private TruffleString rest;
    private int pos;
    private TruffleString year;
    private TruffleString month;
    private TruffleString day;
    private TruffleString hour;
    private TruffleString minute;
    private TruffleString second;
    private TruffleString fraction;
    private TruffleString calendar;
    private TruffleString timeZoneIANAName;
    private TruffleString timeZoneUTCOffsetName;
    private TruffleString timeZoneNumericUTCOffset;
    private TruffleString utcDesignator;
    private TruffleString offsetSign;
    private TruffleString offsetHour;
    private TruffleString offsetMinute;
    private TruffleString offsetSecond;
    private TruffleString offsetFraction;

    public TemporalParser(TruffleString input) {
        this.input = input;
    }

    private boolean tryParseTimeDesignator() {
        if (Strings.startsWith(this.rest, UC_T) || Strings.startsWith(this.rest, T)) {
            this.move(1);
            return true;
        }
        return false;
    }

    public JSTemporalParserRecord parseTemporalTimeString() {
        JSTemporalParserRecord rec = this.parseAnnotatedTime();
        if (rec != null) {
            return rec;
        }
        return this.parseAnnotatedDateTime(false, true);
    }

    private JSTemporalParserRecord parseAnnotatedTime() {
        this.reset();
        int start = this.pos;
        boolean hasTimeDesignator = this.tryParseTimeDesignator();
        if (this.tryParseTimeSpec()) {
            this.tryParseDateTimeUTCOffset(false);
            if (!hasTimeDesignator) {
                int length = this.pos - start;
                TruffleString timeDateTimeUTCOffset = Strings.lazySubstring(this.input, start, length);
                if (TemporalParser.createMatch(patternDateSpecYearMonth, timeDateTimeUTCOffset, false).matches()) {
                    return null;
                }
                Matcher matcher = TemporalParser.createMatch(patternDateSpecMonthDay, timeDateTimeUTCOffset, false);
                if (matcher.matches() && TemporalParser.isValidMonthDay(matcher.group(1), matcher.group(2))) {
                    return null;
                }
            }
            this.tryParseTimeZoneAnnotation();
            if (this.parseAnnotations() && this.atEnd()) {
                return this.result();
            }
        }
        return null;
    }

    public JSTemporalParserRecord parseAnnotatedDateTime(boolean zoned, boolean timeRequired) {
        this.reset();
        if (this.tryParseDateTime(zoned, timeRequired)) {
            if (!this.tryParseTimeZoneAnnotation() && zoned) {
                return null;
            }
            if (this.parseAnnotations() && this.atEnd()) {
                return this.result();
            }
        }
        return null;
    }

    private boolean tryParseDateTime(boolean zoned, boolean timeRequired) {
        if (!this.parseDate()) {
            return false;
        }
        if (!this.tryParseDateTimeSeparator()) {
            return !timeRequired;
        }
        if (!this.tryParseTimeSpec()) {
            return false;
        }
        this.tryParseDateTimeUTCOffset(zoned);
        return true;
    }

    private boolean parseTimeSpecSeparator() {
        int posBackup = this.pos;
        TruffleString restBackup = this.rest;
        if (!this.tryParseDateTimeSeparator()) {
            return false;
        }
        if (!this.tryParseTimeSpec()) {
            this.pos = posBackup;
            this.rest = restBackup;
            return false;
        }
        return true;
    }

    public JSTemporalParserRecord parseYearMonth() {
        JSTemporalParserRecord rec = this.parseAnnotatedYearMonth();
        if (rec != null) {
            return rec;
        }
        rec = this.parseAnnotatedDateTime(false, false);
        if (rec != null) {
            return rec;
        }
        return null;
    }

    private JSTemporalParserRecord parseAnnotatedYearMonth() {
        this.reset();
        if (this.tryParseDateSpecYearMonth()) {
            this.tryParseTimeZoneAnnotation();
            if (this.parseAnnotations() && this.atEnd()) {
                return this.result();
            }
        }
        return null;
    }

    public JSTemporalParserRecord parseTemporalMonthDayString() {
        this.reset();
        if (this.tryParseDateSpecMonthDay() || this.tryParseDateTime(false, false)) {
            this.tryParseTimeZoneAnnotation();
            if (this.parseAnnotations() && this.atEnd()) {
                return this.result();
            }
        }
        return null;
    }

    private boolean parseTimeZoneIANAName() {
        TruffleString ianaName = this.rest;
        if (Strings.startsWith(this.rest, ETC_GMT)) {
            this.move(Strings.length(ETC_GMT));
            if (!(this.rest.isEmpty() || Strings.charAt(this.rest, 0) != '+' && Strings.charAt(this.rest, 0) != '-')) {
                this.move(1);
                try {
                    int unpaddedHour = this.rest.parseIntUncached();
                    if (0 <= unpaddedHour && unpaddedHour <= 23) {
                        this.timeZoneIANAName = ianaName;
                        return true;
                    }
                }
                catch (TruffleString.NumberFormatException unpaddedHour) {
                    // empty catch block
                }
            }
        }
        this.reset();
        Matcher matcher = TemporalParser.createMatch(patternTimeZoneIANANameComponent, this.rest);
        if (matcher.matches()) {
            this.timeZoneIANAName = this.group(this.rest, matcher, 1);
            assert (this.timeZoneIANAName == null || TemporalParser.isTZLeadingChar(Strings.charAt(this.timeZoneIANAName, 0)));
            this.move(matcher.end(1));
            return true;
        }
        return false;
    }

    public JSTemporalParserRecord parseTimeZoneNumericUTCOffset() {
        this.reset();
        if (this.tryParseTimeZoneNumericUTCOffset() && this.atEnd()) {
            return this.result();
        }
        return null;
    }

    public JSTemporalParserRecord parseCalendarString() {
        this.reset();
        JSTemporalParserRecord rec = this.parseAnnotatedDateTime(true, false);
        if (rec != null) {
            return rec;
        }
        rec = this.parseAnnotatedDateTime(false, false);
        if (rec != null) {
            return rec;
        }
        rec = this.parseTemporalInstantString();
        if (rec != null) {
            return rec;
        }
        rec = this.parseTemporalTimeString();
        if (rec != null) {
            return rec;
        }
        rec = this.parseTemporalMonthDayString();
        if (rec != null) {
            return rec;
        }
        rec = this.parseYearMonth();
        if (rec != null) {
            return rec;
        }
        return null;
    }

    public boolean parseAnnotationValue() {
        this.reset();
        Matcher matcher = TemporalParser.createMatch(patternAnnotationValue, this.rest);
        return matcher.matches();
    }

    public JSTemporalParserRecord parseTemporalInstantString() {
        this.reset();
        if (this.parseDate() && this.parseTimeSpecSeparator() && this.tryParseDateTimeUTCOffset(true)) {
            this.tryParseTimeZoneAnnotation();
            if (this.parseAnnotations() && this.atEnd()) {
                return this.result();
            }
        }
        return null;
    }

    private JSTemporalParserRecord parseZonedDateTimeString() {
        this.reset();
        if (this.parseDate()) {
            this.tryParseDateTimeSeparator();
            this.tryParseTimeSpec();
            if (!this.tryParseTimeZoneNameRequired()) {
                return null;
            }
            if (this.parseAnnotations() && this.atEnd()) {
                return this.result();
            }
        }
        return null;
    }

    public boolean isTemporalZonedDateTimeString() {
        return this.parseZonedDateTimeString() != null;
    }

    private boolean tryParseTimeZoneNameRequired() {
        this.tryParseDateTimeUTCOffset(true);
        return this.tryParseTimeZoneAnnotation();
    }

    public JSTemporalParserRecord result() {
        try {
            return new JSTemporalParserRecord(this.utcDesignator != null, TemporalParser.prepare(this.year, Long.MAX_VALUE, true), TemporalParser.prepare(this.month, 12L), TemporalParser.prepare(this.day, 31L), TemporalParser.prepare(this.hour, 23L), TemporalParser.prepare(this.minute, 59L), TemporalParser.prepare(this.second, 60L), this.fraction, this.offsetSign, TemporalParser.prepare(this.offsetHour, 23L), TemporalParser.prepare(this.offsetMinute, 59L), TemporalParser.prepare(this.offsetSecond, 59L), this.offsetFraction, this.timeZoneIANAName, this.timeZoneUTCOffsetName, this.calendar, this.timeZoneNumericUTCOffset);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static long prepare(TruffleString value, long max) {
        return TemporalParser.prepare(value, max, false);
    }

    private static long prepare(TruffleString value, long max, boolean canBeNegative) {
        if (value == null) {
            return Long.MIN_VALUE;
        }
        long l = 0L;
        try {
            l = Strings.parseLong(value);
        }
        catch (TruffleString.NumberFormatException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        if (!canBeNegative && l < 0L || l > max) {
            throw new RuntimeException("date value out of bounds");
        }
        return l;
    }

    private boolean atEnd() {
        return this.pos >= Strings.length(this.input);
    }

    private void reset() {
        this.pos = 0;
        this.rest = this.input;
        this.year = null;
        this.month = null;
        this.day = null;
        this.hour = null;
        this.minute = null;
        this.second = null;
        this.fraction = null;
        this.calendar = null;
        this.timeZoneIANAName = null;
        this.timeZoneUTCOffsetName = null;
        this.timeZoneNumericUTCOffset = null;
        this.utcDesignator = null;
        this.offsetSign = null;
        this.offsetHour = null;
        this.offsetMinute = null;
        this.offsetSecond = null;
        this.offsetFraction = null;
    }

    private void move(int newPos) {
        this.pos += newPos;
        this.rest = this.pos >= 0 && Strings.length(this.input) > this.pos ? Strings.lazySubstring(this.input, this.pos) : Strings.EMPTY_STRING;
    }

    private boolean tryParseDateSpecYearMonth() {
        Matcher matcher = TemporalParser.createMatch(patternDateSpecYearMonth, this.rest);
        if (matcher.matches()) {
            this.year = this.group(this.rest, matcher, 1);
            this.month = this.group(this.rest, matcher, 2);
            this.move(matcher.end(2));
            return true;
        }
        return false;
    }

    private boolean tryParseDateSpecMonthDay() {
        Matcher matcher = TemporalParser.createMatch(patternDateSpecMonthDay, this.rest);
        if (matcher.matches()) {
            this.month = this.group(this.rest, matcher, 1);
            this.day = this.group(this.rest, matcher, 2);
            this.move(matcher.end(2));
            return true;
        }
        return false;
    }

    private static boolean isValidMonthDay(String dateMonth, String dateDay) {
        if ("31".equals(dateDay) && ("02".equals(dateMonth) || "04".equals(dateMonth) || "06".equals(dateMonth) || "09".equals(dateMonth) || "11".equals(dateMonth))) {
            return false;
        }
        return !"02".equals(dateMonth) || !"30".equals(dateDay);
    }

    private boolean parseDate() {
        Matcher matcher = TemporalParser.createMatch(patternDate, this.rest);
        if (matcher.matches()) {
            this.year = this.group(this.rest, matcher, 1);
            this.month = this.group(this.rest, matcher, 2);
            this.day = this.group(this.rest, matcher, 3);
            char yearCh0 = Strings.charAt(this.year, 0);
            if (yearCh0 == '-' && Strings.startsWith(this.year, SIX_ZEROS, 1)) {
                return false;
            }
            this.move(matcher.end(3));
            return true;
        }
        return false;
    }

    private boolean tryParseTimeSpec() {
        Matcher matcher = TemporalParser.createMatch(patternTime, this.rest);
        if (matcher.matches()) {
            this.hour = this.group(this.rest, matcher, 1);
            this.minute = this.group(this.rest, matcher, 3);
            this.second = this.group(this.rest, matcher, 4);
            this.fraction = this.group(this.rest, matcher, 5);
            this.move(matcher.end(2) < 0 ? matcher.end(1) : matcher.end(2));
            return true;
        }
        return false;
    }

    private boolean tryParseDateTimeSeparator() {
        if (Strings.length(this.rest) <= 0) {
            return false;
        }
        char ch = Strings.charAt(this.rest, 0);
        if (ch == 't' || ch == 'T' || ch == ' ') {
            this.move(1);
            return true;
        }
        return false;
    }

    private boolean parseAnnotations() {
        Matcher matcher;
        assert (this.calendar == null);
        String foundCalendar = null;
        boolean calendarWasCritical = false;
        while ((matcher = TemporalParser.createMatch(patternAnnotation, this.rest)).matches()) {
            boolean critical;
            String key = matcher.group(3);
            boolean bl = critical = !matcher.group(2).isEmpty();
            if ("u-ca".equals(key)) {
                if (this.calendar == null) {
                    foundCalendar = matcher.group(4).toLowerCase();
                    this.calendar = this.group(this.rest, matcher, 4);
                    calendarWasCritical = critical;
                } else {
                    if (!"iso8601".equals(foundCalendar)) {
                        return false;
                    }
                    if (critical || calendarWasCritical) {
                        return false;
                    }
                }
            } else if (critical) {
                return false;
            }
            this.move(matcher.end(1));
        }
        return true;
    }

    private boolean tryParseDateTimeUTCOffset(boolean zoned) {
        if (zoned && this.tryParseUTCDesignator()) {
            return true;
        }
        return this.tryParseTimeZoneNumericUTCOffset();
    }

    private boolean tryParseUTCDesignator() {
        if (Strings.startsWith(this.rest, Strings.UC_Z) || Strings.startsWith(this.rest, Strings.Z)) {
            this.move(1);
            this.utcDesignator = Strings.Z;
            return true;
        }
        return false;
    }

    private boolean tryParseTimeZoneNumericUTCOffset() {
        Matcher matcher = TemporalParser.createMatch(patternTimeZoneNumericUTCOffset, this.rest, true);
        if (matcher.matches()) {
            this.offsetSign = this.group(this.rest, matcher, 1);
            this.offsetHour = this.group(this.rest, matcher, 2);
            this.offsetMinute = this.group(this.rest, matcher, 4);
            this.offsetSecond = this.group(this.rest, matcher, 5);
            this.offsetFraction = this.group(this.rest, matcher, 6);
            int end = this.offsetMinute != null ? matcher.end(3) : matcher.end(2);
            this.timeZoneNumericUTCOffset = Strings.substring(this.context, this.rest, matcher.start(1), end);
            this.move(end);
            return true;
        }
        return false;
    }

    public JSTemporalParserRecord parseTimeZoneIdentifier() {
        this.reset();
        if (this.tryParseTimeZoneIdentifier() && this.atEnd()) {
            return this.result();
        }
        return null;
    }

    private boolean tryParseTimeZoneIdentifier() {
        this.reset();
        if (this.parseTimeZoneIANAName()) {
            return true;
        }
        this.reset();
        if (this.tryParseTimeZoneNumericUTCOffset()) {
            return this.offsetSecond == null && this.offsetFraction == null;
        }
        return false;
    }

    private boolean tryParseTimeZoneAnnotation() {
        Matcher matcher = TemporalParser.createMatch(patternTimeZoneAnnotation, this.rest);
        if (matcher.matches()) {
            TruffleString content = this.group(this.rest, matcher, 2);
            if (TemporalParser.isSign(Strings.charAt(content, 0))) {
                this.timeZoneUTCOffsetName = content;
            } else {
                assert (TemporalParser.isTZLeadingChar(Strings.charAt(content, 0)));
                this.timeZoneIANAName = content;
            }
            this.move(matcher.end(1));
            return true;
        }
        return false;
    }

    private static boolean isTZLeadingChar(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '.' || c == '_';
    }

    private static boolean isSign(char c) {
        return c == '+' || c == '-';
    }

    private static Matcher createMatch(String pattern, TruffleString input) {
        return TemporalParser.createMatch(pattern, input, true);
    }

    private static Matcher createMatch(String pattern, TruffleString input, boolean addMatchAll) {
        Pattern patternObj = Pattern.compile(pattern + (addMatchAll ? ".*" : ""));
        return patternObj.matcher(Strings.toJavaString(input));
    }

    private TruffleString group(TruffleString string, Matcher matcher, int groupNumber) {
        int start = matcher.start(groupNumber);
        return start < 0 ? null : Strings.substring(this.context, string, start, matcher.end(groupNumber) - start);
    }
}

