/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.JSNumberToBigIntNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;

@GeneratedBy(value=JSNumberToBigIntNode.class)
public final class JSNumberToBigIntNodeGen
extends JSNumberToBigIntNode {
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private JSNumberToBigIntNodeGen() {
    }

    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        if ((state_0 & 1) == 0 && arg0Value instanceof Integer) {
            return false;
        }
        if ((state_0 & 2) == 0 && arg0Value instanceof SafeInteger) {
            return false;
        }
        if (JSTypesGen.isImplicitDouble(arg0Value)) {
            double arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
            if (JSNumberToBigIntNode.doubleRepresentsSameValueAsLong(arg0Value_)) {
                return false;
            }
            arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
            if (!JSNumberToBigIntNode.doubleRepresentsSameValueAsLong(arg0Value_)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected BigInt execute(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1F) != 0) {
            if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                return JSNumberToBigIntNode.doInteger(arg0Value_);
            }
            if ((state_0 & 2) != 0 && arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger)arg0Value;
                return JSNumberToBigIntNode.doSafeInteger(arg0Value_);
            }
            if ((state_0 & 0xC) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0xE0) >>> 5, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0xE0) >>> 5, arg0Value);
                if ((state_0 & 4) != 0 && JSNumberToBigIntNode.doubleRepresentsSameValueAsLong(arg0Value_)) {
                    return JSNumberToBigIntNode.doDoubleAsLong(arg0Value_);
                }
                if ((state_0 & 8) != 0 && !JSNumberToBigIntNode.doubleRepresentsSameValueAsLong(arg0Value_)) {
                    return JSNumberToBigIntNode.doDoubleOther(arg0Value_);
                }
            }
            if ((state_0 & 0x10) != 0 && this.fallbackGuard_(state_0, arg0Value)) {
                return JSNumberToBigIntNode.doOtherType(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private BigInt executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            this.state_0_ = state_0 |= 1;
            return JSNumberToBigIntNode.doInteger(arg0Value_);
        }
        if (arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger)arg0Value;
            this.state_0_ = state_0 |= 2;
            return JSNumberToBigIntNode.doSafeInteger(arg0Value_);
        }
        int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
        if (doubleCast0 != 0) {
            double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
            if (JSNumberToBigIntNode.doubleRepresentsSameValueAsLong(arg0Value_)) {
                state_0 |= doubleCast0 << 5;
                this.state_0_ = state_0 |= 4;
                return JSNumberToBigIntNode.doDoubleAsLong(arg0Value_);
            }
            if (!JSNumberToBigIntNode.doubleRepresentsSameValueAsLong(arg0Value_)) {
                state_0 |= doubleCast0 << 5;
                this.state_0_ = state_0 |= 8;
                return JSNumberToBigIntNode.doDoubleOther(arg0Value_);
            }
        }
        this.state_0_ = state_0 |= 0x10;
        return JSNumberToBigIntNode.doOtherType(arg0Value);
    }

    @NeverDefault
    public static JSNumberToBigIntNode create() {
        return new JSNumberToBigIntNodeGen();
    }
}

