/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotFunctionProxyHandler;
import com.oracle.truffle.polyglot.PolyglotInteropErrors;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotObjectProxyHandlerFactory;
import com.oracle.truffle.polyglot.PolyglotToHostNode;
import com.oracle.truffle.polyglot.PolyglotWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Objects;
import org.graalvm.polyglot.Context;

final class PolyglotObjectProxyHandler
implements InvocationHandler,
PolyglotWrapper {
    static final Object[] EMPTY = new Object[0];
    final Object obj;
    final PolyglotLanguageContext languageContext;
    final CallTarget invoke;
    final Context contextAnchor;

    PolyglotObjectProxyHandler(Object obj, PolyglotLanguageContext languageContext, Class<?> interfaceClass, Type genericType) {
        this.obj = obj;
        this.languageContext = languageContext;
        this.invoke = ObjectProxyNode.lookup(languageContext, obj.getClass(), interfaceClass, genericType);
        this.contextAnchor = languageContext.context.getContextAPI();
    }

    @Override
    public Object getGuestObject() {
        return this.obj;
    }

    @Override
    public PolyglotLanguageContext getLanguageContext() {
        return this.languageContext;
    }

    @Override
    public PolyglotContextImpl getContext() {
        return this.languageContext.context;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        CompilerAsserts.neverPartOfCompilation();
        Object[] resolvedArguments = arguments == null ? EMPTY : arguments;
        try {
            return this.invoke.call(null, this.languageContext, this.obj, method, resolvedArguments);
        }
        catch (UnsupportedOperationException e) {
            try {
                return PolyglotFunctionProxyHandler.invokeDefault(this, proxy, method, resolvedArguments);
            }
            catch (Exception innerE) {
                e.addSuppressed(innerE);
                throw e;
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Object newProxyInstance(Class<?> clazz, Type genericType, Object obj, PolyglotLanguageContext languageContext) throws IllegalArgumentException {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new PolyglotObjectProxyHandler(obj, languageContext, clazz, genericType));
    }

    static abstract class ObjectProxyNode
    extends HostToGuestRootNode {
        final Class<?> receiverClass;
        final Class<?> interfaceType;
        final Type genericType;

        ObjectProxyNode(PolyglotLanguageInstance languageInstance, Class<?> receiverType, Class<?> interfaceType, Type genericType) {
            super(languageInstance);
            this.receiverClass = Objects.requireNonNull(receiverType);
            this.interfaceType = Objects.requireNonNull(interfaceType);
            this.genericType = genericType;
        }

        protected Class<? extends TruffleObject> getReceiverType() {
            return this.receiverClass;
        }

        @Override
        public String getName() {
            return "InterfaceProxy<" + String.valueOf(this.receiverClass) + ">";
        }

        @Specialization
        final Object doDefault(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @Bind Node node, @Cached ProxyInvokeNode proxyInvoke, @Cached PolyglotLanguageContext.ToGuestValuesNode toGuests) {
            Method method = (Method)args[2];
            Object[] arguments = toGuests.execute(node, languageContext, (Object[])args[3]);
            return proxyInvoke.execute(languageContext, receiver, method, this.genericType, arguments);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hashCode(this.receiverClass);
            result = 31 * result + Objects.hashCode(this.interfaceType);
            result = 31 * result + Objects.hashCode(this.genericType);
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectProxyNode)) {
                return false;
            }
            ObjectProxyNode other = (ObjectProxyNode)obj;
            return this.receiverClass == other.receiverClass && this.interfaceType == other.interfaceType && Objects.equals(this.genericType, other.genericType);
        }

        static CallTarget lookup(PolyglotLanguageContext languageContext, Class<?> receiverClass, Class<?> interfaceClass, Type genericType) {
            ObjectProxyNode node = PolyglotObjectProxyHandlerFactory.ObjectProxyNodeGen.create(languageContext.getLanguageInstance(), receiverClass, interfaceClass, genericType);
            CallTarget target = ObjectProxyNode.lookupHostCodeCache(languageContext, node, CallTarget.class);
            if (target == null) {
                target = ObjectProxyNode.installHostCodeCache(languageContext, node, node.getCallTarget(), CallTarget.class);
            }
            return target;
        }
    }

    static abstract class ProxyInvokeNode
    extends Node {
        protected static final int LIMIT = Integer.MAX_VALUE;
        @CompilerDirectives.CompilationFinal
        private boolean invokeFailed;

        ProxyInvokeNode() {
        }

        public abstract Object execute(PolyglotLanguageContext var1, Object var2, Method var3, Type var4, Object[] var5);

        @Specialization(guards={"cachedMethod == method"}, limit="LIMIT")
        protected Object doCachedMethod(PolyglotLanguageContext languageContext, Object receiver, Method method, Type genericType, Object[] arguments, @Bind Node node, @Cached(value="method") Method cachedMethod, @Cached(value="method.getName()") String name, @Cached(value="getMethodGenericReturnType(method, genericType)") Type returnType, @Cached(value="getMethodReturnType(method, returnType)") Class<?> returnClass, @CachedLibrary(value="receiver") InteropLibrary receivers, @CachedLibrary(limit="LIMIT") InteropLibrary members, @Cached InlinedConditionProfile branchProfile, @Cached PolyglotToHostNode toHost, @Cached InlinedBranchProfile error) {
            assert (Objects.equals(ProxyInvokeNode.getMethodGenericReturnType(method, genericType), returnType) && Objects.equals(ProxyInvokeNode.getMethodReturnType(method, returnType), returnClass));
            Object result = this.invokeOrExecute(node, languageContext, receiver, arguments, name, receivers, members, branchProfile, error);
            return toHost.execute(node, languageContext, result, returnClass, returnType);
        }

        @NeverDefault
        static Class<?> getMethodReturnType(Method method, Type genericReturnType) {
            if (method == null || method.getReturnType() == Void.TYPE) {
                return Object.class;
            }
            return EngineAccessor.HOST.getRawTypeFromGenericType(genericReturnType, method.getReturnType());
        }

        @NeverDefault
        static Type getMethodGenericReturnType(Method method, Type genericTargetType) {
            if (method == null || method.getReturnType() == Void.TYPE) {
                return Object.class;
            }
            return EngineAccessor.HOST.findActualTypeArgument(method.getGenericReturnType(), genericTargetType);
        }

        private Object invokeOrExecute(Node node, PolyglotLanguageContext polyglotContext, Object receiver, Object[] arguments, String member, InteropLibrary receivers, InteropLibrary members, InlinedConditionProfile invokeProfile, InlinedBranchProfile error) {
            try {
                boolean localInvokeFailed = this.invokeFailed;
                if (!localInvokeFailed) {
                    try {
                        return receivers.invokeMember(receiver, member, arguments);
                    }
                    catch (UnknownIdentifierException | UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        localInvokeFailed = true;
                        this.invokeFailed = true;
                    }
                }
                if (localInvokeFailed) {
                    if (invokeProfile.profile(node, receivers.isMemberInvocable(receiver, member))) {
                        return receivers.invokeMember(receiver, member, arguments);
                    }
                    if (receivers.isMemberReadable(receiver, member)) {
                        Object readMember = receivers.readMember(receiver, member);
                        if (members.isExecutable(readMember)) {
                            return members.execute(readMember, arguments);
                        }
                        if (arguments.length == 0) {
                            return readMember;
                        }
                    }
                }
                error.enter(node);
                throw PolyglotInteropErrors.invokeUnsupported(polyglotContext, receiver, member);
            }
            catch (UnknownIdentifierException e) {
                error.enter(node);
                throw PolyglotInteropErrors.invokeUnsupported(polyglotContext, receiver, member);
            }
            catch (UnsupportedTypeException e) {
                error.enter(node);
                throw PolyglotInteropErrors.invalidExecuteArgumentType(polyglotContext, receiver, e.getSuppliedValues());
            }
            catch (ArityException e) {
                error.enter(node);
                throw PolyglotInteropErrors.invalidExecuteArity(polyglotContext, receiver, arguments, e.getExpectedMinArity(), e.getExpectedMaxArity(), e.getActualArity());
            }
            catch (UnsupportedMessageException e) {
                error.enter(node);
                throw PolyglotInteropErrors.invokeUnsupported(polyglotContext, receiver, member);
            }
        }
    }
}

