/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.core.Field;
import com.amazon.redshift.core.Query;
import com.amazon.redshift.core.ResultCursor;
import com.amazon.redshift.core.ResultHandler;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.v3.RedshiftRowsBlockingQueue;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;

public class ResultHandlerDelegate
implements ResultHandler {
    private final ResultHandler delegate;

    public ResultHandlerDelegate(ResultHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor, RedshiftRowsBlockingQueue<Tuple> queueTuples, int[] rowCount, Thread ringBufferThread) {
        if (this.delegate != null) {
            this.delegate.handleResultRows(fromQuery, fields, tuples, cursor, queueTuples, rowCount, ringBufferThread);
        }
    }

    @Override
    public void handleCommandStatus(String status, long updateCount, long insertOID) {
        if (this.delegate != null) {
            this.delegate.handleCommandStatus(status, updateCount, insertOID);
        }
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        if (this.delegate != null) {
            this.delegate.handleWarning(warning);
        }
    }

    @Override
    public void handleError(SQLException error) {
        if (this.delegate != null) {
            this.delegate.handleError(error);
        }
    }

    @Override
    public void handleCompletion() throws SQLException {
        if (this.delegate != null) {
            this.delegate.handleCompletion();
        }
    }

    @Override
    public void secureProgress() {
        if (this.delegate != null) {
            this.delegate.secureProgress();
        }
    }

    @Override
    public SQLException getException() {
        if (this.delegate != null) {
            return this.delegate.getException();
        }
        return null;
    }

    @Override
    public SQLWarning getWarning() {
        if (this.delegate != null) {
            return this.delegate.getWarning();
        }
        return null;
    }

    @Override
    public void setStatementStateIdleFromInQuery() {
        if (this.delegate != null) {
            this.delegate.setStatementStateIdleFromInQuery();
        }
    }

    @Override
    public void setStatementStateInQueryFromIdle() {
        if (this.delegate != null) {
            this.delegate.setStatementStateInQueryFromIdle();
        }
    }

    @Override
    public boolean setStatementStateInQuerySuspendedFromInQuery() {
        if (this.delegate != null) {
            return this.delegate.setStatementStateInQuerySuspendedFromInQuery();
        }
        return false;
    }

    @Override
    public boolean wantsScrollableResultSet() {
        if (this.delegate != null) {
            return this.delegate.wantsScrollableResultSet();
        }
        return true;
    }
}

