/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift;

import com.amazon.redshift.plugin.utils.RequestUtils;
import java.time.Instant;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.identity.spi.AwsSessionCredentialsIdentity;

public class CredentialsHolder
implements AwsCredentials {
    protected AwsCredentials m_credentials;
    private Instant m_expiration;
    private IamMetadata m_metadata;
    private boolean refresh;

    protected CredentialsHolder(AwsCredentials credentials) {
        this(credentials, Instant.now().plusSeconds(900L));
    }

    protected CredentialsHolder(AwsCredentials credentials, Instant expiration) {
        this.m_credentials = credentials;
        if (credentials instanceof CredentialsHolder) {
            CredentialsHolder h = (CredentialsHolder)credentials;
            this.m_metadata = h.getMetadata();
            this.m_expiration = h.getExpiration();
        } else {
            this.m_expiration = expiration;
        }
    }

    public static CredentialsHolder newInstance(AwsCredentials credentials) {
        if (credentials instanceof AwsSessionCredentials) {
            return new SessionCredentialsHolder(credentials);
        }
        return new CredentialsHolder(credentials);
    }

    public static CredentialsHolder newInstance(AwsCredentials credentials, Instant expiration) {
        if (credentials instanceof AwsSessionCredentials) {
            return new SessionCredentialsHolder(credentials, expiration);
        }
        return new CredentialsHolder(credentials, expiration);
    }

    public String accessKeyId() {
        return this.m_credentials.accessKeyId();
    }

    public String secretAccessKey() {
        return this.m_credentials.secretAccessKey();
    }

    public boolean isExpired() {
        return RequestUtils.isCredentialExpired(this.m_expiration);
    }

    public Instant getExpiration() {
        return this.m_expiration;
    }

    public IamMetadata getMetadata() {
        if (this.m_metadata == null) {
            return null;
        }
        return this.m_metadata.clone();
    }

    public IamMetadata getThisMetadata() {
        if (this.m_metadata == null) {
            return null;
        }
        return this.m_metadata;
    }

    public void setRefresh(boolean flag) {
        this.refresh = flag;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setMetadata(IamMetadata metadata) {
        this.m_metadata = metadata;
    }

    public static final class IamMetadata
    implements Cloneable {
        private Boolean autoCreate;
        private String dbUser;
        private String samlDbUser;
        private String profileDbUser;
        private String dbGroups;
        private boolean allowDbUserOverride = false;
        private boolean forceLowercase = false;

        public Boolean getAutoCreate() {
            return this.autoCreate;
        }

        public String getDbUser() {
            return this.dbUser;
        }

        public void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        public String getSamlDbUser() {
            return this.samlDbUser;
        }

        public void setSamlDbUser(String dbUser) {
            this.samlDbUser = dbUser;
        }

        public String getProfileDbUser() {
            return this.profileDbUser;
        }

        public void setProfileDbUser(String dbUser) {
            this.profileDbUser = dbUser;
        }

        public String getDbGroups() {
            return this.dbGroups;
        }

        public void setDbGroups(String dbGroups) {
            this.dbGroups = dbGroups;
        }

        public boolean getForceLowercase() {
            return this.forceLowercase;
        }

        public void setForceLowercase(boolean forceLowercase) {
            this.forceLowercase = forceLowercase;
        }

        public boolean getAllowDbUserOverride() {
            return this.allowDbUserOverride;
        }

        public void setAllowDbUserOverride(boolean allowDbUserOverride) {
            this.allowDbUserOverride = allowDbUserOverride;
        }

        public IamMetadata clone() {
            try {
                return (IamMetadata)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static final class SessionCredentialsHolder
    extends CredentialsHolder
    implements AwsSessionCredentialsIdentity {
        private SessionCredentialsHolder(AwsCredentials credentials) {
            super(credentials);
        }

        private SessionCredentialsHolder(AwsCredentials credentials, Instant expiration) {
            super(credentials, expiration);
        }

        public String sessionToken() {
            return ((AwsSessionCredentials)this.m_credentials).sessionToken();
        }
    }
}

