/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.io.IOException;
import net.sourceforge.plantuml.webp.BoolDecoder;
import net.sourceforge.plantuml.webp.Globals;
import net.sourceforge.plantuml.webp.IDCT;
import net.sourceforge.plantuml.webp.MacroBlock;
import net.sourceforge.plantuml.webp.VP8Frame;

public class SubBlock {
    public static final int UV = 2;
    public static final int Y = 3;
    public static final int Y_AFTER_Y2 = 0;
    public static final int Y2 = 1;
    private SubBlock above;
    private int[][] dest;
    private int[][] diff;
    private boolean hasNoZeroToken;
    private SubBlock left;
    private MacroBlock macroBlock;
    private int mode;
    private PLANE plane;
    private int[][] predict;
    private int[] tokens;

    public static int planeToType(PLANE plane, Boolean withY2) {
        switch (plane.ordinal()) {
            case 3: {
                return 1;
            }
            case 2: {
                if (withY2.booleanValue()) {
                    return 0;
                }
                return 3;
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
        }
        return -1;
    }

    public SubBlock(MacroBlock macroBlock, SubBlock above, SubBlock left, PLANE plane) {
        this.macroBlock = macroBlock;
        this.plane = plane;
        this.above = above;
        this.left = left;
        this.mode = 0;
        this.tokens = new int[16];
        for (int z = 0; z < 16; ++z) {
            this.tokens[z] = 0;
        }
    }

    private int DCTextra(BoolDecoder bc2, int[] p) throws IOException {
        int v = 0;
        int offset = 0;
        do {
            v += v + bc2.readBool(p[offset]);
        } while (p[++offset] > 0);
        return v;
    }

    public void decodeSubBlock(BoolDecoder bc2, int[][][][] coef_probs, int ilc, int type, boolean withY2) throws IOException {
        SubBlock sb = this;
        int startAt = 0;
        if (withY2) {
            startAt = 1;
        }
        int lc = ilc;
        int c = 0;
        int v = 1;
        boolean skip = false;
        while (v != 11 && c + startAt < 16) {
            v = !skip ? bc2.readTree(Globals.vp8CoefTree, coef_probs[type][Globals.vp8CoefBands[c + startAt]][lc]) : bc2.readTreeSkip(Globals.vp8CoefTree, coef_probs[type][Globals.vp8CoefBands[c + startAt]][lc], 1);
            int dv = this.decodeToken(bc2, v);
            lc = 0;
            skip = false;
            if (dv == 1 || dv == -1) {
                lc = 1;
            } else if (dv > 1 || dv < -1) {
                lc = 2;
            } else if (dv == 0) {
                skip = true;
            }
            int[] tokens = sb.getTokens();
            if (v != 11) {
                tokens[Globals.vp8defaultZigZag1d[c + startAt]] = dv;
            }
            ++c;
        }
        this.hasNoZeroToken = false;
        for (int x = 0; x < 16; ++x) {
            if (this.tokens[x] == 0) continue;
            this.hasNoZeroToken = true;
        }
    }

    private int decodeToken(BoolDecoder bc2, int v) throws IOException {
        int r = v;
        if (v == 5) {
            r = 5 + this.DCTextra(bc2, Globals.Pcat1);
        }
        if (v == 6) {
            r = 7 + this.DCTextra(bc2, Globals.Pcat2);
        }
        if (v == 7) {
            r = 11 + this.DCTextra(bc2, Globals.Pcat3);
        }
        if (v == 8) {
            r = 19 + this.DCTextra(bc2, Globals.Pcat4);
        }
        if (v == 9) {
            r = 35 + this.DCTextra(bc2, Globals.Pcat5);
        }
        if (v == 10) {
            r = 67 + this.DCTextra(bc2, Globals.Pcat6);
        }
        if (v != 0 && v != 11 && bc2.readBit() > 0) {
            r = -r;
        }
        return r;
    }

    public void dequantSubBlock(VP8Frame frame, Integer Dc) {
        SubBlock sb = this;
        int[] adjustedValues = new int[16];
        for (int i = 0; i < 16; ++i) {
            int QValue;
            if (this.plane == PLANE.U || this.plane == PLANE.V) {
                QValue = frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getUvac_delta_q();
                if (i == 0) {
                    QValue = frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getUvdc_delta_q();
                }
            } else {
                QValue = frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getY1ac();
                if (i == 0) {
                    QValue = frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getY1dc();
                }
            }
            int inputValue = sb.getTokens()[i];
            adjustedValues[i] = inputValue * QValue;
        }
        if (Dc != null) {
            adjustedValues[0] = Dc;
        }
        int[][] diff = IDCT.idct4x4llm(adjustedValues);
        sb.setDiff(diff);
    }

    public void drawDebug() {
        if (this.dest != null) {
            this.dest[0][0] = 128;
            this.dest[1][0] = 128;
            this.dest[2][0] = 128;
            this.dest[3][0] = 128;
            this.dest[0][0] = 128;
            this.dest[0][1] = 128;
            this.dest[0][2] = 128;
            this.dest[0][3] = 128;
        }
    }

    public void drawDebugH() {
        if (this.dest != null) {
            this.dest[0][0] = 0;
            this.dest[1][0] = 0;
            this.dest[2][0] = 0;
            this.dest[3][0] = 0;
        }
    }

    public void drawDebugV() {
        if (this.dest != null) {
            this.dest[0][0] = 0;
            this.dest[0][1] = 0;
            this.dest[0][2] = 0;
            this.dest[0][3] = 0;
        }
    }

    public SubBlock getAbove() {
        return this.above;
    }

    public String getDebugString() {
        String r = new String();
        r = r + "  " + (Object)((Object)this.plane);
        if (this.getMacroBlock().getYMode() == 4 && this.plane == PLANE.Y1) {
            r = r + "\n  " + Globals.getSubBlockModeAsString(this.mode);
        }
        return r;
    }

    public int[][] getDest() {
        if (this.dest != null) {
            return this.dest;
        }
        return new int[4][4];
    }

    public int[][] getDiff() {
        return this.diff;
    }

    public SubBlock getLeft() {
        return this.left;
    }

    public MacroBlock getMacroBlock() {
        return this.macroBlock;
    }

    public int[][] getMacroBlockPredict(int intra_mode) {
        if (this.dest != null) {
            return this.dest;
        }
        int rv = 127;
        if (intra_mode == 2) {
            rv = 129;
        }
        int[][] r = new int[4][4];
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                r[i][j] = rv;
            }
        }
        return r;
    }

    public int getMode() {
        return this.mode;
    }

    public PLANE getPlane() {
        return this.plane;
    }

    public int[][] getPredict() {
        if (this.predict != null) {
            return this.predict;
        }
        return this.getPredict(0, false);
    }

    public int[][] getPredict(int intra_bmode, boolean left) {
        if (this.dest != null) {
            return this.dest;
        }
        if (this.predict != null) {
            return this.predict;
        }
        int rv = 127;
        if ((intra_bmode == 1 || intra_bmode == 0 || intra_bmode == 2 || intra_bmode == 3 || intra_bmode == 6 || intra_bmode == 5 || intra_bmode == 8) && left) {
            rv = 129;
        }
        int[][] r = new int[4][4];
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                r[i][j] = rv;
            }
        }
        return r;
    }

    int[] getTokens() {
        return this.tokens;
    }

    public boolean hasNoZeroToken() {
        return this.hasNoZeroToken;
    }

    public boolean isDest() {
        return this.dest != null;
    }

    public void predict(VP8Frame frame) {
        SubBlock sb = this;
        SubBlock aboveSb = frame.getAboveSubBlock(sb, sb.getPlane());
        SubBlock leftSb = frame.getLeftSubBlock(sb, sb.getPlane());
        int[] above = new int[4];
        int[] left = new int[4];
        above[0] = aboveSb.getPredict(sb.getMode(), false)[0][3];
        above[1] = aboveSb.getPredict(sb.getMode(), false)[1][3];
        above[2] = aboveSb.getPredict(sb.getMode(), false)[2][3];
        above[3] = aboveSb.getPredict(sb.getMode(), false)[3][3];
        left[0] = leftSb.getPredict(sb.getMode(), true)[3][0];
        left[1] = leftSb.getPredict(sb.getMode(), true)[3][1];
        left[2] = leftSb.getPredict(sb.getMode(), true)[3][2];
        left[3] = leftSb.getPredict(sb.getMode(), true)[3][3];
        SubBlock AL = frame.getLeftSubBlock(aboveSb, sb.getPlane());
        int al = !leftSb.isDest() && !aboveSb.isDest() ? AL.getPredict(sb.getMode(), false)[3][3] : (!aboveSb.isDest() ? AL.getPredict(sb.getMode(), false)[3][3] : AL.getPredict(sb.getMode(), true)[3][3]);
        SubBlock AR = frame.getAboveRightSubBlock(sb, sb.plane);
        int[] ar = new int[]{AR.getPredict(sb.getMode(), false)[0][3], AR.getPredict(sb.getMode(), false)[1][3], AR.getPredict(sb.getMode(), false)[2][3], AR.getPredict(sb.getMode(), false)[3][3]};
        int[][] p = new int[4][4];
        switch (sb.getMode()) {
            case 0: {
                int expected_dc = 0;
                for (int i = 0; i < 4; ++i) {
                    expected_dc += above[i];
                    expected_dc += left[i];
                }
                expected_dc = expected_dc + 4 >> 3;
                for (int y = 0; y < 4; ++y) {
                    for (int x = 0; x < 4; ++x) {
                        p[x][y] = expected_dc;
                    }
                }
                break;
            }
            case 1: {
                for (int r = 0; r < 4; ++r) {
                    for (int c = 0; c < 4; ++c) {
                        int pred = above[c] - al + left[r];
                        if (pred < 0) {
                            pred = 0;
                        }
                        if (pred > 255) {
                            pred = 255;
                        }
                        p[c][r] = pred;
                    }
                }
                break;
            }
            case 2: {
                int[] ap = new int[]{al + 2 * above[0] + above[1] + 2 >> 2, above[0] + 2 * above[1] + above[2] + 2 >> 2, above[1] + 2 * above[2] + above[3] + 2 >> 2, above[2] + 2 * above[3] + ar[0] + 2 >> 2};
                for (int r = 0; r < 4; ++r) {
                    for (int c = 0; c < 4; ++c) {
                        p[c][r] = ap[c];
                    }
                }
                break;
            }
            case 3: {
                int[] lp = new int[]{al + 2 * left[0] + left[1] + 2 >> 2, left[0] + 2 * left[1] + left[2] + 2 >> 2, left[1] + 2 * left[2] + left[3] + 2 >> 2, left[2] + 2 * left[3] + left[3] + 2 >> 2};
                for (int r = 0; r < 4; ++r) {
                    for (int c = 0; c < 4; ++c) {
                        p[c][r] = lp[r];
                    }
                }
                break;
            }
            case 4: {
                p[0][0] = above[0] + above[1] * 2 + above[2] + 2 >> 2;
                int n = above[1] + above[2] * 2 + above[3] + 2 >> 2;
                p[0][1] = n;
                p[1][0] = n;
                int n2 = above[2] + above[3] * 2 + ar[0] + 2 >> 2;
                p[0][2] = n2;
                p[1][1] = n2;
                p[2][0] = n2;
                int n3 = above[3] + ar[0] * 2 + ar[1] + 2 >> 2;
                p[0][3] = n3;
                p[1][2] = n3;
                p[2][1] = n3;
                p[3][0] = n3;
                int n4 = ar[0] + ar[1] * 2 + ar[2] + 2 >> 2;
                p[1][3] = n4;
                p[2][2] = n4;
                p[3][1] = n4;
                int n5 = ar[1] + ar[2] * 2 + ar[3] + 2 >> 2;
                p[2][3] = n5;
                p[3][2] = n5;
                p[3][3] = ar[2] + ar[3] * 2 + ar[3] + 2 >> 2;
                break;
            }
            case 5: {
                int[] pp = new int[]{left[3], left[2], left[1], left[0], al, above[0], above[1], above[2], above[3]};
                p[0][3] = pp[0] + pp[1] * 2 + pp[2] + 2 >> 2;
                int n = pp[1] + pp[2] * 2 + pp[3] + 2 >> 2;
                p[0][2] = n;
                p[1][3] = n;
                int n6 = pp[2] + pp[3] * 2 + pp[4] + 2 >> 2;
                p[0][1] = n6;
                p[1][2] = n6;
                p[2][3] = n6;
                int n7 = pp[3] + pp[4] * 2 + pp[5] + 2 >> 2;
                p[0][0] = n7;
                p[1][1] = n7;
                p[2][2] = n7;
                p[3][3] = n7;
                int n8 = pp[4] + pp[5] * 2 + pp[6] + 2 >> 2;
                p[1][0] = n8;
                p[2][1] = n8;
                p[3][2] = n8;
                int n9 = pp[5] + pp[6] * 2 + pp[7] + 2 >> 2;
                p[2][0] = n9;
                p[3][1] = n9;
                p[3][0] = pp[6] + pp[7] * 2 + pp[8] + 2 >> 2;
                break;
            }
            case 6: {
                int[] pp = new int[]{left[3], left[2], left[1], left[0], al, above[0], above[1], above[2], above[3]};
                p[0][3] = pp[1] + pp[2] * 2 + pp[3] + 2 >> 2;
                p[0][2] = pp[2] + pp[3] * 2 + pp[4] + 2 >> 2;
                int n = pp[3] + pp[4] * 2 + pp[5] + 2 >> 2;
                p[0][1] = n;
                p[1][3] = n;
                int n10 = pp[4] + pp[5] + 1 >> 1;
                p[0][0] = n10;
                p[1][2] = n10;
                int n11 = pp[4] + pp[5] * 2 + pp[6] + 2 >> 2;
                p[1][1] = n11;
                p[2][3] = n11;
                int n12 = pp[5] + pp[6] + 1 >> 1;
                p[1][0] = n12;
                p[2][2] = n12;
                int n13 = pp[5] + pp[6] * 2 + pp[7] + 2 >> 2;
                p[2][1] = n13;
                p[3][3] = n13;
                int n14 = pp[6] + pp[7] + 1 >> 1;
                p[2][0] = n14;
                p[3][2] = n14;
                p[3][1] = pp[6] + pp[7] * 2 + pp[8] + 2 >> 2;
                p[3][0] = pp[7] + pp[8] + 1 >> 1;
                break;
            }
            case 7: {
                p[0][0] = above[0] + above[1] + 1 >> 1;
                p[0][1] = above[0] + above[1] * 2 + above[2] + 2 >> 2;
                int n = above[1] + above[2] + 1 >> 1;
                p[1][0] = n;
                p[0][2] = n;
                int n15 = above[1] + above[2] * 2 + above[3] + 2 >> 2;
                p[0][3] = n15;
                p[1][1] = n15;
                int n16 = above[2] + above[3] + 1 >> 1;
                p[2][0] = n16;
                p[1][2] = n16;
                int n17 = above[2] + above[3] * 2 + ar[0] + 2 >> 2;
                p[2][1] = n17;
                p[1][3] = n17;
                int n18 = above[3] + ar[0] + 1 >> 1;
                p[2][2] = n18;
                p[3][0] = n18;
                int n19 = above[3] + ar[0] * 2 + ar[1] + 2 >> 2;
                p[2][3] = n19;
                p[3][1] = n19;
                p[3][2] = ar[0] + ar[1] * 2 + ar[2] + 2 >> 2;
                p[3][3] = ar[1] + ar[2] * 2 + ar[3] + 2 >> 2;
                break;
            }
            case 8: {
                int[] pp = new int[]{left[3], left[2], left[1], left[0], al, above[0], above[1], above[2], above[3]};
                p[0][3] = pp[0] + pp[1] + 1 >> 1;
                p[1][3] = pp[0] + pp[1] * 2 + pp[2] + 2 >> 2;
                int n = pp[1] + pp[2] + 1 >> 1;
                p[2][3] = n;
                p[0][2] = n;
                int n20 = pp[1] + pp[2] * 2 + pp[3] + 2 >> 2;
                p[3][3] = n20;
                p[1][2] = n20;
                int n21 = pp[2] + pp[3] + 1 >> 1;
                p[0][1] = n21;
                p[2][2] = n21;
                int n22 = pp[2] + pp[3] * 2 + pp[4] + 2 >> 2;
                p[1][1] = n22;
                p[3][2] = n22;
                int n23 = pp[3] + pp[4] + 1 >> 1;
                p[0][0] = n23;
                p[2][1] = n23;
                int n24 = pp[3] + pp[4] * 2 + pp[5] + 2 >> 2;
                p[1][0] = n24;
                p[3][1] = n24;
                p[2][0] = pp[4] + pp[5] * 2 + pp[6] + 2 >> 2;
                p[3][0] = pp[5] + pp[6] * 2 + pp[7] + 2 >> 2;
                break;
            }
            case 9: {
                p[0][0] = left[0] + left[1] + 1 >> 1;
                p[1][0] = left[0] + left[1] * 2 + left[2] + 2 >> 2;
                int n = left[1] + left[2] + 1 >> 1;
                p[0][1] = n;
                p[2][0] = n;
                int n25 = left[1] + left[2] * 2 + left[3] + 2 >> 2;
                p[1][1] = n25;
                p[3][0] = n25;
                int n26 = left[2] + left[3] + 1 >> 1;
                p[0][2] = n26;
                p[2][1] = n26;
                int n27 = left[2] + left[3] * 2 + left[3] + 2 >> 2;
                p[1][2] = n27;
                p[3][1] = n27;
                int n28 = left[3];
                p[3][3] = n28;
                p[2][3] = n28;
                p[1][3] = n28;
                p[0][3] = n28;
                p[3][2] = n28;
                p[2][2] = n28;
                break;
            }
            default: {
                System.out.println("TODO: " + sb.getMode());
                System.exit(0);
            }
        }
        sb.setPredict(p);
    }

    public void reconstruct() {
        SubBlock sb = this;
        int[][] p = sb.getPredict(1, false);
        int[][] dest = new int[4][4];
        int[][] diff = sb.getDiff();
        for (int r = 0; r < 4; ++r) {
            for (int c = 0; c < 4; ++c) {
                int a = diff[r][c] + p[r][c];
                if (a < 0) {
                    a = 0;
                }
                if (a > 255) {
                    a = 255;
                }
                dest[r][c] = a;
            }
        }
        sb.setDest(dest);
        if (!this.getMacroBlock().isKeepDebugInfo()) {
            sb.diff = null;
            sb.predict = null;
            sb.tokens = null;
        }
    }

    public void setDest(int[][] dest) {
        this.dest = dest;
    }

    public void setDiff(int[][] diff) {
        this.diff = diff;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setPixel(int x, int y, int p) {
        if (this.dest == null) {
            this.dest = new int[4][4];
        }
        this.dest[x][y] = p;
    }

    public void setPredict(int[][] predict) {
        this.predict = predict;
    }

    public String toString() {
        String r = "[";
        for (int x = 0; x < 16; ++x) {
            r = r + this.tokens[x] + " ";
        }
        r = r + "]";
        return r;
    }

    public static enum PLANE {
        U,
        V,
        Y1,
        Y2;

    }
}

