/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.builtin;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.builtin.SimpleReturnFunction;
import net.sourceforge.plantuml.tim.expression.TValue;

public class JsonMerge
extends SimpleReturnFunction {
    private static final TFunctionSignature SIGNATURE = new TFunctionSignature("%json_merge", 2);

    @Override
    public TFunctionSignature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 2;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> values, Map<String, TValue> named) throws EaterException {
        TValue data0 = values.get(0);
        if (!data0.isJson()) {
            throw new EaterException("Not JSON data", location);
        }
        TValue data1 = values.get(1);
        if (!data1.isJson()) {
            throw new EaterException("Not JSON data", location);
        }
        JsonValue json0 = data0.toJson().cloneMe();
        JsonValue json1 = data1.toJson();
        if (!json0.isArray() && !json0.isObject() && !json1.isArray() && !json1.isObject() || json0.isArray() && json1.isObject() || json0.isObject() && json1.isArray()) {
            return data0;
        }
        if (json0.isArray() && json1.isArray()) {
            for (JsonValue j1 : json1.asArray()) {
                json0.asArray().add(j1);
            }
            return TValue.fromJson(json0);
        }
        if (json0.isObject() && json1.isObject()) {
            json0.asObject().merge(json1.asObject());
            return TValue.fromJson(json0);
        }
        throw new EaterException("Bad JSON type", location);
    }
}

