/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public class ComplementSeveralDays
implements Something<GanttDiagram> {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexConcat(new RegexLeaf(4, "COMPLEMENT" + suffix, "(\\d+)[%s]+(day|week)s?(?:[%s]+and[%s]+(\\d+)[%s]+(day|week)s?)?"));
    }

    @Override
    public Failable<Load> getMe(GanttDiagram system, RegexResult arg, String suffix) {
        String nb1 = arg.get("COMPLEMENT" + suffix, 0);
        int factor1 = arg.get("COMPLEMENT" + suffix, 1).startsWith("w") ? system.daysInWeek() : 1;
        int days1 = Integer.parseInt(nb1) * factor1;
        String nb2 = arg.get("COMPLEMENT" + suffix, 2);
        int days2 = 0;
        if (nb2 != null) {
            int factor2 = arg.get("COMPLEMENT" + suffix, 3).startsWith("w") ? system.daysInWeek() : 1;
            days2 = Integer.parseInt(nb2) * factor2;
        }
        return Failable.ok(Load.inWinks(days1 + days2));
    }
}

