/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import com.plantuml.ubrex.UMatcher;
import com.plantuml.ubrex.UnicodeBracketedExpression;
import java.util.List;
import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontPosition;

public class CommandCreoleExposantChange
implements Command {
    private final FontPosition position;
    private final UnicodeBracketedExpression ubrex;

    @Override
    public String startingChars() {
        return "<";
    }

    private CommandCreoleExposantChange(String ubrexString, FontPosition position) {
        this.position = position;
        this.ubrex = UnicodeBracketedExpression.build(ubrexString);
    }

    public static Command create(FontPosition position) {
        String htmlTag = position.getHtmlTag();
        String ubrexString = "<" + htmlTag + ">\u3036$V=\u3004>\u3018</" + htmlTag + ">\u3019";
        return new CommandCreoleExposantChange(ubrexString, position);
    }

    @Override
    public int matchingSize(String line) {
        UMatcher matcher = this.ubrex.match(line);
        List<String> value = matcher.getCapture("V");
        if (value.size() == 0) {
            return 0;
        }
        return value.get(0).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        UMatcher matcher = this.ubrex.match(line);
        List<String> value = matcher.getCapture("V");
        String accepted = matcher.getAcceptedMatch();
        if (value.size() == 0) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = fc1.changeFontPosition(this.position);
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(value.get(0));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(accepted.length());
    }
}

