/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Worm;
import net.sourceforge.plantuml.activitydiagram3.ftile.WormMutation;
import net.sourceforge.plantuml.decoration.HtmlColorAndStyle;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XLine2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.utils.Direction;

public class Snake
implements UShape {
    private final Worm worm;
    private final UPolygon startDecoration;
    private final UPolygon endDecoration;
    private final Rainbow color;
    private final List<Text> texts;
    private final MergeStrategy mergeable;
    private final Direction emphasizeDirection;
    private final ISkinParam skinParam;

    public Snake move(double dx, double dy) {
        return new Snake(this.skinParam, this.startDecoration, this.color, this.endDecoration, this.worm.move(dx, dy), this.mergeable, this.emphasizeDirection, this.texts);
    }

    public final Snake ignoreForCompression() {
        this.worm.setIgnoreForCompression();
        return this;
    }

    public Snake emphasizeDirection(Direction emphasizeDirection) {
        return new Snake(this.skinParam, this.startDecoration, this.color, this.endDecoration, this.worm, this.mergeable, emphasizeDirection, this.texts);
    }

    public Snake withoutEndDecoration() {
        return new Snake(this.skinParam, this.startDecoration, this.color, null, this.worm, this.mergeable, this.emphasizeDirection, this.texts);
    }

    public Snake withMerge(MergeStrategy mergeable) {
        return new Snake(this.skinParam, this.startDecoration, this.color, this.endDecoration, this.worm, mergeable, this.emphasizeDirection, this.texts);
    }

    public Snake withLabel(TextBlock textBlock, HorizontalAlignment horizontalAlignment) {
        if (textBlock != null) {
            this.texts.add(new Text(textBlock, null, horizontalAlignment));
        }
        return this;
    }

    public Snake withLabel(TextBlock textBlock, VerticalAlignment verticalAlignment) {
        if (textBlock != null && textBlock != TextBlockUtils.EMPTY_TEXT_BLOCK) {
            this.texts.add(new Text(textBlock, verticalAlignment, null));
        }
        return this;
    }

    public static Snake create(ISkinParam skinParam, Rainbow color) {
        Style style = StyleSignatureBasic.activityArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
        return new Snake(skinParam, null, color, null, new Worm(style, skinParam.arrows()), MergeStrategy.FULL, null, new ArrayList<Text>());
    }

    public static Snake create(ISkinParam skinParam, Rainbow color, UPolygon endDecoration) {
        Style style = StyleSignatureBasic.activityArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
        return new Snake(skinParam, null, color, endDecoration, new Worm(style, skinParam.arrows()), MergeStrategy.FULL, null, new ArrayList<Text>());
    }

    public static Snake create(ISkinParam skinParam, UPolygon startDecoration, Rainbow color, UPolygon endDecoration) {
        Style style = StyleSignatureBasic.activityArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
        return new Snake(skinParam, startDecoration, color, endDecoration, new Worm(style, skinParam.arrows()), MergeStrategy.FULL, null, new ArrayList<Text>());
    }

    private Snake(ISkinParam skinParam, UPolygon startDecoration, Rainbow color, UPolygon endDecoration, Worm worm, MergeStrategy mergeable, Direction emphasizeDirection, List<Text> texts) {
        if (Objects.requireNonNull(color).size() == 0) {
            throw new IllegalArgumentException();
        }
        this.skinParam = skinParam;
        this.worm = worm;
        this.texts = Objects.requireNonNull(texts);
        this.emphasizeDirection = emphasizeDirection;
        this.startDecoration = startDecoration;
        this.endDecoration = endDecoration;
        this.color = color;
        this.mergeable = mergeable;
    }

    public Snake translate(UTranslate translate) {
        return this.move(translate.getDx(), translate.getDy());
    }

    public String toString() {
        return this.worm.toString();
    }

    public void addPoint(double x, double y) {
        this.worm.addPoint(x, y);
    }

    public void addPoint(XPoint2D p) {
        this.addPoint(p.getX(), p.getY());
    }

    public void drawInternal(UGraphic ug) {
        if (this.color.size() > 1) {
            this.drawRainbow(ug);
        } else {
            this.worm.drawInternalOneColor(this.startDecoration, ug, this.color.getColors().get(0), 1.5, this.emphasizeDirection, this.endDecoration);
            this.drawInternalLabel(ug);
        }
    }

    private void drawRainbow(UGraphic ug) {
        List<HtmlColorAndStyle> colors = this.color.getColors();
        int colorArrowSeparationSpace = this.color.getColorArrowSeparationSpace();
        double move = 2 + colorArrowSeparationSpace;
        WormMutation mutation = WormMutation.create(this.worm, move);
        if (mutation.isDxNegative()) {
            colors = new ArrayList<HtmlColorAndStyle>(colors);
            Collections.reverse(colors);
        }
        double globalMove = -1.0 * (double)(colors.size() - 1) / 2.0;
        Worm current = this.worm.moveFirstPoint(mutation.getFirst().multiplyBy(globalMove));
        if (mutation.size() > 2) {
            current = current.moveLastPoint(mutation.getLast().multiplyBy(globalMove));
        }
        for (int i = 0; i < colors.size(); ++i) {
            double stroke = 1.5;
            if (colorArrowSeparationSpace == 0) {
                stroke = i == colors.size() - 1 ? 2.0 : 3.0;
            }
            current.drawInternalOneColor(this.startDecoration, ug, colors.get(i), stroke, this.emphasizeDirection, this.endDecoration);
            current = mutation.mute(current);
        }
        UTranslate textTranslate = mutation.getTextTranslate(colors.size());
        this.drawInternalLabel(ug.apply(textTranslate));
    }

    private void drawInternalLabel(UGraphic ug) {
        for (Text text : this.texts) {
            if (!text.hasText(ug.getStringBounder())) continue;
            XPoint2D position = this.getTextBlockPosition(ug.getStringBounder(), text);
            text.textBlock.drawU(ug.apply(UTranslate.point(position)));
        }
    }

    public double getMaxX(StringBounder stringBounder) {
        double result = this.worm.getMaxX();
        for (Text text : this.texts) {
            XPoint2D position = this.getTextBlockPosition(stringBounder, text);
            XDimension2D dim = text.textBlock.calculateDimension(stringBounder);
            result = Math.max(result, position.getX() + dim.getWidth());
        }
        return result;
    }

    private XPoint2D getTextBlockPosition(StringBounder stringBounder, Text text) {
        XPoint2D pt1 = this.worm.getPoint(0);
        XPoint2D pt2 = this.worm.getPoint(1);
        XDimension2D dim = text.textBlock.calculateDimension(stringBounder);
        double x = Math.max(pt1.getX(), pt2.getX()) + 4.0;
        boolean zigzag = this.worm.getDirectionsCode().startsWith("DLD") || this.worm.getDirectionsCode().startsWith("DRD");
        double y = (pt1.getY() + pt2.getY()) / 2.0 - dim.getHeight() / 2.0;
        if (text.verticalAlignment == VerticalAlignment.BOTTOM) {
            x = this.worm.getMinX();
            y = this.worm.getMaxY();
        } else if (text.verticalAlignment == VerticalAlignment.CENTER) {
            x = this.worm.getMinX();
            y = (this.worm.getFirst().getY() + this.worm.getLast().getY() - 10.0) / 2.0 - dim.getHeight() / 2.0;
        } else if (text.horizontalAlignment == HorizontalAlignment.CENTER && zigzag) {
            XPoint2D pt3 = this.worm.getPoint(2);
            x = (pt2.getX() + pt3.getX()) / 2.0 - dim.getWidth() / 2.0;
        } else if (text.horizontalAlignment == HorizontalAlignment.RIGHT && zigzag) {
            x = Math.max(pt1.getX(), pt2.getX()) - dim.getWidth() - 4.0;
        } else if (this.worm.getDirectionsCode().equals("RD")) {
            x = Math.max(pt1.getX(), pt2.getX());
            y = (pt1.getY() + this.worm.getPoint(2).getY()) / 2.0 - dim.getHeight() / 2.0;
        } else if (this.worm.getDirectionsCode().equals("LD")) {
            x = Math.min(pt1.getX(), pt2.getX());
            y = (pt1.getY() + this.worm.getPoint(2).getY()) / 2.0 - dim.getHeight() / 2.0;
        }
        return new XPoint2D(x, y);
    }

    public List<XLine2D> getHorizontalLines() {
        ArrayList<XLine2D> result = new ArrayList<XLine2D>();
        for (int i = 0; i < this.worm.size() - 1; ++i) {
            XPoint2D pt1 = this.worm.getPoint(i);
            XPoint2D pt2 = this.worm.getPoint(i + 1);
            if (pt1.getY() != pt2.getY()) continue;
            XLine2D line = XLine2D.line(pt1, pt2);
            result.add(line);
        }
        return result;
    }

    private XPoint2D getFirst() {
        return this.worm.getPoint(0);
    }

    public XPoint2D getLast() {
        return this.worm.getPoint(this.worm.size() - 1);
    }

    static boolean same(XPoint2D pt1, XPoint2D pt2) {
        return pt1.distance(pt2) < 0.001;
    }

    public Snake merge(Snake other, StringBounder stringBounder) {
        MergeStrategy strategy = this.mergeable.max(other.mergeable);
        if (strategy == MergeStrategy.NONE) {
            return null;
        }
        for (Text text : other.texts) {
            if (!text.hasText(stringBounder)) continue;
            return null;
        }
        if (Snake.same(this.getLast(), other.getFirst())) {
            UPolygon oneOf;
            UPolygon uPolygon = oneOf = other.endDecoration == null ? this.endDecoration : other.endDecoration;
            if (this.startDecoration != null || other.startDecoration != null) {
                throw new UnsupportedOperationException("Not yet coded: to be done");
            }
            ArrayList<Text> mergeTexts = new ArrayList<Text>(this.texts);
            mergeTexts.addAll(other.texts);
            Snake result = new Snake(this.skinParam, null, this.color, oneOf, this.worm.merge(other.worm, strategy), strategy, this.emphasizeDirection == null ? other.emphasizeDirection : this.emphasizeDirection, mergeTexts);
            return result;
        }
        if (Snake.same(this.getFirst(), other.getLast())) {
            return other.merge(this, stringBounder);
        }
        return null;
    }

    public boolean touches(Snake other) {
        if (other.mergeable != MergeStrategy.FULL) {
            return false;
        }
        if (other.worm.isPureHorizontal()) {
            return false;
        }
        return Snake.same(this.getLast(), other.getFirst());
    }

    public boolean doesHorizontalCross(MinMax minMax) {
        return this.worm.doesHorizontalCross(minMax);
    }

    static class Text {
        private final TextBlock textBlock;
        private final VerticalAlignment verticalAlignment;
        private final HorizontalAlignment horizontalAlignment;

        Text(TextBlock textBlock, VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment) {
            this.textBlock = Objects.requireNonNull(textBlock);
            this.verticalAlignment = verticalAlignment;
            this.horizontalAlignment = horizontalAlignment;
        }

        private boolean hasText(StringBounder stringBounder) {
            return !TextBlockUtils.isEmpty(this.textBlock, stringBounder);
        }
    }
}

