// SPDX-FileCopyrightText: Copyright (c) Kitware Inc.
// SPDX-FileCopyrightText: Copyright (c) Sandia Corporation
// SPDX-License-Identifier: BSD-3-Clause
#ifndef pqSourcesMenuReaction_h
#define pqSourcesMenuReaction_h

#include "pqApplicationComponentsModule.h"
#include <QObject>

class pqPipelineSource;
class pqProxyGroupMenuManager;
class pqServer;
/**
 * @ingroup Reactions
 * Reaction to handle creation of sources from the sources menu.
 */
class PQAPPLICATIONCOMPONENTS_EXPORT pqSourcesMenuReaction : public QObject
{
  Q_OBJECT
  typedef QObject Superclass;

public:
  pqSourcesMenuReaction(pqProxyGroupMenuManager* menuManager);

  static pqPipelineSource* createSource(const QString& group, const QString& name);

  /**
   * Method used to prompt user before creating a proxy. If the proxy hints has
   * "WarnOnCreate" hint, then the user will be prompted according to the
   * contents on the hint. Returns `false` if the user rejects the confirmation,
   * `true` otherwise.
   *
   * If `server` is null, then the active server is used.
   */
  static bool warnOnCreate(const QString& group, const QString& name, pqServer* server = nullptr);

public Q_SLOTS: // NOLINT(readability-redundant-access-specifiers)
  /**
   * Updates the enabled state. Applications need not explicitly call this.
   */
  virtual void updateEnableState();
  void updateEnableState(bool);

protected Q_SLOTS:
  /**
   * Called when the action is triggered.
   */
  virtual void onTriggered(const QString& group, const QString& name)
  {
    pqSourcesMenuReaction::createSource(group, name);
  }

private:
  Q_DISABLE_COPY(pqSourcesMenuReaction)
};

#endif
