/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.KANonce;
import org.opensaml.xmlsec.encryption.OriginatorKeyInfo;
import org.opensaml.xmlsec.encryption.RecipientKeyInfo;

public class AgreementMethodImpl
extends AbstractXMLObject
implements AgreementMethod {
    @Nullable
    private String algorithm;
    @Nullable
    private KANonce kaNonce;
    @Nullable
    private OriginatorKeyInfo originatorKeyInfo;
    @Nullable
    private RecipientKeyInfo recipientKeyInfo;
    @Nonnull
    private IndexedXMLObjectChildrenList<XMLObject> xmlChildren = new IndexedXMLObjectChildrenList(this);

    protected AgreementMethodImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nullable
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setAlgorithm(@Nullable String newAlgorithm) {
        this.algorithm = this.prepareForAssignment(this.algorithm, newAlgorithm);
    }

    @Override
    @Nullable
    public KANonce getKANonce() {
        return this.kaNonce;
    }

    @Override
    public void setKANonce(@Nullable KANonce newKANonce) {
        this.kaNonce = this.prepareForAssignment(this.kaNonce, newKANonce);
    }

    @Override
    @Nullable
    public OriginatorKeyInfo getOriginatorKeyInfo() {
        return this.originatorKeyInfo;
    }

    @Override
    public void setOriginatorKeyInfo(@Nullable OriginatorKeyInfo newOriginatorKeyInfo) {
        this.originatorKeyInfo = this.prepareForAssignment(this.originatorKeyInfo, newOriginatorKeyInfo);
    }

    @Override
    @Nullable
    public RecipientKeyInfo getRecipientKeyInfo() {
        return this.recipientKeyInfo;
    }

    @Override
    public void setRecipientKeyInfo(@Nullable RecipientKeyInfo newRecipientKeyInfo) {
        this.recipientKeyInfo = this.prepareForAssignment(this.recipientKeyInfo, newRecipientKeyInfo);
    }

    @Override
    @Nonnull
    public List<XMLObject> getUnknownXMLObjects() {
        return this.xmlChildren;
    }

    @Override
    @Nonnull
    public List<XMLObject> getUnknownXMLObjects(@Nonnull QName typeOrName) {
        return this.xmlChildren.subList(typeOrName);
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();
        if (this.kaNonce != null) {
            children.add(this.kaNonce);
        }
        children.addAll(this.xmlChildren);
        if (this.originatorKeyInfo != null) {
            children.add(this.originatorKeyInfo);
        }
        if (this.recipientKeyInfo != null) {
            children.add(this.recipientKeyInfo);
        }
        if (children.size() == 0) {
            return null;
        }
        return CollectionSupport.copyToList(children);
    }
}

