/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.saml.metadata.resolver.ClearableMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;

public class CompositeMetadataResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataResolver,
RefreshableMetadataResolver,
ClearableMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CompositeMetadataResolver.class);
    @Nullable
    @NotEmpty
    private String resolverType;
    @Nonnull
    private List<MetadataResolver> resolvers = CollectionSupport.emptyList();

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<MetadataResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(@Nullable List<MetadataResolver> newResolvers) throws ResolverException {
        this.checkSetterPreconditions();
        this.resolvers = newResolvers == null || newResolvers.isEmpty() ? CollectionSupport.emptyList() : CollectionSupport.copyToList(newResolvers);
    }

    @Override
    @Nullable
    @NotEmpty
    public String getType() {
        return this.resolverType;
    }

    public void setType(@Nullable @NotEmpty String type) {
        this.resolverType = StringSupport.trimOrNull(type);
    }

    @Override
    public boolean isRequireValidMetadata() {
        this.log.warn("Attempt to access unsupported requireValidMetadata property on ChainingMetadataResolver");
        return false;
    }

    @Override
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        throw new UnsupportedOperationException("Setting require valid metadata is not supported on chaining resolver");
    }

    @Override
    @Nullable
    public MetadataFilter getMetadataFilter() {
        this.log.warn("Attempt to access unsupported MetadataFilter property on ChainingMetadataResolver");
        return null;
    }

    @Override
    public void setMetadataFilter(@Nullable MetadataFilter newFilter) {
        throw new UnsupportedOperationException("Metadata filters are not supported on ChainingMetadataProviders");
    }

    @Override
    @Nonnull
    public Iterable<EntityDescriptor> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        this.checkComponentActive();
        return new CompositeMetadataResolverIterable(this.resolvers, criteria);
    }

    @Override
    public EntityDescriptor resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        this.checkComponentActive();
        EntityDescriptor metadata = null;
        for (MetadataResolver resolver : this.resolvers) {
            metadata = (EntityDescriptor)resolver.resolveSingle(criteria);
            if (metadata == null) continue;
            return metadata;
        }
        return null;
    }

    @Override
    public void clear() throws ResolverException {
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof ClearableMetadataResolver)) continue;
            ((ClearableMetadataResolver)resolver).clear();
        }
    }

    @Override
    public void clear(@Nonnull String entityID) throws ResolverException {
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof ClearableMetadataResolver)) continue;
            ((ClearableMetadataResolver)resolver).clear(entityID);
        }
    }

    @Override
    public void refresh() throws ResolverException {
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            ((RefreshableMetadataResolver)resolver).refresh();
        }
    }

    @Override
    @Nullable
    public Instant getLastUpdate() {
        Instant ret = null;
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            Instant lastUpdate = ((RefreshableMetadataResolver)resolver).getLastUpdate();
            if (ret != null && !ret.isBefore(lastUpdate)) continue;
            ret = lastUpdate;
        }
        return ret;
    }

    @Override
    @Nullable
    public Instant getLastRefresh() {
        Instant ret = null;
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            Instant lastRefresh = ((RefreshableMetadataResolver)resolver).getLastRefresh();
            if (ret != null && !ret.isBefore(lastRefresh)) continue;
            ret = lastRefresh;
        }
        return ret;
    }

    @Override
    @Nullable
    public Instant getLastSuccessfulRefresh() {
        Instant ret = null;
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            Instant lastSuccessRefresh = ((RefreshableMetadataResolver)resolver).getLastSuccessfulRefresh();
            if (ret != null && !ret.isBefore(lastSuccessRefresh)) continue;
            ret = lastSuccessRefresh;
        }
        return ret;
    }

    @Override
    @Nullable
    public Boolean wasLastRefreshSuccess() {
        for (MetadataResolver resolver : this.resolvers) {
            RefreshableMetadataResolver refreshable;
            Boolean flag;
            if (!(resolver instanceof RefreshableMetadataResolver) || (flag = (refreshable = (RefreshableMetadataResolver)resolver).wasLastRefreshSuccess()) == null || flag.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Throwable getLastFailureCause() {
        for (MetadataResolver resolver : this.resolvers) {
            RefreshableMetadataResolver refreshable;
            if (!(resolver instanceof RefreshableMetadataResolver) || (refreshable = (RefreshableMetadataResolver)resolver).getLastFailureCause() == null) continue;
            return refreshable.getLastFailureCause();
        }
        return null;
    }

    private static class CompositeMetadataResolverIterable
    implements Iterable<EntityDescriptor> {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(CompositeMetadataResolverIterable.class);
        @Nonnull
        private final List<MetadataResolver> resolvers;
        @Nullable
        private final CriteriaSet criteria;

        public CompositeMetadataResolverIterable(@Nonnull List<MetadataResolver> composedResolvers, @Nullable CriteriaSet metadataCritiera) {
            this.resolvers = CollectionSupport.copyToList(composedResolvers);
            this.criteria = metadataCritiera;
        }

        @Override
        public Iterator<EntityDescriptor> iterator() {
            return new CompositeMetadataResolverIterator();
        }

        private class CompositeMetadataResolverIterator
        implements Iterator<EntityDescriptor> {
            @Nonnull
            private Iterator<MetadataResolver> resolverIterator;
            private MetadataResolver currentResolver;
            private Iterator<EntityDescriptor> currentResolverMetadataIterator;

            public CompositeMetadataResolverIterator() {
                this.resolverIterator = CompositeMetadataResolverIterable.this.resolvers.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.currentResolverMetadataIterator == null || !this.currentResolverMetadataIterator.hasNext()) {
                    this.proceedToNextResolverIterator();
                }
                return this.currentResolverMetadataIterator != null && this.currentResolverMetadataIterator.hasNext();
            }

            @Override
            public EntityDescriptor next() {
                if (this.currentResolverMetadataIterator == null || !this.currentResolverMetadataIterator.hasNext()) {
                    this.proceedToNextResolverIterator();
                }
                if (this.currentResolverMetadataIterator != null) {
                    return this.currentResolverMetadataIterator.next();
                }
                throw new NoSuchElementException("No further elements");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void proceedToNextResolverIterator() {
                try {
                    while (this.resolverIterator.hasNext()) {
                        this.currentResolver = this.resolverIterator.next();
                        this.currentResolverMetadataIterator = this.currentResolver.resolve(CompositeMetadataResolverIterable.this.criteria).iterator();
                        if (!this.currentResolverMetadataIterator.hasNext()) continue;
                        return;
                    }
                }
                catch (ResolverException e) {
                    CompositeMetadataResolverIterable.this.log.debug("Error encountered attempting to fetch results from resolver", (Throwable)e);
                }
            }
        }
    }
}

