/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.security.privileges.dlsfls.DlsRestriction;
import org.opensearch.security.privileges.dlsfls.DocumentPrivileges;
import org.opensearch.security.privileges.dlsfls.IndexToRuleMap;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.user.User;

public class ResourceSharingDlsUtils {
    private static final Logger LOGGER = LogManager.getLogger(ResourceSharingDlsUtils.class);

    public static IndexToRuleMap<DlsRestriction> resourceRestrictions(NamedXContentRegistry xContentRegistry, IndexResolverReplacer.Resolved resolved, User user) {
        DlsRestriction restriction;
        ArrayList<Object> principals = new ArrayList<Object>();
        principals.add("user:*");
        principals.add("user:" + user.getName());
        if (user.getSecurityRoles() != null) {
            user.getSecurityRoles().forEach(r -> principals.add("role:" + r));
        }
        if (user.getRoles() != null) {
            user.getRoles().forEach(br -> principals.add("backend:" + br));
        }
        XContentBuilder builder = null;
        try {
            builder = XContentFactory.jsonBuilder();
            builder.startObject().startObject("terms").array("all_shared_principals", principals.toArray()).endObject().endObject();
            String dlsJson = builder.toString();
            restriction = new DlsRestriction(List.of(DocumentPrivileges.getRenderedDlsQuery(xContentRegistry, dlsJson)));
        }
        catch (IOException e) {
            LOGGER.warn("Received error while applying resource restrictions.", (Throwable)e);
            restriction = DlsRestriction.FULL;
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (String index : resolved.getAllIndices()) {
            mapBuilder.put((Object)index, (Object)restriction);
        }
        return new IndexToRuleMap<DlsRestriction>(mapBuilder.build());
    }
}

