/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.http.kerberos.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class JaasKrbUtil {
    private static boolean debug = false;

    private JaasKrbUtil() {
    }

    public static void setDebug(boolean debug) {
        JaasKrbUtil.debug = debug;
    }

    public static Subject loginUsingPassword(String principal, String password) throws LoginException {
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal(principal));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        Configuration conf = JaasKrbUtil.usePassword(principal);
        String confName = "PasswordConf";
        KrbCallbackHandler callback = new KrbCallbackHandler(principal, password);
        LoginContext loginContext = new LoginContext("PasswordConf", subject, callback, conf);
        loginContext.login();
        return loginContext.getSubject();
    }

    public static Subject loginUsingTicketCache(String principal, Path cachePath) throws LoginException {
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal(principal));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        Configuration conf = JaasKrbUtil.useTicketCache(principal, cachePath);
        String confName = "TicketCacheConf";
        LoginContext loginContext = new LoginContext("TicketCacheConf", subject, null, conf);
        loginContext.login();
        return loginContext.getSubject();
    }

    public static Subject loginUsingKeytab(Set<String> principalAsStrings, Path keytabPath, boolean initiator) throws LoginException {
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        for (String p : principalAsStrings) {
            principals.add(new KerberosPrincipal(p));
        }
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        Configuration conf = JaasKrbUtil.useKeytab("*", keytabPath, initiator);
        String confName = "KeytabConf";
        LoginContext loginContext = new LoginContext("KeytabConf", subject, null, conf);
        loginContext.login();
        return loginContext.getSubject();
    }

    public static Configuration usePassword(String principal) {
        return new PasswordJaasConf(principal);
    }

    public static Configuration useTicketCache(String principal, Path credentialPath) {
        return new TicketCacheJaasConf(principal, credentialPath);
    }

    public static Configuration useKeytab(String principal, Path keytabPath, boolean initiator) {
        return new KeytabJaasConf(principal, keytabPath, initiator);
    }

    private static String getKrb5LoginModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
    }

    public static class KrbCallbackHandler
    implements CallbackHandler {
        private final String principal;
        private final String password;

        public KrbCallbackHandler(String principal, String password) {
            this.principal = principal;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                PasswordCallback pc;
                if (!(callbacks[i] instanceof PasswordCallback) || !(pc = (PasswordCallback)callbacks[i]).getPrompt().contains(this.principal)) continue;
                pc.setPassword(this.password.toCharArray());
                break;
            }
        }
    }

    static class PasswordJaasConf
    extends Configuration {
        private final String principal;

        public PasswordJaasConf(String principal) {
            this.principal = principal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("principal", this.principal);
            options.put("storeKey", "true");
            options.put("useTicketCache", "true");
            options.put("useKeyTab", "false");
            options.put("renewTGT", "true");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", "true");
            options.put("debug", String.valueOf(debug));
            return new AppConfigurationEntry[]{new AppConfigurationEntry(JaasKrbUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    static class TicketCacheJaasConf
    extends Configuration {
        private final String principal;
        private final Path clientCredentialPath;

        public TicketCacheJaasConf(String principal, Path clientCredentialPath) {
            this.principal = principal;
            this.clientCredentialPath = clientCredentialPath;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("principal", this.principal);
            options.put("storeKey", "false");
            options.put("doNotPrompt", "false");
            options.put("useTicketCache", "true");
            options.put("renewTGT", "true");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", "true");
            options.put("ticketCache", this.clientCredentialPath.toAbsolutePath().toString());
            options.put("debug", String.valueOf(debug));
            return new AppConfigurationEntry[]{new AppConfigurationEntry(JaasKrbUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    static class KeytabJaasConf
    extends Configuration {
        private final String principal;
        private final Path keytabPath;
        private final boolean initiator;

        public KeytabJaasConf(String principal, Path keytab, boolean initiator) {
            this.principal = principal;
            this.keytabPath = keytab;
            this.initiator = initiator;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("keyTab", this.keytabPath.toAbsolutePath().toString());
            options.put("principal", this.principal);
            options.put("useKeyTab", "true");
            options.put("storeKey", "true");
            options.put("doNotPrompt", "true");
            options.put("renewTGT", "false");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", String.valueOf(this.initiator));
            options.put("debug", String.valueOf(debug));
            return new AppConfigurationEntry[]{new AppConfigurationEntry(JaasKrbUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

