/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml.implementation.aalto.out;

import com.azure.xml.implementation.aalto.out.NsBinder;
import com.azure.xml.implementation.aalto.out.WName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

final class OutputElement {
    private OutputElement _parent;
    private WName _name;
    private String _uri;
    private String _defaultNsURI;
    private NsBinder _nsBinder;

    private OutputElement() {
        this._parent = null;
        this._name = null;
        this._uri = null;
        this._nsBinder = null;
        this._defaultNsURI = "";
    }

    private OutputElement(OutputElement parent, WName name, String uri, NsBinder binder) {
        this._parent = parent;
        this._name = name;
        this._uri = uri;
        this._nsBinder = binder;
        this._defaultNsURI = parent._defaultNsURI;
    }

    static OutputElement createRoot() {
        return new OutputElement();
    }

    OutputElement createChild(WName name) {
        return new OutputElement(this, name, this._defaultNsURI, this._nsBinder);
    }

    OutputElement createChild(WName name, String uri) {
        return new OutputElement(this, name, uri, this._nsBinder);
    }

    OutputElement reuseAsChild(OutputElement parent, WName name) {
        OutputElement poolHead = this._parent;
        this.relink(parent, name, this._defaultNsURI);
        return poolHead;
    }

    OutputElement reuseAsChild(OutputElement parent, WName name, String nsURI) {
        OutputElement poolHead = this._parent;
        this.relink(parent, name, nsURI);
        return poolHead;
    }

    private void relink(OutputElement parent, WName name, String uri) {
        this._parent = parent;
        this._name = name;
        this._uri = uri;
        this._nsBinder = parent._nsBinder;
        this._defaultNsURI = parent._defaultNsURI;
    }

    void addToPool(OutputElement poolHead) {
        this._parent = poolHead;
    }

    public OutputElement getParent() {
        return this._parent;
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public WName getName() {
        return this._name;
    }

    public String getLocalName() {
        return this._name.getLocalName();
    }

    public QName getQName() {
        return new QName(this._uri, this._name.getLocalName(), this._name.getPrefix());
    }

    public void setDefaultNsURI(String uri) {
        this._defaultNsURI = uri;
    }

    public void addPrefix(String prefix, String uri) {
        if (this._nsBinder == null) {
            this._nsBinder = NsBinder.createEmpty();
        } else if (this._parent != null && this._parent._nsBinder == this._nsBinder) {
            this._nsBinder = this._nsBinder.createChild();
        }
        this._nsBinder.addMapping(prefix, uri);
    }

    public String getNamespaceURI(String prefix) {
        if (prefix.isEmpty()) {
            return this._defaultNsURI;
        }
        if (this._nsBinder != null) {
            return this._nsBinder.findUriByPrefix(prefix);
        }
        return null;
    }

    public String getPrefix(String uri) {
        if (this._defaultNsURI.equals(uri)) {
            return "";
        }
        if (this._nsBinder != null) {
            return this._nsBinder.findPrefixByUri(uri);
        }
        return null;
    }

    public Iterator<String> getPrefixes(String uri, NamespaceContext rootNsContext) {
        List<String> l = null;
        if (this._defaultNsURI.equals(uri)) {
            l = new ArrayList<String>();
            l.add("");
        }
        if (this._nsBinder != null) {
            l = this._nsBinder.getPrefixesBoundToUri(uri, l);
        }
        if (rootNsContext != null) {
            Iterator<String> it = rootNsContext.getPrefixes(uri);
            while (it.hasNext()) {
                String prefix = it.next();
                if (prefix.isEmpty()) continue;
                if (l == null) {
                    l = new ArrayList();
                } else if (l.contains(prefix)) continue;
                l.add(prefix);
            }
        }
        if (l == null) {
            return Collections.emptyIterator();
        }
        return l.iterator();
    }

    public String getExplicitPrefix(String uri, NamespaceContext rootNsContext) {
        String prefix;
        if (this._nsBinder != null && (prefix = this._nsBinder.findPrefixByUri(uri)) != null) {
            return prefix;
        }
        if (rootNsContext != null && (prefix = rootNsContext.getPrefix(uri)) != null && !prefix.isEmpty()) {
            return prefix;
        }
        return null;
    }

    public int hashCode() {
        return this._name.hashCode();
    }
}

