/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.internal.verification.api.VerificationDataInOrder;
import org.mockito.internal.verification.api.VerificationInOrderMode;
import org.mockito.invocation.Invocation;
import org.mockito.verification.VerificationMode;

public class NoMoreInteractions
implements VerificationMode,
VerificationInOrderMode {
    @Override
    public void verify(VerificationData data) {
        Invocation unverified = InvocationsFinder.findFirstUnverified(data.getAllInvocations());
        if (unverified != null) {
            throw Reporter.noMoreInteractionsWanted(unverified, data.getAllInvocations());
        }
    }

    @Override
    public void verifyInOrder(VerificationDataInOrder data) {
        List<Invocation> invocations = data.getAllInvocations();
        Invocation unverified = InvocationsFinder.findFirstUnverifiedInOrder(data.getOrderingContext(), invocations);
        if (unverified != null) {
            throw Reporter.noMoreInteractionsWantedInOrder(unverified);
        }
    }

    @Override
    public VerificationMode description(String description) {
        return VerificationModeFactory.description(this, description);
    }
}

