/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.UpdateMessageResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class UpdateMessageRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, UpdateMessageRequest> {
    @Nonnull
    private final Map<String, JsonData> additionalInfo;
    @Nullable
    private final String input;
    @Nonnull
    private final String messageId;
    @Nullable
    private final String origin;
    @Nullable
    private final String promptTemplate;
    @Nullable
    private final String response;
    public static final JsonpDeserializer<UpdateMessageRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateMessageRequest::setupUpdateMessageRequestDeserializer);
    public static final Endpoint<UpdateMessageRequest, UpdateMessageResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateMessageRequest, UpdateMessageResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_ml/memory/message/");
        SimpleEndpoint.pathEncode(request.messageId, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateMessageResponse._DESERIALIZER);

    private UpdateMessageRequest(Builder builder) {
        super(builder);
        this.additionalInfo = ApiTypeHelper.unmodifiable(builder.additionalInfo);
        this.input = builder.input;
        this.messageId = ApiTypeHelper.requireNonNull(builder.messageId, this, "messageId");
        this.origin = builder.origin;
        this.promptTemplate = builder.promptTemplate;
        this.response = builder.response;
    }

    public static UpdateMessageRequest of(Function<Builder, ObjectBuilder<UpdateMessageRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, JsonData> additionalInfo() {
        return this.additionalInfo;
    }

    @Nullable
    public final String input() {
        return this.input;
    }

    @Nonnull
    public final String messageId() {
        return this.messageId;
    }

    @Nullable
    public final String origin() {
        return this.origin;
    }

    @Nullable
    public final String promptTemplate() {
        return this.promptTemplate;
    }

    @Nullable
    public final String response() {
        return this.response;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.additionalInfo)) {
            generator.writeKey("additional_info");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.additionalInfo.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.input != null) {
            generator.writeKey("input");
            generator.write(this.input);
        }
        if (this.origin != null) {
            generator.writeKey("origin");
            generator.write(this.origin);
        }
        if (this.promptTemplate != null) {
            generator.writeKey("prompt_template");
            generator.write(this.promptTemplate);
        }
        if (this.response != null) {
            generator.writeKey("response");
            generator.write(this.response);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUpdateMessageRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::additionalInfo, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "additional_info");
        op.add(Builder::input, JsonpDeserializer.stringDeserializer(), "input");
        op.add(Builder::origin, JsonpDeserializer.stringDeserializer(), "origin");
        op.add(Builder::promptTemplate, JsonpDeserializer.stringDeserializer(), "prompt_template");
        op.add(Builder::response, JsonpDeserializer.stringDeserializer(), "response");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.additionalInfo);
        result = 31 * result + Objects.hashCode(this.input);
        result = 31 * result + this.messageId.hashCode();
        result = 31 * result + Objects.hashCode(this.origin);
        result = 31 * result + Objects.hashCode(this.promptTemplate);
        result = 31 * result + Objects.hashCode(this.response);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateMessageRequest other = (UpdateMessageRequest)o;
        return Objects.equals(this.additionalInfo, other.additionalInfo) && Objects.equals(this.input, other.input) && this.messageId.equals(other.messageId) && Objects.equals(this.origin, other.origin) && Objects.equals(this.promptTemplate, other.promptTemplate) && Objects.equals(this.response, other.response);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, UpdateMessageRequest> {
        @Nullable
        private Map<String, JsonData> additionalInfo;
        @Nullable
        private String input;
        private String messageId;
        @Nullable
        private String origin;
        @Nullable
        private String promptTemplate;
        @Nullable
        private String response;

        public Builder() {
        }

        private Builder(UpdateMessageRequest o) {
            super(o);
            this.additionalInfo = Builder._mapCopy(o.additionalInfo);
            this.input = o.input;
            this.messageId = o.messageId;
            this.origin = o.origin;
            this.promptTemplate = o.promptTemplate;
            this.response = o.response;
        }

        private Builder(Builder o) {
            super(o);
            this.additionalInfo = Builder._mapCopy(o.additionalInfo);
            this.input = o.input;
            this.messageId = o.messageId;
            this.origin = o.origin;
            this.promptTemplate = o.promptTemplate;
            this.response = o.response;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder additionalInfo(Map<String, JsonData> map) {
            this.additionalInfo = Builder._mapPutAll(this.additionalInfo, map);
            return this;
        }

        @Nonnull
        public final Builder additionalInfo(String key, JsonData value) {
            this.additionalInfo = Builder._mapPut(this.additionalInfo, key, value);
            return this;
        }

        @Nonnull
        public final Builder input(@Nullable String value) {
            this.input = value;
            return this;
        }

        @Nonnull
        public final Builder messageId(String value) {
            this.messageId = value;
            return this;
        }

        @Nonnull
        public final Builder origin(@Nullable String value) {
            this.origin = value;
            return this;
        }

        @Nonnull
        public final Builder promptTemplate(@Nullable String value) {
            this.promptTemplate = value;
            return this;
        }

        @Nonnull
        public final Builder response(@Nullable String value) {
            this.response = value;
            return this;
        }

        @Override
        @Nonnull
        public UpdateMessageRequest build() {
            this._checkSingleUse();
            return new UpdateMessageRequest(this);
        }
    }
}

