/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.GetStatsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class GetStatsRequest
extends RequestBase
implements ToCopyableBuilder<Builder, GetStatsRequest> {
    @Nullable
    private final String nodeId;
    @Nullable
    private final String stat;
    public static final Endpoint<GetStatsRequest, GetStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetStatsRequest, GetStatsResponse>(request -> "GET", request -> {
        boolean _nodeId = true;
        int _stat = 2;
        int propsSet = 0;
        if (request.nodeId() != null) {
            propsSet |= 1;
        }
        if (request.stat() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            return "/_plugins/_ml/stats";
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_ml/");
            SimpleEndpoint.pathEncode(request.nodeId, buf);
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_ml/");
            SimpleEndpoint.pathEncode(request.nodeId, buf);
            buf.append("/stats/");
            SimpleEndpoint.pathEncode(request.stat, buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_ml/stats/");
            SimpleEndpoint.pathEncode(request.stat, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetStatsResponse._DESERIALIZER);

    private GetStatsRequest(Builder builder) {
        super(builder);
        this.nodeId = builder.nodeId;
        this.stat = builder.stat;
    }

    public static GetStatsRequest of(Function<Builder, ObjectBuilder<GetStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final String stat() {
        return this.stat;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.nodeId);
        result = 31 * result + Objects.hashCode(this.stat);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetStatsRequest other = (GetStatsRequest)o;
        return Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.stat, other.stat);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GetStatsRequest> {
        @Nullable
        private String nodeId;
        @Nullable
        private String stat;

        public Builder() {
        }

        private Builder(GetStatsRequest o) {
            super(o);
            this.nodeId = o.nodeId;
            this.stat = o.stat;
        }

        private Builder(Builder o) {
            super(o);
            this.nodeId = o.nodeId;
            this.stat = o.stat;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder nodeId(@Nullable String value) {
            this.nodeId = value;
            return this;
        }

        @Nonnull
        public final Builder stat(@Nullable String value) {
            this.stat = value;
            return this;
        }

        @Override
        @Nonnull
        public GetStatsRequest build() {
            this._checkSingleUse();
            return new GetStatsRequest(this);
        }
    }
}

