/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationRange;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RangeAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, RangeAggregation> {
    @Nullable
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final Boolean keyed;
    @Nullable
    private final Integer missing;
    @Nonnull
    private final List<AggregationRange> ranges;
    @Nullable
    private final Script script;
    public static final JsonpDeserializer<RangeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RangeAggregation::setupRangeAggregationDeserializer);

    private RangeAggregation(Builder builder) {
        super(builder);
        this.field = builder.field;
        this.format = builder.format;
        this.keyed = builder.keyed;
        this.missing = builder.missing;
        this.ranges = ApiTypeHelper.unmodifiable(builder.ranges);
        this.script = builder.script;
    }

    public static RangeAggregation of(Function<Builder, ObjectBuilder<RangeAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Range;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Nullable
    public final Integer missing() {
        return this.missing;
    }

    @Nonnull
    public final List<AggregationRange> ranges() {
        return this.ranges;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing.intValue());
        }
        if (ApiTypeHelper.isDefined(this.ranges)) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (AggregationRange item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRangeAggregationDeserializer(ObjectDeserializer<Builder> op) {
        RangeAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
        op.add(Builder::missing, JsonpDeserializer.integerDeserializer(), "missing");
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(AggregationRange._DESERIALIZER), "ranges");
        op.add(Builder::script, Script._DESERIALIZER, "script");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.format);
        result = 31 * result + Objects.hashCode(this.keyed);
        result = 31 * result + Objects.hashCode(this.missing);
        result = 31 * result + Objects.hashCode(this.ranges);
        result = 31 * result + Objects.hashCode(this.script);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeAggregation other = (RangeAggregation)o;
        return Objects.equals(this.field, other.field) && Objects.equals(this.format, other.format) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.missing, other.missing) && Objects.equals(this.ranges, other.ranges) && Objects.equals(this.script, other.script);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RangeAggregation> {
        @Nullable
        private String field;
        @Nullable
        private String format;
        @Nullable
        private Boolean keyed;
        @Nullable
        private Integer missing;
        @Nullable
        private List<AggregationRange> ranges;
        @Nullable
        private Script script;

        public Builder() {
        }

        private Builder(RangeAggregation o) {
            super(o);
            this.field = o.field;
            this.format = o.format;
            this.keyed = o.keyed;
            this.missing = o.missing;
            this.ranges = Builder._listCopy(o.ranges);
            this.script = o.script;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.format = o.format;
            this.keyed = o.keyed;
            this.missing = o.missing;
            this.ranges = Builder._listCopy(o.ranges);
            this.script = o.script;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        @Nonnull
        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Nonnull
        public final Builder missing(@Nullable Integer value) {
            this.missing = value;
            return this;
        }

        @Nonnull
        public final Builder ranges(List<AggregationRange> list) {
            this.ranges = Builder._listAddAll(this.ranges, list);
            return this;
        }

        @Nonnull
        public final Builder ranges(AggregationRange value, AggregationRange ... values) {
            this.ranges = Builder._listAdd(this.ranges, value, values);
            return this;
        }

        @Nonnull
        public final Builder ranges(Function<AggregationRange.Builder, ObjectBuilder<AggregationRange>> fn) {
            return this.ranges(fn.apply(new AggregationRange.Builder()).build(), new AggregationRange[0]);
        }

        @Nonnull
        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        @Nonnull
        public RangeAggregation build() {
            this._checkSingleUse();
            return new RangeAggregation(this);
        }
    }
}

