/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.stats;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.stats.ActionName;
import org.opensearch.ml.stats.MLActionStats;

public class MLModelStats
implements ToXContentFragment,
Writeable {
    private Map<ActionName, MLActionStats> modelStats;
    private Boolean isHidden;

    public MLModelStats(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        if (in.readBoolean()) {
            this.modelStats = in.readMap(stream -> (ActionName)stream.readEnum(ActionName.class), MLActionStats::new);
        }
        if (streamInputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            this.isHidden = in.readOptionalBoolean();
        }
    }

    public MLModelStats(Map<ActionName, MLActionStats> modelStats, Boolean isHidden) {
        this.modelStats = modelStats;
        this.isHidden = isHidden;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        if (this.modelStats != null && this.modelStats.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.modelStats, (stream, v) -> stream.writeEnum((Enum)v), (stream, stats) -> stats.writeTo(stream));
        } else {
            out.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            out.writeOptionalBoolean(this.isHidden);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.modelStats != null && this.modelStats.size() > 0) {
            for (Map.Entry<ActionName, MLActionStats> entry : this.modelStats.entrySet()) {
                builder.startObject(entry.getKey().name().toLowerCase(Locale.ROOT));
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
        }
        if (this.isHidden != null && this.isHidden.booleanValue()) {
            builder.field("is_hidden", true);
        }
        return builder;
    }

    public MLActionStats getActionStats(ActionName action) {
        return this.modelStats == null ? null : this.modelStats.get((Object)action);
    }

    @Generated
    public Boolean getIsHidden() {
        return this.isHidden;
    }
}

