/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest.mcpserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.transport.mcpserver.action.MLMcpToolsRegisterAction;
import org.opensearch.ml.common.transport.mcpserver.requests.McpToolBaseInput;
import org.opensearch.ml.common.transport.mcpserver.requests.register.MLMcpToolsRegisterNodesRequest;
import org.opensearch.ml.common.transport.mcpserver.requests.register.McpToolRegisterInput;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestMLMcpToolsRegisterAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestMLMcpToolsRegisterAction.class);
    private static final String ML_REGISTER_MCP_TOOLS_ACTION = "ml_register_mcp_tools_action";
    private final Map<String, Tool.Factory> toolFactories;
    private ClusterService clusterService;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLMcpToolsRegisterAction(Map<String, Tool.Factory> toolFactories, ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.toolFactories = toolFactories;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_REGISTER_MCP_TOOLS_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/mcp/tools/_register", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
            throw new OpenSearchException(MLCommonsSettings.ML_COMMONS_MCP_SERVER_DISABLED_MESSAGE, new Object[0]);
        }
        ActionRequestValidationException exception = new ActionRequestValidationException();
        MLMcpToolsRegisterNodesRequest registerNodesRequest = this.getRequest(request);
        if (CollectionUtils.isEmpty((Collection)registerNodesRequest.getMcpTools())) {
            exception.addValidationError("tools list can not be null");
            throw exception;
        }
        String duplicateName = null;
        HashSet<String> uniqueName = new HashSet<String>();
        for (McpToolRegisterInput mcpTool : registerNodesRequest.getMcpTools()) {
            if (uniqueName.contains(mcpTool.getName())) {
                duplicateName = mcpTool.getName();
                break;
            }
            uniqueName.add(mcpTool.getName());
        }
        if (duplicateName != null) {
            exception.addValidationError(String.format(Locale.ROOT, "duplicate tool name: %s found in the request", duplicateName));
            throw exception;
        }
        Set buildInToolNames = this.toolFactories.values().stream().map(Tool.Factory::getDefaultType).collect(Collectors.toSet());
        Set unrecognizedTools = registerNodesRequest.getMcpTools().stream().map(McpToolBaseInput::getType).filter(type -> !buildInToolNames.contains(type)).collect(Collectors.toSet());
        if (!unrecognizedTools.isEmpty()) {
            exception.addValidationError(String.format(Locale.ROOT, "Unrecognized tool in request: %s", unrecognizedTools));
            throw exception;
        }
        return channel -> client.execute((ActionType)MLMcpToolsRegisterAction.INSTANCE, (ActionRequest)registerNodesRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLMcpToolsRegisterNodesRequest getRequest(RestRequest request) throws IOException {
        XContentParser parser = request.contentParser();
        return MLMcpToolsRegisterNodesRequest.parse((XContentParser)parser, (String[])this.clusterService.state().nodes().getNodes().keySet().toArray(new String[0]));
    }
}

