/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLDeleteMemoriesByQueryRequest;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLDeleteMemoriesByQueryResponse;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportDeleteMemoriesByQueryAction
extends HandledTransportAction<MLDeleteMemoriesByQueryRequest, MLDeleteMemoriesByQueryResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportDeleteMemoriesByQueryAction.class);
    private final Client client;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MemoryContainerHelper memoryContainerHelper;

    @Inject
    public TransportDeleteMemoriesByQueryAction(TransportService transportService, ActionFilters actionFilters, Client client, MLFeatureEnabledSetting mlFeatureEnabledSetting, MemoryContainerHelper memoryContainerHelper) {
        super("cluster:admin/opensearch/ml/memory_containers/memories/delete_by_query", transportService, actionFilters, MLDeleteMemoriesByQueryRequest::new);
        this.client = client;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.memoryContainerHelper = memoryContainerHelper;
    }

    protected void doExecute(Task task, MLDeleteMemoriesByQueryRequest request, ActionListener<MLDeleteMemoriesByQueryResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        User user = RestActionUtils.getUserContext(this.client);
        String memoryContainerId = request.getMemoryContainerId();
        this.memoryContainerHelper.getMemoryContainer(memoryContainerId, (ActionListener<MLMemoryContainer>)ActionListener.wrap(container -> {
            if (!this.memoryContainerHelper.checkMemoryContainerAccess(user, (MLMemoryContainer)container)) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to delete memories in this container", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            MemoryType memoryType = request.getMemoryType();
            String memoryIndexName = this.getMemoryIndexName((MLMemoryContainer)container, memoryType);
            if (memoryIndexName == null) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("Invalid memory type or memory type is disabled: " + String.valueOf(memoryType), RestStatus.BAD_REQUEST, new Object[0]));
                return;
            }
            QueryBuilder query = request.getQuery();
            if (query == null) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("Query parameter is required for delete by query operation. To delete all documents, explicitly provide a match_all query: {\"query\": {\"match_all\": {}}}", RestStatus.BAD_REQUEST, new Object[0]));
                return;
            }
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{memoryIndexName});
            QueryBuilder containerFilteredQuery = this.memoryContainerHelper.addContainerIdFilter(memoryContainerId, query);
            QueryBuilder finalQuery = this.memoryContainerHelper.addOwnerIdFilter(user, containerFilteredQuery);
            deleteByQueryRequest.setQuery(finalQuery);
            deleteByQueryRequest.setRefresh(true);
            this.executeDeleteByQuery(container.getConfiguration(), deleteByQueryRequest, actionListener);
        }, error -> {
            log.error("Failed to get memory container: " + memoryContainerId, (Throwable)error);
            actionListener.onFailure(error);
        }));
    }

    private String getMemoryIndexName(MLMemoryContainer container, MemoryType memoryType) {
        if (container == null || container.getConfiguration() == null) {
            return null;
        }
        MemoryConfiguration config = container.getConfiguration();
        switch (memoryType) {
            case SESSIONS: {
                return config.isDisableSession() ? null : config.getSessionIndexName();
            }
            case WORKING: {
                return config.getWorkingMemoryIndexName();
            }
            case LONG_TERM: {
                return config.getLongMemoryIndexName();
            }
            case HISTORY: {
                return config.isDisableHistory() ? null : config.getLongMemoryHistoryIndexName();
            }
        }
        return null;
    }

    private void executeDeleteByQuery(MemoryConfiguration configuration, DeleteByQueryRequest deleteByQueryRequest, ActionListener<MLDeleteMemoriesByQueryResponse> actionListener) {
        ActionListener wrappedListener = ActionListener.wrap(response -> {
            if (response.getBulkFailures() != null && !response.getBulkFailures().isEmpty()) {
                log.warn("Bulk failures during delete by query: {}", (Object)response.getBulkFailures());
            }
            if (response.getSearchFailures() != null && !response.getSearchFailures().isEmpty()) {
                log.warn("Search failures during delete by query: {}", (Object)response.getSearchFailures());
            }
            if (response.isTimedOut()) {
                log.warn("Delete by query operation timed out");
            }
            log.info("Delete by query completed. Deleted {} documents in {} ms", (Object)response.getDeleted(), (Object)response.getTook().millis());
            actionListener.onResponse((Object)new MLDeleteMemoriesByQueryResponse(response));
        }, error -> {
            log.error("Failed to execute delete by query", (Throwable)error);
            actionListener.onFailure(error);
        });
        this.memoryContainerHelper.deleteDataByQuery(configuration, deleteByQueryRequest, (ActionListener<BulkByScrollResponse>)wrappedListener);
    }
}

