/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray.types;

import java.util.stream.IntStream;

public enum LayoutType {
    BATCH('N'),
    CHANNEL('C'),
    DEPTH('D'),
    HEIGHT('H'),
    WIDTH('W'),
    TIME('T'),
    UNKNOWN('?');

    private char value;

    private LayoutType(char value) {
        this.value = value;
    }

    public char getValue() {
        return this.value;
    }

    public static LayoutType fromValue(char value) {
        for (LayoutType type : LayoutType.values()) {
            if (value != type.value) continue;
            return type;
        }
        throw new IllegalArgumentException("The value does not match any layoutTypes. Use '?' for Unknown");
    }

    public static LayoutType[] fromValue(String layout) {
        return (LayoutType[])IntStream.range(0, layout.length()).mapToObj(i -> LayoutType.fromValue(layout.charAt(i))).toArray(LayoutType[]::new);
    }

    public static String toString(LayoutType[] layouts) {
        StringBuilder sb = new StringBuilder(layouts.length);
        for (LayoutType layout : layouts) {
            sb.append(layout.getValue());
        }
        return sb.toString();
    }
}

