/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp;

import ai.djl.modality.Input;
import ai.djl.translate.TranslateException;
import ai.djl.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.List;

public final class TextPrompt {
    private String text;
    private List<String> batch;

    private TextPrompt(String text) {
        this.text = text;
    }

    private TextPrompt(List<String> batch) {
        this.batch = batch;
    }

    public boolean isBatch() {
        return this.batch != null;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getBatch() {
        return this.batch;
    }

    public static TextPrompt parseInput(Input input) throws TranslateException {
        int pos;
        String contentType = input.getProperty("Content-Type", null);
        if (contentType != null && (pos = contentType.indexOf(59)) > 0) {
            contentType = contentType.substring(0, pos);
        }
        String text = input.getData().getAsString();
        if (!"application/json".equals(contentType)) {
            return new TextPrompt(text);
        }
        try {
            JsonElement element = (JsonElement)JsonUtils.GSON.fromJson(text, JsonElement.class);
            if (element != null && element.isJsonObject()) {
                element = element.getAsJsonObject().get("inputs");
            }
            if (element == null) {
                throw new TranslateException("Missing \"inputs\" in json.");
            }
            if (element.isJsonArray()) {
                List batch = (List)JsonUtils.GSON.fromJson(element, JsonUtils.LIST_TYPE);
                return new TextPrompt(batch);
            }
            return new TextPrompt(element.getAsString());
        }
        catch (JsonParseException e) {
            throw new TranslateException("Input is not a valid json.", e);
        }
    }
}

