/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonSerializable;
import ai.djl.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ImageServingTranslator
implements Translator<Input, Output> {
    private Translator<Image, ?> translator;
    private ImageFactory factory;

    public ImageServingTranslator(Translator<Image, ?> translator) {
        this.translator = translator;
        this.factory = ImageFactory.getInstance();
    }

    @Override
    public Batchifier getBatchifier() {
        return this.translator.getBatchifier();
    }

    @Override
    public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
        Output output = new Output();
        Object obj = this.translator.processOutput(ctx, list);
        if (obj instanceof JsonSerializable) {
            output.add((JsonSerializable)obj);
            output.addProperty("Content-Type", "application/json");
        } else if (obj instanceof Image) {
            Image img = (Image)obj;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                img.save(bos, "png");
                output.add(bos.toByteArray());
            }
            output.addProperty("Content-Type", "image/png");
        } else {
            output.add(BytesSupplier.wrapAsJson(obj));
            output.addProperty("Content-Type", "application/json");
        }
        return output;
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
        BytesSupplier data = input.getData();
        try {
            Image image;
            int pos;
            if (data == null) {
                throw new TranslateException("Input data is empty.");
            }
            String contentType = input.getProperty("Content-Type", null);
            if (contentType != null && (pos = contentType.indexOf(59)) > 0) {
                contentType = contentType.substring(0, pos);
            }
            if ("application/json".equalsIgnoreCase(contentType)) {
                try {
                    JsonElement element = (JsonElement)JsonUtils.GSON.fromJson(data.getAsString(), JsonElement.class);
                    if (element == null || !element.isJsonObject()) {
                        throw new TranslateException("Invalid JsonObject input.");
                    }
                    JsonObject obj = element.getAsJsonObject();
                    JsonPrimitive url = obj.getAsJsonPrimitive("image_url");
                    if (url == null) {
                        throw new TranslateException("Missing \"image_url\" in json.");
                    }
                    image = this.factory.fromUrl(url.getAsString());
                }
                catch (JsonParseException e) {
                    throw new TranslateException("Input is not a valid json.", e);
                }
            } else {
                image = this.factory.fromInputStream(new ByteArrayInputStream(data.getAsBytes()));
            }
            return this.translator.processInput(ctx, image);
        }
        catch (IOException e) {
            throw new TranslateException("Input is not an Image data type", e);
        }
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        this.translator.prepare(ctx);
    }
}

