/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.nlp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.TextSimilarityInputDataSet;
import org.opensearch.ml.common.input.MLInput;

@org.opensearch.ml.common.annotation.MLInput(functionNames={FunctionName.TEXT_SIMILARITY})
public class TextSimilarityMLInput
extends MLInput {
    public TextSimilarityMLInput(FunctionName algorithm, MLInputDataset dataset) {
        super(algorithm, null, dataset);
    }

    public TextSimilarityMLInput(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("algorithm", this.algorithm.name());
        if (this.parameters != null) {
            builder.field("parameters", (ToXContent)this.parameters);
        }
        if (this.inputDataset != null) {
            TextSimilarityInputDataSet ds = (TextSimilarityInputDataSet)this.inputDataset;
            List<String> docs = ds.getTextDocs();
            String queryText = ds.getQueryText();
            builder.field("query_text", queryText);
            if (docs != null && !docs.isEmpty()) {
                builder.startArray("text_docs");
                for (String d : docs) {
                    builder.value(d);
                }
                builder.endArray();
            }
        }
        builder.endObject();
        return builder;
    }

    public TextSimilarityMLInput(XContentParser parser, FunctionName functionName) throws IOException {
        this.algorithm = functionName;
        ArrayList<String> docs = new ArrayList<String>();
        String queryText = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "text_docs": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        String context = parser.text();
                        docs.add(context);
                    }
                    continue block8;
                }
                case "query_text": {
                    queryText = parser.text();
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        if (docs.isEmpty()) {
            throw new IllegalArgumentException("No text documents were provided");
        }
        if (queryText == null) {
            throw new IllegalArgumentException("No query text was provided");
        }
        this.inputDataset = new TextSimilarityInputDataSet(queryText, docs);
    }
}

