/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.utils;

import com.google.common.annotations.VisibleForTesting;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3Utils {
    @Generated
    private static final Logger log = LogManager.getLogger(S3Utils.class);

    @VisibleForTesting
    public static S3Client initS3Client(String accessKey, String secretKey, String sessionToken, String region) {
        AwsBasicCredentials credentials = sessionToken == null ? AwsBasicCredentials.create((String)accessKey, (String)secretKey) : AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)sessionToken);
        try {
            S3Client s3 = AccessController.doPrivileged(() -> S3Utils.lambda$initS3Client$0(region, (AwsCredentials)credentials));
            return s3;
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException("Can't load credentials", e);
        }
    }

    public static void putObject(S3Client s3Client, String bucketName, String key, String content) {
        try {
            AccessController.doPrivileged(() -> {
                PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key(key).build();
                s3Client.putObject(request, RequestBody.fromString((String)content));
                log.debug("Successfully uploaded file to S3: s3://{}/{}", (Object)bucketName, (Object)key);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException("Failed to upload file to S3: s3://" + bucketName + "/" + key, e);
        }
    }

    public static String getS3BucketName(String s3Uri) {
        String uriWithoutPrefix = s3Uri.substring(5);
        int slashIndex = uriWithoutPrefix.indexOf(47);
        if (slashIndex == -1) {
            return uriWithoutPrefix;
        }
        return uriWithoutPrefix.substring(0, slashIndex);
    }

    public static String getS3KeyName(String s3Uri) {
        String uriWithoutPrefix = s3Uri.substring(5);
        int slashIndex = uriWithoutPrefix.indexOf(47);
        if (slashIndex == -1) {
            return "";
        }
        return uriWithoutPrefix.substring(slashIndex + 1);
    }

    private static /* synthetic */ S3Client lambda$initS3Client$0(String region, AwsCredentials credentials) throws Exception {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)region))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials))).build();
    }
}

