/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import com.google.common.annotations.VisibleForTesting;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.spi.tools.WithModelTool;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.common.utils.ToolUtils;

@ToolAnnotation(value="McpStreamableHttpTool")
public class McpStreamableHttpTool
implements WithModelTool {
    @Generated
    private static final Logger log = LogManager.getLogger(McpStreamableHttpTool.class);
    public static final String TYPE = "McpStreamableHttpTool";
    private String name = "McpStreamableHttpTool";
    private Map<String, Object> attributes;
    @VisibleForTesting
    public static String DEFAULT_DESCRIPTION = "A tool from MCP Streamable HTTP Server";
    private String description = DEFAULT_DESCRIPTION;
    private McpSyncClient mcpSyncClient;
    @VisibleForTesting
    private Parser<?, ?> outputParser;

    public McpStreamableHttpTool(McpSyncClient mcpSyncClient) {
        this.mcpSyncClient = mcpSyncClient;
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        try {
            String resultJson;
            Map parameters = ToolUtils.extractInputParameters(originalParameters, this.attributes);
            String input = (String)parameters.get("input");
            Map inputArgs = StringUtils.fromJson((String)input, (String)"input");
            McpSchema.CallToolResult result = this.mcpSyncClient.callTool(new McpSchema.CallToolRequest(this.name, inputArgs));
            String response = resultJson = StringUtils.toJson((Object)result.content());
            listener.onResponse((Object)response);
        }
        catch (Exception e) {
            log.error("Failed to call MCP streamable HTTP tool: {}", (Object)this.getName(), (Object)e);
            listener.onFailure(e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.size() != 0;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public McpSyncClient getMcpSyncClient() {
        return this.mcpSyncClient;
    }

    @Generated
    public void setOutputParser(Parser<?, ?> outputParser) {
        this.outputParser = outputParser;
    }

    @Generated
    public Parser<?, ?> getOutputParser() {
        return this.outputParser;
    }

    public static class Factory
    implements WithModelTool.Factory<McpStreamableHttpTool> {
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<McpStreamableHttpTool> clazz = McpStreamableHttpTool.class;
            synchronized (McpStreamableHttpTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init() {
        }

        public McpStreamableHttpTool create(Map<String, Object> map) {
            return new McpStreamableHttpTool((McpSyncClient)map.get("mcp_sync_client"));
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return McpStreamableHttpTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        public List<String> getAllModelKeys() {
            return List.of();
        }
    }
}

