/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.remote.streaming;

import java.lang.reflect.Constructor;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorClientConfig;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.engine.algorithms.remote.streaming.HttpStreamingHandler;
import org.opensearch.ml.engine.algorithms.remote.streaming.StreamingHandler;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

public class StreamingHandlerFactory {
    public static StreamingHandler createHandler(String llmInterface, Connector connector, SdkAsyncHttpClient httpClient, ConnectorClientConfig connectorClientConfig) {
        switch (llmInterface.toLowerCase()) {
            case "bedrock/converse/claude": {
                return StreamingHandlerFactory.createBedrockHandler(httpClient, connector);
            }
            case "openai/v1/chat/completions": {
                return StreamingHandlerFactory.createHttpHandler(llmInterface, connector, connectorClientConfig);
            }
        }
        throw new IllegalArgumentException("Unsupported LLM interface: " + llmInterface);
    }

    private static StreamingHandler createBedrockHandler(SdkAsyncHttpClient httpClient, Connector connector) {
        try {
            Class<?> handlerClass = Class.forName("org.opensearch.ml.engine.algorithms.remote.streaming.BedrockStreamingHandler");
            Constructor<?> constructor = handlerClass.getConstructor(SdkAsyncHttpClient.class, Class.forName("org.opensearch.ml.common.connector.AwsConnector"));
            return (StreamingHandler)constructor.newInstance(httpClient, connector);
        }
        catch (ClassNotFoundException e) {
            throw new MLException("Bedrock streaming not available - Bedrock SDK not found", (Throwable)e);
        }
        catch (Exception e) {
            throw new MLException("Failed to initialize Bedrock streaming handler", (Throwable)e);
        }
    }

    private static StreamingHandler createHttpHandler(String llmInterface, Connector connector, ConnectorClientConfig connectorClientConfig) {
        return new HttpStreamingHandler(llmInterface, connector, connectorClientConfig);
    }
}

