/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.processors.field;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.IsoFields;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.data.columnar.ColumnarFeature;
import org.tribuo.data.columnar.FieldProcessor;

public final class DateFieldProcessor
implements FieldProcessor {
    private static final Logger logger = Logger.getLogger(DateFieldProcessor.class.getName());
    @Config(mandatory=true, description="The field name to read.")
    private String fieldName;
    @Config(mandatory=true, description="The date features to extract.")
    private EnumSet<DateFeatureType> featureTypes;
    @Config(mandatory=true, description="The expected date format.")
    private String dateFormat;
    private DateTimeFormatter formatter;
    @Config(mandatory=false, description="Sets the locale language.")
    private String localeLanguage = "en";
    @Config(mandatory=false, description="Sets the locale country.")
    private String localeCountry = "US";

    private DateFieldProcessor() {
    }

    public DateFieldProcessor(String fieldName, EnumSet<DateFeatureType> featureTypes, String dateFormat) {
        this(fieldName, featureTypes, dateFormat, "en", "US");
    }

    public DateFieldProcessor(String fieldName, EnumSet<DateFeatureType> featureTypes, String dateFormat, String localeLanguage, String localeCountry) {
        this.fieldName = fieldName;
        this.featureTypes = EnumSet.copyOf(featureTypes);
        this.dateFormat = dateFormat;
        this.localeLanguage = localeLanguage;
        this.localeCountry = localeCountry;
        this.postConfig();
    }

    public void postConfig() {
        Locale locale = new Locale(this.localeLanguage, this.localeCountry);
        try {
            this.formatter = DateTimeFormatter.ofPattern(this.dateFormat, locale);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyException((Throwable)e, "", "dateFormat", "dateFormat could not be parsed by DateTimeFormatter");
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<ColumnarFeature> process(String value) {
        try {
            LocalDate date = LocalDate.parse(value, this.formatter);
            ArrayList<ColumnarFeature> features = new ArrayList<ColumnarFeature>(this.featureTypes.size());
            for (DateFeatureType f : this.featureTypes) {
                int featureValue = f.extract(date);
                ColumnarFeature feature = new ColumnarFeature(this.fieldName, f.toString(), featureValue);
                features.add(feature);
            }
            return features;
        }
        catch (DateTimeParseException e) {
            logger.log(Level.WARNING, e.getParsedString());
            logger.log(Level.WARNING, String.format("Unable to parse date %s with formatter %s", value, this.formatter.toString()));
            return Collections.emptyList();
        }
    }

    @Override
    public FieldProcessor.GeneratedFeatureType getFeatureType() {
        return FieldProcessor.GeneratedFeatureType.INTEGER;
    }

    @Override
    public FieldProcessor copy(String newFieldName) {
        return new DateFieldProcessor(newFieldName, this.featureTypes, this.dateFormat);
    }

    public String toString() {
        return "DateFieldProcessor(fieldName='" + this.fieldName + '\'' + ", featureTypes=" + this.featureTypes + ", dateFormat='" + this.dateFormat + '\'' + ", formatter=" + this.formatter + ", localeLanguage='" + this.localeLanguage + '\'' + ", localeCountry='" + this.localeCountry + '\'' + ')';
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FieldProcessor");
    }

    public static enum DateFeatureType {
        DAY_OF_WEEK(l -> l.getDayOfWeek().getValue()),
        WEEK_OF_YEAR(l -> l.get(WeekFields.ISO.weekOfWeekBasedYear())),
        WEEK_OF_MONTH(l -> l.get(WeekFields.ISO.weekOfMonth())),
        DAY_OF_YEAR(LocalDate::getDayOfYear),
        EVEN_OR_ODD_DAY(l -> l.getDayOfYear() % 2),
        EVEN_OR_ODD_WEEK(l -> l.get(WeekFields.ISO.weekOfWeekBasedYear()) % 2),
        EVEN_OR_ODD_MONTH(l -> l.getMonthValue() % 2),
        EVEN_OR_ODD_YEAR(l -> l.getYear() % 2),
        CALENDAR_QUARTER(l -> l.get(IsoFields.QUARTER_OF_YEAR)),
        DAY_OF_QUARTER(l -> l.get(IsoFields.DAY_OF_QUARTER)),
        DAY(LocalDate::getDayOfMonth),
        MONTH(LocalDate::getMonthValue),
        YEAR(LocalDate::getYear);

        private final ToIntFunction<LocalDate> extractionFunction;

        private DateFeatureType(ToIntFunction<LocalDate> func) {
            this.extractionFunction = func;
        }

        public int extract(LocalDate date) {
            return this.extractionFunction.applyAsInt(date);
        }
    }
}

