/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.property;

import com.oracle.labs.mlrg.olcut.config.property.Property;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MapProperty
implements Property {
    private static final long serialVersionUID = 1L;
    private final Map<String, SimpleProperty> map;

    public MapProperty(Map<String, SimpleProperty> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    public Map<String, SimpleProperty> getMap() {
        return this.map;
    }

    @Override
    public MapProperty copy() {
        HashMap<String, SimpleProperty> output = new HashMap<String, SimpleProperty>();
        for (Map.Entry<String, SimpleProperty> e : this.map.entrySet()) {
            output.put(e.getKey(), e.getValue().copy());
        }
        return new MapProperty(output);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapProperty)) {
            return false;
        }
        MapProperty that = (MapProperty)o;
        return this.getMap().equals(that.getMap());
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public static MapProperty createFromStringMap(Map<String, String> input) {
        HashMap<String, SimpleProperty> output = new HashMap<String, SimpleProperty>();
        for (Map.Entry<String, String> e : input.entrySet()) {
            output.put(e.getKey(), new SimpleProperty(e.getValue()));
        }
        return new MapProperty(output);
    }
}

