/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ActivityStatus;
import software.amazon.awssdk.services.ec2.model.BatchState;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotFleetRequestConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpotFleetRequestConfig> {
    private static final SdkField<String> ACTIVITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivityStatus").getter(SpotFleetRequestConfig.getter(SpotFleetRequestConfig::activityStatusAsString)).setter(SpotFleetRequestConfig.setter(Builder::activityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityStatus").unmarshallLocationName("activityStatus").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(SpotFleetRequestConfig.getter(SpotFleetRequestConfig::createTime)).setter(SpotFleetRequestConfig.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<SpotFleetRequestConfigData> SPOT_FLEET_REQUEST_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpotFleetRequestConfig").getter(SpotFleetRequestConfig.getter(SpotFleetRequestConfig::spotFleetRequestConfig)).setter(SpotFleetRequestConfig.setter(Builder::spotFleetRequestConfig)).constructor(SpotFleetRequestConfigData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestConfig").unmarshallLocationName("spotFleetRequestConfig").build()}).build();
    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotFleetRequestId").getter(SpotFleetRequestConfig.getter(SpotFleetRequestConfig::spotFleetRequestId)).setter(SpotFleetRequestConfig.setter(Builder::spotFleetRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId").unmarshallLocationName("spotFleetRequestId").build()}).build();
    private static final SdkField<String> SPOT_FLEET_REQUEST_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotFleetRequestState").getter(SpotFleetRequestConfig.getter(SpotFleetRequestConfig::spotFleetRequestStateAsString)).setter(SpotFleetRequestConfig.setter(Builder::spotFleetRequestState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestState").unmarshallLocationName("spotFleetRequestState").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SpotFleetRequestConfig.getter(SpotFleetRequestConfig::tags)).setter(SpotFleetRequestConfig.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_STATUS_FIELD, CREATE_TIME_FIELD, SPOT_FLEET_REQUEST_CONFIG_FIELD, SPOT_FLEET_REQUEST_ID_FIELD, SPOT_FLEET_REQUEST_STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpotFleetRequestConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String activityStatus;
    private final Instant createTime;
    private final SpotFleetRequestConfigData spotFleetRequestConfig;
    private final String spotFleetRequestId;
    private final String spotFleetRequestState;
    private final List<Tag> tags;

    private SpotFleetRequestConfig(BuilderImpl builder) {
        this.activityStatus = builder.activityStatus;
        this.createTime = builder.createTime;
        this.spotFleetRequestConfig = builder.spotFleetRequestConfig;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.spotFleetRequestState = builder.spotFleetRequestState;
        this.tags = builder.tags;
    }

    public final ActivityStatus activityStatus() {
        return ActivityStatus.fromValue(this.activityStatus);
    }

    public final String activityStatusAsString() {
        return this.activityStatus;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final SpotFleetRequestConfigData spotFleetRequestConfig() {
        return this.spotFleetRequestConfig;
    }

    public final String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public final BatchState spotFleetRequestState() {
        return BatchState.fromValue(this.spotFleetRequestState);
    }

    public final String spotFleetRequestStateAsString() {
        return this.spotFleetRequestState;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfig)) {
            return false;
        }
        SpotFleetRequestConfig other = (SpotFleetRequestConfig)obj;
        return Objects.equals(this.activityStatusAsString(), other.activityStatusAsString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.spotFleetRequestConfig(), other.spotFleetRequestConfig()) && Objects.equals(this.spotFleetRequestId(), other.spotFleetRequestId()) && Objects.equals(this.spotFleetRequestStateAsString(), other.spotFleetRequestStateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SpotFleetRequestConfig").add("ActivityStatus", (Object)this.activityStatusAsString()).add("CreateTime", (Object)this.createTime()).add("SpotFleetRequestConfig", (Object)this.spotFleetRequestConfig()).add("SpotFleetRequestId", (Object)this.spotFleetRequestId()).add("SpotFleetRequestState", (Object)this.spotFleetRequestStateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityStatus": {
                return Optional.ofNullable(clazz.cast(this.activityStatusAsString()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "SpotFleetRequestConfig": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestConfig()));
            }
            case "SpotFleetRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestId()));
            }
            case "SpotFleetRequestState": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestStateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActivityStatus", ACTIVITY_STATUS_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("SpotFleetRequestConfig", SPOT_FLEET_REQUEST_CONFIG_FIELD);
        map.put("SpotFleetRequestId", SPOT_FLEET_REQUEST_ID_FIELD);
        map.put("SpotFleetRequestState", SPOT_FLEET_REQUEST_STATE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpotFleetRequestConfig, T> g) {
        return obj -> g.apply((SpotFleetRequestConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activityStatus;
        private Instant createTime;
        private SpotFleetRequestConfigData spotFleetRequestConfig;
        private String spotFleetRequestId;
        private String spotFleetRequestState;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfig model) {
            this.activityStatus(model.activityStatus);
            this.createTime(model.createTime);
            this.spotFleetRequestConfig(model.spotFleetRequestConfig);
            this.spotFleetRequestId(model.spotFleetRequestId);
            this.spotFleetRequestState(model.spotFleetRequestState);
            this.tags(model.tags);
        }

        public final String getActivityStatus() {
            return this.activityStatus;
        }

        public final void setActivityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
        }

        @Override
        public final Builder activityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
            return this;
        }

        @Override
        public final Builder activityStatus(ActivityStatus activityStatus) {
            this.activityStatus(activityStatus == null ? null : activityStatus.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final SpotFleetRequestConfigData.Builder getSpotFleetRequestConfig() {
            return this.spotFleetRequestConfig != null ? this.spotFleetRequestConfig.toBuilder() : null;
        }

        public final void setSpotFleetRequestConfig(SpotFleetRequestConfigData.BuilderImpl spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig != null ? spotFleetRequestConfig.build() : null;
        }

        @Override
        public final Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
            return this;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final String getSpotFleetRequestState() {
            return this.spotFleetRequestState;
        }

        public final void setSpotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
        }

        @Override
        public final Builder spotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
            return this;
        }

        @Override
        public final Builder spotFleetRequestState(BatchState spotFleetRequestState) {
            this.spotFleetRequestState(spotFleetRequestState == null ? null : spotFleetRequestState.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SpotFleetRequestConfig build() {
            return new SpotFleetRequestConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpotFleetRequestConfig> {
        public Builder activityStatus(String var1);

        public Builder activityStatus(ActivityStatus var1);

        public Builder createTime(Instant var1);

        public Builder spotFleetRequestConfig(SpotFleetRequestConfigData var1);

        default public Builder spotFleetRequestConfig(Consumer<SpotFleetRequestConfigData.Builder> spotFleetRequestConfig) {
            return this.spotFleetRequestConfig((SpotFleetRequestConfigData)((SpotFleetRequestConfigData.Builder)SpotFleetRequestConfigData.builder().applyMutation(spotFleetRequestConfig)).build());
        }

        public Builder spotFleetRequestId(String var1);

        public Builder spotFleetRequestState(String var1);

        public Builder spotFleetRequestState(BatchState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

