/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityReservationStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityReservationStatus> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationId").getter(CapacityReservationStatus.getter(CapacityReservationStatus::capacityReservationId)).setter(CapacityReservationStatus.setter(Builder::capacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId").unmarshallLocationName("capacityReservationId").build()}).build();
    private static final SdkField<Integer> TOTAL_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCapacity").getter(CapacityReservationStatus.getter(CapacityReservationStatus::totalCapacity)).setter(CapacityReservationStatus.setter(Builder::totalCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCapacity").unmarshallLocationName("totalCapacity").build()}).build();
    private static final SdkField<Integer> TOTAL_AVAILABLE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalAvailableCapacity").getter(CapacityReservationStatus.getter(CapacityReservationStatus::totalAvailableCapacity)).setter(CapacityReservationStatus.setter(Builder::totalAvailableCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAvailableCapacity").unmarshallLocationName("totalAvailableCapacity").build()}).build();
    private static final SdkField<Integer> TOTAL_UNAVAILABLE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalUnavailableCapacity").getter(CapacityReservationStatus.getter(CapacityReservationStatus::totalUnavailableCapacity)).setter(CapacityReservationStatus.setter(Builder::totalUnavailableCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalUnavailableCapacity").unmarshallLocationName("totalUnavailableCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD, TOTAL_CAPACITY_FIELD, TOTAL_AVAILABLE_CAPACITY_FIELD, TOTAL_UNAVAILABLE_CAPACITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityReservationStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityReservationId;
    private final Integer totalCapacity;
    private final Integer totalAvailableCapacity;
    private final Integer totalUnavailableCapacity;

    private CapacityReservationStatus(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.totalCapacity = builder.totalCapacity;
        this.totalAvailableCapacity = builder.totalAvailableCapacity;
        this.totalUnavailableCapacity = builder.totalUnavailableCapacity;
    }

    public final String capacityReservationId() {
        return this.capacityReservationId;
    }

    public final Integer totalCapacity() {
        return this.totalCapacity;
    }

    public final Integer totalAvailableCapacity() {
        return this.totalAvailableCapacity;
    }

    public final Integer totalUnavailableCapacity() {
        return this.totalUnavailableCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAvailableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalUnavailableCapacity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationStatus)) {
            return false;
        }
        CapacityReservationStatus other = (CapacityReservationStatus)obj;
        return Objects.equals(this.capacityReservationId(), other.capacityReservationId()) && Objects.equals(this.totalCapacity(), other.totalCapacity()) && Objects.equals(this.totalAvailableCapacity(), other.totalAvailableCapacity()) && Objects.equals(this.totalUnavailableCapacity(), other.totalUnavailableCapacity());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityReservationStatus").add("CapacityReservationId", (Object)this.capacityReservationId()).add("TotalCapacity", (Object)this.totalCapacity()).add("TotalAvailableCapacity", (Object)this.totalAvailableCapacity()).add("TotalUnavailableCapacity", (Object)this.totalUnavailableCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationId()));
            }
            case "TotalCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalCapacity()));
            }
            case "TotalAvailableCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalAvailableCapacity()));
            }
            case "TotalUnavailableCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalUnavailableCapacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("TotalCapacity", TOTAL_CAPACITY_FIELD);
        map.put("TotalAvailableCapacity", TOTAL_AVAILABLE_CAPACITY_FIELD);
        map.put("TotalUnavailableCapacity", TOTAL_UNAVAILABLE_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationStatus, T> g) {
        return obj -> g.apply((CapacityReservationStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityReservationId;
        private Integer totalCapacity;
        private Integer totalAvailableCapacity;
        private Integer totalUnavailableCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationStatus model) {
            this.capacityReservationId(model.capacityReservationId);
            this.totalCapacity(model.totalCapacity);
            this.totalAvailableCapacity(model.totalAvailableCapacity);
            this.totalUnavailableCapacity(model.totalUnavailableCapacity);
        }

        public final String getCapacityReservationId() {
            return this.capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final Integer getTotalCapacity() {
            return this.totalCapacity;
        }

        public final void setTotalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
        }

        @Override
        public final Builder totalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
            return this;
        }

        public final Integer getTotalAvailableCapacity() {
            return this.totalAvailableCapacity;
        }

        public final void setTotalAvailableCapacity(Integer totalAvailableCapacity) {
            this.totalAvailableCapacity = totalAvailableCapacity;
        }

        @Override
        public final Builder totalAvailableCapacity(Integer totalAvailableCapacity) {
            this.totalAvailableCapacity = totalAvailableCapacity;
            return this;
        }

        public final Integer getTotalUnavailableCapacity() {
            return this.totalUnavailableCapacity;
        }

        public final void setTotalUnavailableCapacity(Integer totalUnavailableCapacity) {
            this.totalUnavailableCapacity = totalUnavailableCapacity;
        }

        @Override
        public final Builder totalUnavailableCapacity(Integer totalUnavailableCapacity) {
            this.totalUnavailableCapacity = totalUnavailableCapacity;
            return this;
        }

        public CapacityReservationStatus build() {
            return new CapacityReservationStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityReservationStatus> {
        public Builder capacityReservationId(String var1);

        public Builder totalCapacity(Integer var1);

        public Builder totalAvailableCapacity(Integer var1);

        public Builder totalUnavailableCapacity(Integer var1);
    }
}

