"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVER_DELAY = exports.REQUEST = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OPENSEARCH_API = exports.NODE_API = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'notificationsDashboards';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'notifications-dashboards';

// after delete operation returns, a delay is needed before the change reflects in another request
const SERVER_DELAY = exports.SERVER_DELAY = 1000;
const NODE_API_BASE_PATH = '/api/notifications';
const NODE_API = exports.NODE_API = Object.freeze({
  GET_CONFIGS: `${NODE_API_BASE_PATH}/get_configs`,
  GET_CONFIG: `${NODE_API_BASE_PATH}/get_config`,
  CREATE_CONFIG: `${NODE_API_BASE_PATH}/create_config`,
  DELETE_CONFIGS: `${NODE_API_BASE_PATH}/delete_configs`,
  UPDATE_CONFIG: `${NODE_API_BASE_PATH}/update_config`,
  GET_EVENT: `${NODE_API_BASE_PATH}/get_event`,
  GET_AVAILABLE_FEATURES: `${NODE_API_BASE_PATH}/features`,
  SEND_TEST_MESSAGE: `${NODE_API_BASE_PATH}/test_message`
});
const OPENSEARCH_API_BASE_PATH = '/_plugins/_notifications';
const OPENSEARCH_API = exports.OPENSEARCH_API = Object.freeze({
  CONFIGS: `${OPENSEARCH_API_BASE_PATH}/configs`,
  EVENTS: `${OPENSEARCH_API_BASE_PATH}/events`,
  TEST_MESSAGE: `${OPENSEARCH_API_BASE_PATH}/feature/test`,
  FEATURES: `${OPENSEARCH_API_BASE_PATH}/features`
});
const REQUEST = exports.REQUEST = Object.freeze({
  PUT: 'PUT',
  DELETE: 'DELETE',
  GET: 'GET',
  POST: 'POST',
  HEAD: 'HEAD'
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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