"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiRangeDraggable", {
  enumerable: true,
  get: function get() {
    return _range_draggable.EuiRangeDraggable;
  }
});
exports.OuiRangeDraggable = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _range_draggable = require("../../../eui_components/form/range/range_draggable");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var OuiRangeDraggable = function OuiRangeDraggable(_ref) {
  var className = _ref.className,
    showTicks = _ref.showTicks,
    lowerPosition = _ref.lowerPosition,
    upperPosition = _ref.upperPosition,
    compressed = _ref.compressed,
    onChange = _ref.onChange,
    min = _ref.min,
    max = _ref.max,
    disabled = _ref.disabled,
    value = _ref.value,
    rest = _objectWithoutProperties(_ref, ["className", "showTicks", "lowerPosition", "upperPosition", "compressed", "onChange", "min", "max", "disabled", "value"]);
  var outerStyle = {
    left: "calc(".concat(lowerPosition, ")"),
    right: "calc(100% - ".concat(upperPosition, " - 16px)")
  };
  var classes = (0, _classnames.default)('ouiRangeDraggable', {
    'ouiRangeDraggable--hasTicks': showTicks,
    'ouiRangeDraggable--compressed': compressed,
    'ouiRangeDraggable--disabled': disabled
  }, className);
  var handleChange = function handleChange(_ref2, isFirstInteraction) {
    var x = _ref2.x;
    if (disabled) return;
    onChange(x, isFirstInteraction);
  };
  var _useMouseMove = (0, _services.useMouseMove)(handleChange),
    _useMouseMove2 = _slicedToArray(_useMouseMove, 2),
    handleMouseDown = _useMouseMove2[0],
    handleInteraction = _useMouseMove2[1];
  var commonProps = {
    className: classes,
    role: 'slider',
    'aria-valuemin': min,
    'aria-valuemax': max,
    'aria-valuenow': value[0],
    'aria-valuetext': "".concat(value[0], ", ").concat(value[1]),
    'aria-disabled': !!disabled,
    tabIndex: !!disabled ? -1 : 0
  };
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    style: outerStyle
  }, commonProps, rest), /*#__PURE__*/_react.default.createElement("div", {
    className: "ouiRangeDraggle__inner",
    onMouseDown: handleMouseDown,
    onTouchStart: handleInteraction,
    onTouchMove: handleInteraction
  }));
};

/* OUI -> EUI Aliases: Build-Time */
exports.OuiRangeDraggable = OuiRangeDraggable;
OuiRangeDraggable.propTypes = {
  min: _propTypes.default.number.isRequired,
  max: _propTypes.default.number.isRequired,
  value: _propTypes.default.arrayOf(_propTypes.default.number.isRequired).isRequired,
  disabled: _propTypes.default.bool,
  compressed: _propTypes.default.bool,
  showTicks: _propTypes.default.bool,
  lowerPosition: _propTypes.default.string.isRequired,
  upperPosition: _propTypes.default.string.isRequired,
  onChange: _propTypes.default.func.isRequired
};
/* OUI -> EUI Aliases: Build-Time */